/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertCollectionToArrayFix
implements IntentionAction {
    private final PsiExpression myCollectionExpression;
    private final PsiExpression myExpressionToReplace;
    private final String myNewArrayText;

    public ConvertCollectionToArrayFix(@NotNull PsiExpression collectionExpression, @NotNull PsiExpression expressionToReplace, @NotNull PsiArrayType arrayType) {
        if (collectionExpression == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(0);
        }
        if (expressionToReplace == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(1);
        }
        if (arrayType == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(2);
        }
        this.myCollectionExpression = collectionExpression;
        this.myExpressionToReplace = expressionToReplace;
        PsiType componentType = arrayType.getComponentType();
        this.myNewArrayText = componentType.equalsToText("java.lang.Object") ? "" : "new " + ConvertCollectionToArrayFix.getArrayTypeText(componentType);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("collection.to.array.text", this.myNewArrayText);
        if (string == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("collection.to.array.family.name", new Object[0]);
        if (string == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(5);
        }
        return this.myCollectionExpression.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myCollectionExpression) && this.myExpressionToReplace.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myExpressionToReplace);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(6);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String replacement = ParenthesesUtils.getText(this.myCollectionExpression, 2) + ".toArray(" + this.myNewArrayText + ")";
        this.myExpressionToReplace.replace((PsiElement)factory.createExpressionFromText(replacement, (PsiElement)this.myCollectionExpression));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static String getArrayTypeText(PsiType componentType) {
        if (componentType instanceof PsiArrayType) {
            String string = ConvertCollectionToArrayFix.getArrayTypeText(((PsiArrayType)componentType).getComponentType()) + "[]";
            if (string == null) {
                ConvertCollectionToArrayFix.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (componentType instanceof PsiClassType) {
            String string = ((PsiClassType)componentType).rawType().getCanonicalText() + "[0]";
            if (string == null) {
                ConvertCollectionToArrayFix.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = componentType.getCanonicalText() + "[0]";
        if (string == null) {
            ConvertCollectionToArrayFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToReplace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

