/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.AssignFieldFromParameterAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateConstructorParameterFromFieldFix
implements IntentionAction {
    private static final Key<Map<SmartPsiElementPointer<PsiField>, Boolean>> FIELDS = Key.create((String)"CONSTRUCTOR_PARAMS");
    private final SmartPsiElementPointer<PsiField> myField;
    private final PsiClass myClass;
    private int myConstructorsLength;

    public CreateConstructorParameterFromFieldFix(@NotNull PsiField field) {
        if (field == null) {
            CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(0);
        }
        this.myClass = field.getContainingClass();
        this.myField = SmartPointerManager.getInstance((Project)field.getProject()).createSmartPsiElementPointer((PsiElement)field);
        if (this.myClass != null) {
            this.getFieldsToFix().add(this.myField);
            this.myConstructorsLength = this.myClass.getConstructors().length;
        }
    }

    @NotNull
    public String getText() {
        if (this.getFieldsToFix().size() > 1 && this.myConstructorsLength <= 1) {
            if ("Add constructor parameters" == null) {
                CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(1);
            }
            return "Add constructor parameters";
        }
        String string = QuickFixBundle.message("add.constructor.parameter.name", new Object[0]);
        if (string == null) {
            CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(4);
        }
        return (this.myClass == null || this.myClass.isValid()) && CreateConstructorParameterFromFieldFix.isAvailable(this.getField());
    }

    private static boolean isAvailable(PsiField field) {
        PsiClass containingClass = field == null ? null : field.getContainingClass();
        return field != null && field.getManager().isInProject((PsiElement)field) && !field.hasModifierProperty("static") && containingClass != null && !(containingClass instanceof PsiSyntheticClass) && containingClass.getName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(5);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiMethod[] constructors = this.myClass.getConstructors();
        if (constructors.length == 0) {
            AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(this.myClass);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project2 == null) {
                    CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(7);
                }
                defaultConstructorFix.invoke(project2, editor, file2);
            });
            constructors = this.myClass.getConstructors();
        }
        Arrays.sort(constructors, new Comparator<PsiMethod>(){

            @Override
            public int compare(PsiMethod c1, PsiMethod c2) {
                PsiMethod cc1 = RefactoringUtil.getChainedConstructor(c1);
                PsiMethod cc2 = RefactoringUtil.getChainedConstructor(c2);
                if (cc1 == c2) {
                    return 1;
                }
                if (cc2 == c1) {
                    return -1;
                }
                if (cc1 == null) {
                    return cc2 == null ? 0 : this.compare(c1, cc2);
                }
                return cc2 == null ? this.compare(cc1, c2) : this.compare(cc1, cc2);
            }
        });
        ArrayList<SmartPsiElementPointer<PsiElement>> cleanupElements = new ArrayList<SmartPsiElementPointer<PsiElement>>();
        List<PsiMethod> filtered = CreateConstructorParameterFromFieldFix.filterConstructorsIfFieldAlreadyAssigned(constructors, this.getField());
        if (filtered.size() > 1) {
            PsiMethodMember member;
            Object chooser;
            List<PsiMethodMember> elements;
            ClassMember[] members = new PsiMethodMember[filtered.size()];
            int i = 0;
            for (PsiMethod constructor : filtered) {
                members[i++] = new PsiMethodMember(constructor);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                elements = Arrays.asList(members);
            } else {
                chooser = new MemberChooser(members, false, true, project2);
                chooser.setTitle("Choose Constructors to Add Parameter to");
                ((MemberChooser)((Object)chooser)).show();
                elements = ((MemberChooser)((Object)chooser)).getSelectedElements();
                if (elements == null) {
                    return;
                }
            }
            chooser = elements.iterator();
            while (chooser.hasNext() && CreateConstructorParameterFromFieldFix.addParameterToConstructor(project2, file2, editor, (PsiMethod)(member = (PsiMethodMember)chooser.next()).getElement(), new PsiField[]{this.getField()}, cleanupElements)) {
            }
        } else if (!filtered.isEmpty()) {
            Collection<SmartPsiElementPointer<PsiField>> fieldsToFix = this.getFieldsToFix();
            try {
                PsiField[] psiFieldArray;
                PsiMethod constructor = filtered.get(0);
                LinkedHashSet<Object> fields = new LinkedHashSet<Object>();
                this.getFieldsToFix().add(this.myField);
                for (SmartPsiElementPointer<PsiField> elementPointer : fieldsToFix) {
                    PsiField field = (PsiField)elementPointer.getElement();
                    if (field == null || !CreateConstructorParameterFromFieldFix.isAvailable(field) || !CreateConstructorParameterFromFieldFix.filterConstructorsIfFieldAlreadyAssigned(new PsiMethod[]{constructor}, field).contains(constructor)) continue;
                    fields.add(field);
                }
                if (filtered.size() == constructors.length && fields.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    ClassMember[] members = new PsiFieldMember[fields.size()];
                    int i = 0;
                    for (PsiField psiField : fields) {
                        members[i++] = new PsiFieldMember(psiField);
                    }
                    MemberChooser chooser = new MemberChooser(members, false, true, project2);
                    chooser.setTitle("Choose Fields to Generate Constructor Parameters for");
                    chooser.show();
                    if (chooser.getExitCode() != 0) {
                        return;
                    }
                    List list2 = chooser.getSelectedElements();
                    if (list2 == null) {
                        return;
                    }
                    fields.clear();
                    for (PsiElementClassMember member : list2) {
                        fields.add((PsiField)member.getElement());
                    }
                }
                if (filtered.size() == constructors.length) {
                    psiFieldArray = fields.toArray(new PsiField[fields.size()]);
                } else {
                    PsiField[] psiFieldArray2 = new PsiField[1];
                    psiFieldArray = psiFieldArray2;
                    psiFieldArray2[0] = this.getField();
                }
                CreateConstructorParameterFromFieldFix.addParameterToConstructor(project2, file2, editor, constructor, psiFieldArray, cleanupElements);
            }
            finally {
                fieldsToFix.clear();
            }
        }
        GlobalInspectionContextBase.cleanupElements(project2, null, cleanupElements);
    }

    @NotNull
    private Collection<SmartPsiElementPointer<PsiField>> getFieldsToFix() {
        Map fields = (Map)this.myClass.getUserData(FIELDS);
        if (fields == null) {
            fields = ContainerUtil.createConcurrentWeakMap();
            this.myClass.putUserData(FIELDS, (Object)fields);
        }
        final Map finalFields = fields;
        AbstractCollection<SmartPsiElementPointer<PsiField>> abstractCollection = new AbstractCollection<SmartPsiElementPointer<PsiField>>(){

            @Override
            public boolean add(SmartPsiElementPointer<PsiField> psiVariable) {
                PsiField field = (PsiField)psiVariable.getElement();
                if (field == null || !CreateConstructorParameterFromFieldFix.isAvailable(field)) {
                    return false;
                }
                return finalFields.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            @NotNull
            public Iterator<SmartPsiElementPointer<PsiField>> iterator() {
                Iterator<SmartPsiElementPointer<PsiField>> iterator = finalFields.keySet().iterator();
                if (iterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @Override
            public int size() {
                return finalFields.size();
            }

            @Override
            public void clear() {
                finalFields.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix$2", "iterator"));
            }
        };
        if (abstractCollection == null) {
            CreateConstructorParameterFromFieldFix.$$$reportNull$$$0(6);
        }
        return abstractCollection;
    }

    private static List<PsiMethod> filterConstructorsIfFieldAlreadyAssigned(PsiMethod[] constructors, PsiField field) {
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>(Arrays.asList(constructors));
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])constructors))) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) continue;
            result2.remove(PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addParameterToConstructor(Project project2, PsiFile file2, Editor editor, PsiMethod constructor, PsiField[] fields, List<SmartPsiElementPointer<PsiElement>> cleanupElements) throws IncorrectOperationException {
        PsiParameterList parameterList = constructor.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        ParameterInfoImpl[] newParamInfos = new ParameterInfoImpl[parameters2.length + fields.length];
        ArrayList<PsiParameter> params = new ArrayList<PsiParameter>(Arrays.asList(parameters2));
        Collections.addAll(params, fields);
        Collections.sort(params, new FieldParameterComparator(parameterList));
        int i = 0;
        HashMap<PsiField, String> usedFields = new HashMap<PsiField, String>();
        MultiMap types = new MultiMap();
        for (PsiVariable psiVariable : params) {
            types.putValue((Object)psiVariable.getType(), (Object)psiVariable);
        }
        JavaCodeStyleSettings settings = (JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(JavaCodeStyleSettings.class);
        boolean bl = settings.PREFER_LONGER_NAMES;
        for (PsiVariable psiVariable : params) {
            PsiType paramType = psiVariable.getType();
            if (psiVariable instanceof PsiParameter) {
                newParamInfos[i++] = new ParameterInfoImpl(parameterList.getParameterIndex((PsiParameter)psiVariable), psiVariable.getName(), paramType, psiVariable.getName());
                continue;
            }
            try {
                settings.PREFER_LONGER_NAMES = bl || types.get((Object)paramType).size() > 1;
                String uniqueParameterName = CreateConstructorParameterFromFieldFix.getUniqueParameterName(parameters2, psiVariable, usedFields);
                usedFields.put((PsiField)psiVariable, uniqueParameterName);
                newParamInfos[i++] = new ParameterInfoImpl(-1, uniqueParameterName, paramType, uniqueParameterName);
            }
            finally {
                settings.PREFER_LONGER_NAMES = bl;
            }
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
        SmartPsiElementPointer smartPsiElementPointer = manager.createSmartPsiElementPointer((PsiElement)constructor);
        PsiMethod fromText = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText(CreateConstructorParameterFromFieldFix.createDummyMethod(constructor, newParamInfos), (PsiElement)constructor);
        PsiClass containingClass = constructor.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        int minUsagesNumber = containingClass.findMethodsBySignature(fromText, false).length > 0 ? 0 : 1;
        List<ParameterInfoImpl> parameterInfos = ChangeMethodSignatureFromUsageFix.performChange(project2, editor, file2, constructor, minUsagesNumber, newParamInfos, true, true, (Consumer<List<ParameterInfoImpl>>)((Consumer)p -> {
            ParameterInfoImpl[] resultParams = p.toArray(new ParameterInfoImpl[0]);
            CreateConstructorParameterFromFieldFix.doCreate(project2, editor, parameters2, constructorPointer, resultParams, usedFields, cleanupElements);
        }));
        return parameterInfos != null;
    }

    private static String createDummyMethod(PsiMethod constructor, ParameterInfoImpl[] newParamInfos) {
        return constructor.getName() + "(" + StringUtil.join((Object[])newParamInfos, info -> info.getTypeText() + " " + info.getName(), (String)", ") + "){}";
    }

    private static String getUniqueParameterName(PsiParameter[] parameters2, PsiVariable variable, Map<PsiField, String> usedNames) {
        String name2 = variable.getName();
        assert (name2 != null) : variable;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
        name2 = styleManager.variableNameToPropertyName(name2, VariableKind.FIELD);
        SuggestedNameInfo nameInfo = styleManager.suggestVariableName(VariableKind.PARAMETER, name2, null, variable.getType());
        String newName = nameInfo.names[0];
        int n = 1;
        while (!CreateConstructorParameterFromFieldFix.isUnique(parameters2, newName, usedNames)) {
            newName = n < nameInfo.names.length && !((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)variable.getProject()).getCustomSettings(JavaCodeStyleSettings.class)).PREFER_LONGER_NAMES ? nameInfo.names[n++] : nameInfo.names[0] + n++;
        }
        return newName;
    }

    private static boolean isUnique(PsiParameter[] params, String newName, Map<PsiField, String> usedNames) {
        if (usedNames.containsValue(newName)) {
            return false;
        }
        for (PsiParameter parameter2 : params) {
            if (!Comparing.strEqual((String)parameter2.getName(), (String)newName)) continue;
            return false;
        }
        return true;
    }

    private static boolean doCreate(Project project2, Editor editor, PsiParameter[] parameters2, SmartPsiElementPointer constructorPointer, ParameterInfoImpl[] parameterInfos, Map<PsiField, String> fields, List<SmartPsiElementPointer<PsiElement>> cleanupElements) {
        PsiMethod constructor = (PsiMethod)constructorPointer.getElement();
        assert (constructor != null);
        PsiParameter[] newParameters = constructor.getParameterList().getParameters();
        if (newParameters == parameters2) {
            return false;
        }
        if (JavaHighlightUtil.getChainedConstructors(constructor) == null) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
            boolean created = false;
            for (PsiField field : fields.keySet()) {
                String defaultParamName = fields.get(field);
                PsiParameter parameter2 = CreateConstructorParameterFromFieldFix.findParamByName(defaultParamName, field.getType(), newParameters, parameterInfos);
                if (parameter2 == null) continue;
                NullableNotNullManager.getInstance((Project)field.getProject()).copyNullableOrNotNullAnnotation((PsiModifierListOwner)field, (PsiModifierListOwner)parameter2);
                cleanupElements.add((SmartPsiElementPointer<PsiElement>)manager.createSmartPsiElementPointer((PsiElement)parameter2));
                PsiElement assignmentStatement = AssignFieldFromParameterAction.addFieldAssignmentStatement(project2, field, parameter2, editor);
                if (assignmentStatement != null) {
                    cleanupElements.add((SmartPsiElementPointer<PsiElement>)manager.createSmartPsiElementPointer(assignmentStatement));
                }
                created = true;
            }
            return created;
        }
        return true;
    }

    @Nullable
    private static PsiParameter findParamByName(String newName, PsiType type2, PsiParameter[] newParameters, ParameterInfoImpl[] parameterInfos) {
        for (PsiParameter newParameter : newParameters) {
            if (!Comparing.strEqual((String)newName, (String)newParameter.getName())) continue;
            return newParameter;
        }
        for (int i = 0; i < newParameters.length; ++i) {
            if (parameterInfos[i].getOldIndex() != -1) continue;
            PsiParameter parameter2 = newParameters[i];
            PsiType paramType = parameterInfos[i].getTypeWrapper().getType((PsiElement)parameter2);
            if (!type2.isAssignableFrom(paramType)) continue;
            return parameter2;
        }
        return null;
    }

    private PsiField getField() {
        return (PsiField)this.myField.getElement();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsToFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldParameterComparator
    implements Comparator<PsiVariable> {
        private final PsiParameterList myParameterList;

        public FieldParameterComparator(PsiParameterList parameterList) {
            this.myParameterList = parameterList;
        }

        @Override
        public int compare(PsiVariable o1, PsiVariable o2) {
            if (o1 instanceof PsiParameter && ((PsiParameter)o1).isVarArgs()) {
                return 1;
            }
            if (o2 instanceof PsiParameter && ((PsiParameter)o2).isVarArgs()) {
                return -1;
            }
            if (o1 instanceof PsiField && o2 instanceof PsiField) {
                return o1.getTextOffset() - o2.getTextOffset();
            }
            if (o1 instanceof PsiParameter && o2 instanceof PsiParameter) {
                return this.myParameterList.getParameterIndex((PsiParameter)o1) - this.myParameterList.getParameterIndex((PsiParameter)o2);
            }
            if (o1 instanceof PsiField && o2 instanceof PsiParameter) {
                PsiField field = FieldFromParameterUtils.getParameterAssignedToField((PsiParameter)o2);
                if (field == null) {
                    return 1;
                }
                return o1.getTextOffset() - field.getTextOffset();
            }
            if (o1 instanceof PsiParameter && o2 instanceof PsiField) {
                PsiField field = FieldFromParameterUtils.getParameterAssignedToField((PsiParameter)o1);
                if (field == null) {
                    return -1;
                }
                return field.getTextOffset() - o2.getTextOffset();
            }
            return 0;
        }
    }
}

