/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLocalVarFromInstanceofAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalVarFromInstanceofAction");

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiInstanceOfExpression instanceOfExpression;
        if (project2 == null) {
            CreateLocalVarFromInstanceofAction.$$$reportNull$$$0(0);
        }
        if ((instanceOfExpression = CreateLocalVarFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file2)) == null) {
            return false;
        }
        PsiTypeElement checkType = instanceOfExpression.getCheckType();
        if (checkType == null) {
            return false;
        }
        PsiExpression operand2 = instanceOfExpression.getOperand();
        PsiType operandType = operand2.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType)) {
            return false;
        }
        PsiType type2 = checkType.getType();
        String castTo = type2.getPresentableText();
        this.setText(QuickFixBundle.message("create.local.from.instanceof.usage.text", castTo, operand2.getText()));
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)instanceOfExpression, PsiStatement.class);
        boolean insideIf = statement2 instanceof PsiIfStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiIfStatement)statement2).getCondition(), (PsiElement)instanceOfExpression, (boolean)false);
        boolean insideWhile = statement2 instanceof PsiWhileStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiWhileStatement)statement2).getCondition(), (PsiElement)instanceOfExpression, (boolean)false);
        return (insideIf || insideWhile) && !CreateLocalVarFromInstanceofAction.isAlreadyCastedTo(type2, instanceOfExpression, statement2);
    }

    private static boolean isAlreadyCastedTo(PsiType type2, PsiInstanceOfExpression instanceOfExpression, PsiStatement statement2) {
        boolean negated = CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression);
        PsiStatement anchor = null;
        if (negated) {
            PsiElement parent = statement2.getParent();
            if (parent instanceof PsiCodeBlock) {
                Object[] statements = ((PsiCodeBlock)parent).getStatements();
                int i = ArrayUtil.find((Object[])statements, (Object)statement2);
                anchor = i != -1 && i < statements.length - 1 ? statements[i + 1] : null;
            }
        } else {
            PsiStatement psiStatement = anchor = statement2 instanceof PsiIfStatement ? ((PsiIfStatement)statement2).getThenBranch() : ((PsiWhileStatement)statement2).getBody();
        }
        if (anchor instanceof PsiBlockStatement) {
            anchor = ((PsiBlockStatement)anchor).getCodeBlock();
        }
        if (anchor instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)anchor).getStatements();
            if (statements.length == 0) {
                return false;
            }
            anchor = statements[0];
        }
        if (anchor instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements;
            for (PsiElement element : declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()) {
                PsiType castType;
                PsiTypeElement castTypeElement;
                PsiTypeCastExpression typeCastExpression;
                PsiExpression operand2;
                PsiExpression initializer;
                if (!(element instanceof PsiLocalVariable) || !((initializer = ((PsiLocalVariable)element).getInitializer()) instanceof PsiTypeCastExpression) || (operand2 = (typeCastExpression = (PsiTypeCastExpression)initializer).getOperand()) != null && !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)operand2, (PsiElement)instanceOfExpression.getOperand()) || (castTypeElement = typeCastExpression.getCastType()) == null || !(castType = castTypeElement.getType()).equals(type2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    static PsiInstanceOfExpression getInstanceOfExpressionAtCaret(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiInstanceOfExpression expression2 = (PsiInstanceOfExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiInstanceOfExpression.class);
        if (expression2 != null) {
            return expression2;
        }
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiWhileStatement.class});
        if (statement2 instanceof PsiIfStatement) {
            PsiExpression condition2 = ((PsiIfStatement)statement2).getCondition();
            return CreateLocalVarFromInstanceofAction.retrieveInstanceOfFromCondition(editor, element, statement2, condition2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiExpression condition3 = ((PsiWhileStatement)statement2).getCondition();
            return CreateLocalVarFromInstanceofAction.retrieveInstanceOfFromCondition(editor, element, statement2, condition3);
        }
        return null;
    }

    @Nullable
    private static PsiInstanceOfExpression retrieveInstanceOfFromCondition(Editor editor, PsiElement element, PsiStatement statement2, PsiExpression condition2) {
        if (condition2 instanceof PsiInstanceOfExpression) {
            if (CreateLocalVarFromInstanceofAction.atSameLine(condition2, editor) || CreateLocalVarFromInstanceofAction.insideEmptyBlockOrRef(statement2, element, (PsiInstanceOfExpression)condition2)) {
                return (PsiInstanceOfExpression)condition2;
            }
        } else if (condition2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands2 = ((PsiPolyadicExpression)condition2).getOperands();
            if (((PsiPolyadicExpression)condition2).getOperationTokenType() == JavaTokenType.ANDAND) {
                PsiInstanceOfExpression expr = null;
                for (PsiExpression operand2 : operands2) {
                    if (!(operand2 instanceof PsiInstanceOfExpression)) continue;
                    if (expr != null) {
                        expr = null;
                        break;
                    }
                    expr = (PsiInstanceOfExpression)operand2;
                }
                if (expr != null && CreateLocalVarFromInstanceofAction.insideEmptyBlockOrRef(statement2, element, expr)) {
                    return expr;
                }
            }
        }
        return null;
    }

    private static boolean insideEmptyBlockOrRef(PsiStatement stmt, PsiElement elementAtCaret, PsiInstanceOfExpression instanceOfExpression) {
        PsiBlockStatement block = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiBlockStatement.class);
        if (block != null && block.getParent() == stmt) {
            PsiStatement[] statements = block.getCodeBlock().getStatements();
            if (statements.length == 0) {
                return true;
            }
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                return CreateLocalVarFromInstanceofAction.replaceReference(instanceOfExpression, (PsiExpressionStatement)statements[0]);
            }
        }
        return false;
    }

    private static boolean replaceReference(PsiInstanceOfExpression instanceOfExpression, PsiExpressionStatement statement2) {
        if (CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression)) {
            return false;
        }
        PsiExpression expression2 = statement2.getExpression();
        PsiExpression operand2 = instanceOfExpression.getOperand();
        return operand2 instanceof PsiReferenceExpression && expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)operand2).resolve() == ((PsiReferenceExpression)expression2).resolve();
    }

    private static boolean atSameLine(PsiExpression condition2, Editor editor) {
        int line = editor.getCaretModel().getLogicalPosition().line;
        return editor.getDocument().getLineNumber(condition2.getTextOffset()) == line;
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2) {
        if (project2 == null) {
            CreateLocalVarFromInstanceofAction.$$$reportNull$$$0(1);
        }
        PsiInstanceOfExpression instanceOfExpression = CreateLocalVarFromInstanceofAction.getInstanceOfExpressionAtCaret(editor, file2);
        assert (instanceOfExpression.getContainingFile() == file2) : instanceOfExpression.getContainingFile() + "; file=" + file2;
        try {
            PsiStatement statementInside = CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression) ? null : CreateLocalVarFromInstanceofAction.getExpressionStatementInside(file2, editor, instanceOfExpression.getOperand());
            PsiDeclarationStatement decl = CreateLocalVarFromInstanceofAction.createLocalVariableDeclaration(instanceOfExpression, statementInside);
            if (decl == null) {
                return;
            }
            decl = (PsiDeclarationStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)decl);
            decl = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(decl);
            PsiLocalVariable localVariable = (PsiLocalVariable)decl.getDeclaredElements()[0];
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)localVariable);
            builder.setEndVariableAfter((PsiElement)localVariable.getNameIdentifier());
            Template template = CreateLocalVarFromInstanceofAction.generateTemplate(project2, localVariable.getInitializer(), localVariable.getType());
            Editor newEditor = CreateFromUsageBaseFix.positionCursor(project2, file2, (PsiElement)localVariable.getNameIdentifier());
            if (newEditor == null) {
                return;
            }
            TextRange range = localVariable.getNameIdentifier().getTextRange();
            newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
            CreateFromUsageBaseFix.startTemplate(newEditor, template, project2, new TemplateEditingAdapter(){

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (project2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                        CaretModel caretModel = editor.getCaretModel();
                        PsiElement elementAt = file2.findElementAt(caretModel.getOffset());
                        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiDeclarationStatement.class);
                        if (declarationStatement != null) {
                            caretModel.moveToOffset(declarationStatement.getTextRange().getEndOffset());
                        }
                        new EnterAction().actionPerformed(editor, DataManager.getInstance().getDataContext());
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction$1", "lambda$templateFinished$0"));
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    protected static PsiStatement getExpressionStatementInside(PsiFile file2, Editor editor, @NotNull PsiExpression operand2) {
        PsiStatement[] statements;
        PsiElement elementAt;
        PsiBlockStatement blockStatement;
        if (operand2 == null) {
            CreateLocalVarFromInstanceofAction.$$$reportNull$$$0(2);
        }
        if ((blockStatement = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = file2.findElementAt(editor.getCaretModel().getOffset())), PsiBlockStatement.class)) == null) {
            PsiIfStatement ifStm = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiIfStatement.class);
            if (ifStm != null) {
                PsiStatement thenBranch = ifStm.getThenBranch();
                if (thenBranch instanceof PsiBlockStatement) {
                    blockStatement = (PsiBlockStatement)thenBranch;
                }
            } else {
                PsiStatement body2;
                PsiWhileStatement whileStatement = (PsiWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiWhileStatement.class);
                if (whileStatement != null && (body2 = whileStatement.getBody()) instanceof PsiBlockStatement) {
                    blockStatement = (PsiBlockStatement)body2;
                }
            }
        }
        if (blockStatement != null && (statements = blockStatement.getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiExpressionStatement && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiExpressionStatement)statements[0]).getExpression(), (PsiElement)operand2)) {
            return statements[0];
        }
        return null;
    }

    @Nullable
    private static PsiDeclarationStatement createLocalVariableDeclaration(PsiInstanceOfExpression instanceOfExpression, PsiStatement statementInside) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)instanceOfExpression.getProject()).getElementFactory();
        PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(a)b", (PsiElement)instanceOfExpression);
        PsiType castType = instanceOfExpression.getCheckType().getType();
        cast.getCastType().replace((PsiElement)factory.createTypeElement(castType));
        cast.getOperand().replace((PsiElement)instanceOfExpression.getOperand());
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement("xxx", castType, (PsiExpression)cast);
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS;
        if (createFinals != null) {
            PsiElement[] declaredElements = decl.getDeclaredElements();
            LOG.assertTrue(declaredElements.length == 1);
            LOG.assertTrue(declaredElements[0] instanceof PsiLocalVariable);
            PsiModifierList modifierList = ((PsiLocalVariable)declaredElements[0]).getModifierList();
            LOG.assertTrue(modifierList != null);
            modifierList.setModifierProperty("final", createFinals.booleanValue());
        }
        if (statementInside != null) {
            return (PsiDeclarationStatement)statementInside.replace((PsiElement)decl);
        }
        return (PsiDeclarationStatement)CreateLocalVarFromInstanceofAction.insertAtAnchor(instanceOfExpression, (PsiElement)decl);
    }

    @Nullable
    static PsiElement insertAtAnchor(PsiInstanceOfExpression instanceOfExpression, PsiElement toInsert) throws IncorrectOperationException {
        boolean negated = CreateLocalVarFromInstanceofAction.isNegated(instanceOfExpression);
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)instanceOfExpression, PsiStatement.class);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)toInsert.getProject()).getElementFactory();
        PsiIfStatement anchorAfter = null;
        PsiBlockStatement emptyBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)instanceOfExpression);
        if (statement2 instanceof PsiIfStatement) {
            PsiBlockStatement newBranch;
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            if (negated) {
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch == null) {
                    anchorAfter = ifStatement;
                } else if (!(elseBranch instanceof PsiBlockStatement)) {
                    emptyBlockStatement.getCodeBlock().add((PsiElement)elseBranch);
                    newBranch = (PsiBlockStatement)elseBranch.replace((PsiElement)emptyBlockStatement);
                    CreateLocalVarFromInstanceofAction.reformatNewCodeBlockBraces((PsiElement)ifStatement.getElseElement(), newBranch);
                    anchorAfter = newBranch.getCodeBlock().getLBrace();
                } else {
                    anchorAfter = ((PsiBlockStatement)elseBranch).getCodeBlock().getLBrace();
                }
            } else {
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (thenBranch == null) {
                    ifStatement.setThenBranch((PsiStatement)emptyBlockStatement);
                    PsiBlockStatement then = (PsiBlockStatement)ifStatement.getThenBranch();
                    CreateLocalVarFromInstanceofAction.reformatNewCodeBlockBraces((PsiElement)ifStatement.getCondition(), then);
                    anchorAfter = then.getCodeBlock().getLBrace();
                } else if (!(thenBranch instanceof PsiBlockStatement)) {
                    emptyBlockStatement.getCodeBlock().add((PsiElement)thenBranch);
                    newBranch = (PsiBlockStatement)thenBranch.replace((PsiElement)emptyBlockStatement);
                    CreateLocalVarFromInstanceofAction.reformatNewCodeBlockBraces((PsiElement)ifStatement.getCondition(), newBranch);
                    anchorAfter = newBranch.getCodeBlock().getLBrace();
                } else {
                    anchorAfter = ((PsiBlockStatement)thenBranch).getCodeBlock().getLBrace();
                }
            }
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            LOG.assertTrue(whileStatement.getLParenth() != null);
            LOG.assertTrue(whileStatement.getCondition() != null);
            if (whileStatement.getRParenth() == null) {
                PsiWhileStatement statementPattern = (PsiWhileStatement)factory.createStatementFromText("while (){}", (PsiElement)instanceOfExpression);
                whileStatement.addAfter((PsiElement)statementPattern.getRParenth(), (PsiElement)whileStatement.getCondition());
            }
            if (negated) {
                anchorAfter = whileStatement;
            } else {
                PsiStatement body2 = whileStatement.getBody();
                if (body2 == null) {
                    whileStatement.add((PsiElement)emptyBlockStatement);
                } else if (!(body2 instanceof PsiBlockStatement)) {
                    emptyBlockStatement.getCodeBlock().add((PsiElement)body2);
                    whileStatement.getBody().replace((PsiElement)emptyBlockStatement);
                }
                anchorAfter = ((PsiBlockStatement)whileStatement.getBody()).getCodeBlock().getLBrace();
            }
        }
        if (anchorAfter == null) {
            return null;
        }
        PsiElement nextSibling = anchorAfter.getNextSibling();
        while (nextSibling != null) {
            if (nextSibling instanceof PsiWhiteSpace) {
                String text2 = nextSibling.getText();
                if (StringUtil.countNewLines((CharSequence)text2) > 1) {
                    PsiElement newWhitespace = PsiParserFacade.SERVICE.getInstance((Project)nextSibling.getProject()).createWhiteSpaceFromText(text2.substring(0, text2.lastIndexOf(10)));
                    nextSibling.replace(newWhitespace);
                    break;
                }
                nextSibling = nextSibling.getNextSibling();
                continue;
            }
            if (!CreateLocalVarFromInstanceofAction.isValidDeclarationStatement(nextSibling) && !(nextSibling instanceof PsiComment)) break;
            anchorAfter = nextSibling;
            nextSibling = anchorAfter.getNextSibling();
        }
        return anchorAfter.getParent().addAfter(toInsert, (PsiElement)anchorAfter);
    }

    private static boolean isValidDeclarationStatement(PsiElement nextSibling) {
        if (!(nextSibling instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)nextSibling;
        PsiElement[] elements = declarationStatement.getDeclaredElements();
        if (elements.length == 0) {
            return false;
        }
        PsiElement lastElement = elements[elements.length - 1];
        return !(lastElement instanceof PsiClass) && PsiUtil.isJavaToken((PsiElement)lastElement.getLastChild(), (IElementType)JavaTokenType.SEMICOLON);
    }

    private static void reformatNewCodeBlockBraces(PsiElement start, PsiBlockStatement end) throws IncorrectOperationException {
        CodeStyleManager.getInstance((Project)end.getProject()).reformatRange((PsiElement)end.getContainingFile(), start.getTextRange().getEndOffset(), end.getTextRange().getStartOffset());
    }

    protected static boolean isNegated(PsiInstanceOfExpression instanceOfExpression) {
        PsiElement element = instanceOfExpression.getParent();
        while (element instanceof PsiParenthesizedExpression) {
            element = element.getParent();
        }
        return element instanceof PsiPrefixExpression && ((PsiPrefixExpression)element).getOperationTokenType() == JavaTokenType.EXCL;
    }

    private static Template generateTemplate(Project project2, PsiExpression initializer, PsiType type2) {
        TemplateManager templateManager = TemplateManager.getInstance(project2);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        SuggestedNameInfo suggestedNameInfo = IntroduceVariableBase.getSuggestedName(type2, initializer, (PsiElement)initializer);
        LinkedHashSet<LookupElementBuilder> itemSet = new LinkedHashSet<LookupElementBuilder>();
        for (String name2 : suggestedNameInfo.names) {
            itemSet.add(LookupElementBuilder.create((String)name2));
        }
        final LookupElement[] lookupItems = itemSet.toArray(new LookupElement[itemSet.size()]);
        TextResult result2 = suggestedNameInfo.names.length == 0 ? null : new TextResult(suggestedNameInfo.names[0]);
        Expression expr = new Expression((Result)result2){
            final /* synthetic */ Result val$result;
            {
                this.val$result = result2;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems.length > 1 ? lookupItems : null;
            }

            public Result calculateResult(ExpressionContext context) {
                return this.val$result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.val$result;
            }
        };
        template.addVariable("", expr, expr, true);
        return template;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.local.from.instanceof.usage.family", new Object[0]);
        if (string == null) {
            CreateLocalVarFromInstanceofAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateLocalVarFromInstanceofAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionStatementInside";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

