/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteRepeatedInterfaceFix
implements IntentionAction {
    private final PsiTypeElement myConjunct;
    private final List<PsiTypeElement> myConjList;

    public DeleteRepeatedInterfaceFix(PsiTypeElement conjunct, List<PsiTypeElement> conjList) {
        this.myConjunct = conjunct;
        this.myConjList = conjList;
    }

    @NotNull
    public String getText() {
        String string = "Delete repeated '" + this.myConjunct.getText() + "'";
        if (string == null) {
            DeleteRepeatedInterfaceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Delete repeated interface" == null) {
            DeleteRepeatedInterfaceFix.$$$reportNull$$$0(1);
        }
        return "Delete repeated interface";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            DeleteRepeatedInterfaceFix.$$$reportNull$$$0(2);
        }
        for (PsiTypeElement element : this.myConjList) {
            if (element.isValid()) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiType type2;
        PsiTypeElement castType;
        PsiTypeCastExpression castExpression;
        if (project2 == null) {
            DeleteRepeatedInterfaceFix.$$$reportNull$$$0(3);
        }
        if ((castExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myConjunct, PsiTypeCastExpression.class)) != null && (castType = castExpression.getCastType()) != null && (type2 = castType.getType()) instanceof PsiIntersectionType) {
            String typeText = StringUtil.join((Collection)ContainerUtil.filter(this.myConjList, element -> element != this.myConjunct), element -> element.getText(), (String)" & ");
            PsiTypeCastExpression newCastExpr = (PsiTypeCastExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("(" + typeText + ")a", (PsiElement)castType);
            CodeStyleManager.getInstance((Project)project2).reformat(castType.replace((PsiElement)newCastExpr.getCastType()));
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteRepeatedInterfaceFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteRepeatedInterfaceFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

