/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MethodThrowsFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix");
    private final String myThrowsCanonicalText;
    private final boolean myShouldThrow;
    private final String myMethodName;

    public MethodThrowsFix(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean shouldThrow, boolean showContainingClass) {
        if (method == null) {
            MethodThrowsFix.$$$reportNull$$$0(0);
        }
        if (exceptionType == null) {
            MethodThrowsFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)method);
        this.myThrowsCanonicalText = exceptionType.getCanonicalText();
        this.myShouldThrow = shouldThrow;
        this.myMethodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)(1 | (showContainingClass ? 4096 : 0)), (int)0);
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myShouldThrow ? "fix.throws.list.add.exception" : "fix.throws.list.remove.exception", StringUtil.getShortName((String)this.myThrowsCanonicalText), this.myMethodName);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethod myMethod;
        if (project2 == null) {
            MethodThrowsFix.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            MethodThrowsFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(7);
        }
        return (myMethod = (PsiMethod)startElement).isValid() && myMethod.getManager().isInProject((PsiElement)myMethod);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            MethodThrowsFix.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            MethodThrowsFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(11);
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        PsiJavaCodeReferenceElement[] referenceElements = myMethod.getThrowsList().getReferenceElements();
        try {
            boolean alreadyThrows = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                if (!referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)) continue;
                alreadyThrows = true;
                if (this.myShouldThrow) continue;
                referenceElement.delete();
                break;
            }
            if (this.myShouldThrow && !alreadyThrows) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)myMethod.getProject()).getElementFactory();
                PsiClassType type2 = (PsiClassType)factory.createTypeFromText(this.myThrowsCanonicalText, (PsiElement)myMethod);
                PsiJavaCodeReferenceElement ref = factory.createReferenceElementByType(type2);
                ref = (PsiJavaCodeReferenceElement)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)ref);
                myMethod.getThrowsList().add((PsiElement)ref);
            }
            UndoUtil.markPsiFileForUndo((PsiFile)file2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

