/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class NegationBroadScopeFix
implements IntentionAction {
    private final PsiPrefixExpression myPrefixExpression;

    public NegationBroadScopeFix(@NotNull PsiPrefixExpression prefixExpression) {
        if (prefixExpression == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(0);
        }
        this.myPrefixExpression = prefixExpression;
    }

    @NotNull
    public String getText() {
        String rop;
        PsiExpression operand2 = this.myPrefixExpression.getOperand();
        String text2 = operand2 == null ? "" : operand2.getText() + " ";
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression) {
            text2 = text2 + "instanceof ";
            PsiTypeElement type2 = ((PsiInstanceOfExpression)parent).getCheckType();
            rop = type2 == null ? "" : type2.getText();
        } else if (parent instanceof PsiBinaryExpression) {
            text2 = text2 + ((PsiBinaryExpression)parent).getOperationSign().getText() + " ";
            PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
            rop = rOperand == null ? "" : rOperand.getText();
        } else {
            rop = "<expr>";
        }
        text2 = text2 + rop;
        String string = QuickFixBundle.message("negation.broader.scope.text", text2);
        if (string == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("negation.broader.scope.family", new Object[0]);
        if (string == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(3);
        }
        if (!this.myPrefixExpression.isValid() || this.myPrefixExpression.getOperand() == null) {
            return false;
        }
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent).getOperand() == this.myPrefixExpression) {
            return true;
        }
        if (!(parent instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
        return binaryExpression.getLOperand() == this.myPrefixExpression && TypeConversionUtil.isBooleanType((PsiType)binaryExpression.getType());
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(4);
        }
        PsiPrefixExpression psiPrefixExpression = this.myPrefixExpression;
        if (psiPrefixExpression == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(5);
        }
        return psiPrefixExpression;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            NegationBroadScopeFix.$$$reportNull$$$0(6);
        }
        if (!this.isAvailable(project2, editor, file2)) {
            return;
        }
        PsiExpression operand2 = this.myPrefixExpression.getOperand();
        PsiElement unnegated = this.myPrefixExpression.replace((PsiElement)operand2);
        PsiElement parent = unnegated.getParent();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory();
        PsiPrefixExpression negated = (PsiPrefixExpression)factory.createExpressionFromText("!(xxx)", parent);
        PsiParenthesizedExpression parentheses = (PsiParenthesizedExpression)negated.getOperand();
        parentheses.getExpression().replace(parent.copy());
        parent.replace((PsiElement)negated);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/NegationBroadScopeFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

