/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QualifyStaticMethodCallFix
extends StaticImportMethodFix {
    public QualifyStaticMethodCallFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(0);
        }
        super(methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        if ("Qualify static call" == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(1);
        }
        return "Qualify static call";
    }

    @Override
    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(List<PsiMethod> methodsToImport, final @NotNull Project project2, Editor editor) {
        if (project2 == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(2);
        }
        StaticImportMethodQuestionAction<PsiMethod> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiMethod>(project2, editor, methodsToImport, this.myMethodCall){

            @Override
            protected void doImport(PsiMethod toImport) {
                PsiMethodCallExpression element = (PsiMethodCallExpression)QualifyStaticMethodCallFix.this.myMethodCall.getElement();
                if (element == null) {
                    return;
                }
                QualifyStaticMethodCallFix.qualifyStatically((PsiMember)toImport, project2, element.getMethodExpression());
            }
        };
        if (staticImportMethodQuestionAction == null) {
            QualifyStaticMethodCallFix.$$$reportNull$$$0(3);
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    protected boolean showMembersFromDefaultPackage() {
        return true;
    }

    public static void qualifyStatically(PsiMember toImport, Project project2, PsiReferenceExpression qualifiedExpression) {
        PsiClass containingClass = toImport.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiReferenceExpression qualifier = JavaPsiFacade.getElementFactory((Project)project2).createReferenceExpression(containingClass);
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)"Qualify Static Access", null, () -> {
            qualifiedExpression.setQualifierExpression((PsiExpression)qualifier);
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)qualifiedExpression);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticMethodCallFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyStaticMethodCallFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuestionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createQuestionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

