/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyBooleanExpressionFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpression");
    public static final String FAMILY_NAME = QuickFixBundle.message("simplify.boolean.expression.family", new Object[0]);
    private final boolean mySubExpressionValue;

    public SimplifyBooleanExpressionFix(@NotNull PsiExpression subExpression, boolean subExpressionValue) {
        if (subExpression == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)subExpression);
        this.mySubExpressionValue = subExpressionValue;
    }

    @NotNull
    public String getText() {
        PsiExpression subExpression = this.getSubExpression();
        String string = subExpression == null ? this.getFamilyName() : SimplifyBooleanExpressionFix.getIntentionText(subExpression, this.mySubExpressionValue);
        if (string == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getIntentionText(@NotNull PsiExpression expression2, boolean constantValue) {
        PsiElement parent;
        if (expression2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(2);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiIfStatement) {
            String string = constantValue ? "Unwrap 'if' statement" : "Remove 'if' statement";
            if (string == null) {
                SimplifyBooleanExpressionFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (!constantValue) {
            if (parent instanceof PsiWhileStatement) {
                if ("Remove 'while' statement" == null) {
                    SimplifyBooleanExpressionFix.$$$reportNull$$$0(4);
                }
                return "Remove 'while' statement";
            }
            if (parent instanceof PsiDoWhileStatement) {
                if ("Unwrap 'do-while' statement" == null) {
                    SimplifyBooleanExpressionFix.$$$reportNull$$$0(5);
                }
                return "Unwrap 'do-while' statement";
            }
            if (parent instanceof PsiForStatement) {
                if ("Remove 'for' statement" == null) {
                    SimplifyBooleanExpressionFix.$$$reportNull$$$0(6);
                }
                return "Remove 'for' statement";
            }
        }
        String string = QuickFixBundle.message("simplify.boolean.expression.text", expression2.getText(), constantValue);
        if (string == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = FAMILY_NAME;
        if (string == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAvailable() {
        PsiElement parent;
        PsiExpression expression2 = this.getSubExpression();
        if (!super.isAvailable() || expression2 == null || !expression2.getManager().isInProject((PsiElement)expression2) || PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
            return false;
        }
        PsiElement element = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2);
        PsiElement psiElement = parent = element == null ? null : element.getParent();
        return !(parent instanceof PsiDoWhileStatement) || !SimplifyBooleanExpressionFix.containsBreakOrContinue((PsiDoWhileStatement)parent);
    }

    private static boolean containsBreakOrContinue(PsiDoWhileStatement doWhileLoop) {
        return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)doWhileLoop).filter(e -> SimplifyBooleanExpressionFix.isBreakOrContinue(e, doWhileLoop))).iterator().hasNext();
    }

    private static boolean isBreakOrContinue(PsiElement e, PsiDoWhileStatement doWhileLoop) {
        return e instanceof PsiBreakStatement && doWhileLoop == ((PsiBreakStatement)e).findExitedStatement() || e instanceof PsiContinueStatement && doWhileLoop == ((PsiContinueStatement)e).findContinuedStatement();
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(12);
        }
        if (!this.isAvailable()) {
            return;
        }
        SimplifyBooleanExpressionFix.simplifyExpression(project2, this.getSubExpression(), this.mySubExpressionValue);
    }

    public static void simplifyExpression(Project project2, PsiExpression subExpression, Boolean subExpressionValue) {
        PsiExpression expression2;
        if (subExpressionValue == null) {
            expression2 = subExpression;
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression constExpression = factory.createExpressionFromText(Boolean.toString(subExpressionValue), (PsiElement)subExpression);
            expression2 = (PsiExpression)subExpression.replace((PsiElement)constExpression);
        }
        while (expression2.getParent() instanceof PsiExpression) {
            expression2 = (PsiExpression)expression2.getParent();
        }
        SimplifyBooleanExpressionFix.simplifyExpression(expression2);
    }

    public static boolean simplifyIfOrLoopStatement(PsiExpression expression2) throws IncorrectOperationException {
        boolean condition2 = Boolean.parseBoolean(expression2.getText());
        if (!(expression2 instanceof PsiLiteralExpression) || !PsiType.BOOLEAN.equals((Object)expression2.getType())) {
            return false;
        }
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == expression2) {
            SimplifyBooleanExpressionFix.simplifyIfStatement(condition2, (PsiIfStatement)parent);
            return true;
        }
        if (parent instanceof PsiWhileStatement && !condition2) {
            parent.delete();
            return true;
        }
        if (parent instanceof PsiDoWhileStatement && !condition2) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)((PsiDoWhileStatement)parent), ((PsiDoWhileStatement)parent).getBody());
            return true;
        }
        if (parent instanceof PsiForStatement && !condition2) {
            SimplifyBooleanExpressionFix.simplifyForStatement(parent);
            return true;
        }
        return false;
    }

    private static void simplifyForStatement(PsiElement parent) {
        PsiStatement initialization = ((PsiForStatement)parent).getInitialization();
        if (initialization != null && !SyntaxTraverser.psiTraverser((PsiElement)initialization).filter(PsiExpression.class).filter(SideEffectChecker::mayHaveSideEffects).isEmpty()) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)((PsiForStatement)parent), initialization);
        } else {
            parent.delete();
        }
    }

    private static void simplifyIfStatement(boolean conditionAlwaysTrue, PsiIfStatement ifStatement) {
        if (conditionAlwaysTrue) {
            SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, ifStatement.getThenBranch());
        } else {
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ifStatement.delete();
            } else {
                SimplifyBooleanExpressionFix.replaceWithStatements((PsiStatement)ifStatement, elseBranch);
            }
        }
    }

    private static void replaceWithStatements(@NotNull PsiStatement orig, @Nullable PsiStatement statement2) throws IncorrectOperationException {
        PsiIfStatement ifStmt;
        if (orig == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(13);
        }
        if (statement2 == null) {
            orig.delete();
            return;
        }
        PsiElement parent = orig.getParent();
        if (parent == null) {
            return;
        }
        PsiElement grandParent = parent.getParent();
        if (parent instanceof PsiCodeBlock && SimplifyBooleanExpressionFix.blockAlwaysReturns(statement2)) {
            SimplifyBooleanExpressionFix.removeFollowingStatements(orig, (PsiCodeBlock)parent);
        } else if (grandParent instanceof PsiCodeBlock && parent instanceof PsiIfStatement && (ifStmt = (PsiIfStatement)parent).getElseBranch() == orig && SimplifyBooleanExpressionFix.blockAlwaysReturns(ifStmt.getThenBranch()) && SimplifyBooleanExpressionFix.blockAlwaysReturns(statement2)) {
            SimplifyBooleanExpressionFix.removeFollowingStatements((PsiStatement)ifStmt, (PsiCodeBlock)grandParent);
        }
        if (parent instanceof PsiCodeBlock) {
            if (statement2 instanceof PsiBlockStatement && !DeclarationSearchUtils.containsConflictingDeclarations(((PsiBlockStatement)statement2).getCodeBlock(), (PsiCodeBlock)parent)) {
                SimplifyBooleanExpressionFix.inlineBlockStatements(orig, (PsiBlockStatement)statement2, parent);
                return;
            }
            if (SimplifyBooleanExpressionFix.hasConflictingDeclarations(statement2, (PsiCodeBlock)parent)) {
                orig.replace((PsiElement)SimplifyBooleanExpressionFix.wrapWithCodeBlock(statement2));
                return;
            }
        }
        orig.replace((PsiElement)statement2);
    }

    private static boolean hasConflictingDeclarations(@Nullable PsiStatement statement2, PsiCodeBlock parent) {
        return statement2 instanceof PsiDeclarationStatement && ContainerUtil.exists((Object[])((PsiDeclarationStatement)statement2).getDeclaredElements(), e -> SimplifyBooleanExpressionFix.isConflictingLocalVariable(parent, e));
    }

    private static boolean isConflictingLocalVariable(PsiCodeBlock parent, PsiElement declaration2) {
        if (!(declaration2 instanceof PsiLocalVariable)) {
            return false;
        }
        String name2 = ((PsiLocalVariable)declaration2).getName();
        return name2 != null && PsiResolveHelper.SERVICE.getInstance((Project)declaration2.getProject()).resolveAccessibleReferencedVariable(name2, (PsiElement)parent) != null;
    }

    private static PsiBlockStatement wrapWithCodeBlock(PsiStatement replacement) {
        PsiBlockStatement newBlock = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)replacement.getProject()).createStatementFromText("{}", null);
        newBlock.getCodeBlock().add((PsiElement)replacement);
        return newBlock;
    }

    private static void inlineBlockStatements(@NotNull PsiStatement orig, @NotNull PsiBlockStatement statement2, PsiElement parent) {
        if (orig == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(14);
        }
        if (statement2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(15);
        }
        PsiCodeBlock codeBlock = statement2.getCodeBlock();
        PsiJavaToken lBrace = codeBlock.getLBrace();
        PsiJavaToken rBrace = codeBlock.getRBrace();
        if (lBrace == null || rBrace == null) {
            return;
        }
        PsiElement[] children2 = codeBlock.getChildren();
        if (children2.length > 2) {
            PsiElement added = parent.addRangeBefore(children2[1], children2[children2.length - 2], (PsiElement)orig);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((PsiManager)orig.getManager());
            codeStyleManager.reformat(added);
        }
        orig.delete();
    }

    private static boolean blockAlwaysReturns(@Nullable PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        try {
            return ControlFlowUtil.returnPresent(HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)statement2));
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static void removeFollowingStatements(@NotNull PsiStatement anchor, @NotNull PsiCodeBlock parentBlock) {
        PsiStatement[] siblingStatements;
        int ifIndex;
        if (anchor == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(16);
        }
        if (parentBlock == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(17);
        }
        if ((ifIndex = Arrays.asList(siblingStatements = parentBlock.getStatements()).indexOf(anchor)) >= 0 && ifIndex < siblingStatements.length - 1) {
            parentBlock.deleteChildRange((PsiElement)siblingStatements[ifIndex + 1], (PsiElement)siblingStatements[siblingStatements.length - 1]);
        }
    }

    public static void simplifyExpression(PsiExpression expression2) throws IncorrectOperationException {
        PsiElement parent;
        final PsiExpression[] result2 = new PsiExpression[]{(PsiExpression)expression2.copy()};
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression2.getManager(), true);
        final IncorrectOperationException[] exception = new IncorrectOperationException[]{null};
        result2[0].accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement[] children2;
                for (PsiElement child : children2 = element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                expressionVisitor.clear();
                expression2.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.resultExpression != null) {
                    LOG.assertTrue(expressionVisitor.resultExpression.isValid());
                    try {
                        if (expression2 != result2[0]) {
                            expression2.replace((PsiElement)expressionVisitor.resultExpression);
                        } else {
                            result2[0] = expressionVisitor.resultExpression;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        exception[0] = e;
                    }
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        PsiExpression newExpression = (PsiExpression)expression2.replace((PsiElement)result2[0]);
        if (newExpression instanceof PsiLiteralExpression && (parent = newExpression.getParent()) instanceof PsiAssertStatement && ((PsiLiteralExpression)newExpression).getValue() == Boolean.TRUE) {
            parent.delete();
            return;
        }
        if (!SimplifyBooleanExpressionFix.simplifyIfOrLoopStatement(newExpression)) {
            ParenthesesUtils.removeParentheses(newExpression, false);
        }
    }

    public static boolean canBeSimplified(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            SimplifyBooleanExpressionFix.$$$reportNull$$$0(18);
        }
        if (!(expression2 instanceof PsiConditionalExpression) && !PsiType.BOOLEAN.equals((Object)expression2.getType())) {
            return false;
        }
        final ExpressionVisitor expressionVisitor = new ExpressionVisitor(expression2.getManager(), false);
        final Ref canBeSimplified = new Ref((Object)Boolean.FALSE);
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)canBeSimplified.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                expressionVisitor.clear();
                expression2.accept((PsiElementVisitor)expressionVisitor);
                if (expressionVisitor.canBeSimplifiedFlag) {
                    canBeSimplified.set((Object)Boolean.TRUE);
                }
            }
        });
        return (Boolean)canBeSimplified.get();
    }

    private PsiExpression getSubExpression() {
        PsiElement element = this.getStartElement();
        return element instanceof PsiExpression ? (PsiExpression)element : null;
    }

    public static Boolean getConstBoolean(PsiExpression operand2) {
        if (operand2 == null) {
            return null;
        }
        if ((operand2 = PsiUtil.deparenthesizeExpression((PsiExpression)operand2)) == null) {
            return null;
        }
        String text2 = operand2.getText();
        return "true".equals(text2) ? Boolean.TRUE : ("false".equals(text2) ? Boolean.FALSE : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subExpression";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orig";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/SimplifyBooleanExpressionFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionText";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithStatements";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inlineBlockStatements";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeFollowingStatements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canBeSimplified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExpressionVisitor
    extends JavaElementVisitor {
        private PsiExpression resultExpression;
        private final PsiExpression trueExpression;
        private final PsiExpression falseExpression;
        private final boolean isCreateResult;
        boolean canBeSimplifiedFlag;

        private ExpressionVisitor(PsiManager psiManager, boolean createResult) {
            this.isCreateResult = createResult;
            this.trueExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(true)) : null;
            this.falseExpression = createResult ? ExpressionVisitor.createExpression(psiManager, Boolean.toString(false)) : null;
        }

        private static PsiExpression createExpression(PsiManager psiManager, @NonNls String text2) {
            try {
                return JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createExpressionFromText(text2, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private boolean markAndCheckCreateResult() {
            this.canBeSimplifiedFlag = true;
            return this.isCreateResult;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2 = expression2.getOperands();
            PsiExpression lExpr = operands2[0];
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.XOR == tokenType) {
                boolean negate = false;
                ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>();
                for (PsiExpression operand2 : operands2) {
                    Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand2);
                    if (constBoolean != null) {
                        this.markAndCheckCreateResult();
                        if (constBoolean != Boolean.TRUE) continue;
                        negate = !negate;
                        continue;
                    }
                    expressions2.add(operand2);
                }
                if (expressions2.isEmpty()) {
                    this.resultExpression = negate ? this.trueExpression : this.falseExpression;
                } else {
                    String simplifiedText = StringUtil.join(expressions2, expression1 -> expression1.getText(), (String)" ^ ");
                    if (negate) {
                        simplifiedText = expressions2.size() > 1 ? "!(" + simplifiedText + ")" : "!" + simplifiedText;
                    }
                    this.resultExpression = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(simplifiedText, (PsiElement)expression2);
                }
            } else {
                for (int i = 1; i < operands2.length; ++i) {
                    Boolean l = SimplifyBooleanExpressionFix.getConstBoolean(lExpr);
                    PsiExpression operand3 = operands2[i];
                    Boolean r = SimplifyBooleanExpressionFix.getConstBoolean(operand3);
                    if (l != null) {
                        this.simplifyBinary(tokenType, l, operand3);
                    } else if (r != null) {
                        this.simplifyBinary(tokenType, r, lExpr);
                    } else {
                        PsiJavaToken javaToken = expression2.getTokenBeforeOperand(operand3);
                        if (javaToken != null && !PsiTreeUtil.hasErrorElements((PsiElement)operand3) && !PsiTreeUtil.hasErrorElements((PsiElement)lExpr)) {
                            try {
                                this.resultExpression = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(lExpr.getText() + javaToken.getText() + operand3.getText(), (PsiElement)expression2);
                            }
                            catch (IncorrectOperationException e) {
                                this.resultExpression = null;
                            }
                        } else {
                            this.resultExpression = null;
                        }
                    }
                    if (this.resultExpression == null) continue;
                    lExpr = this.resultExpression;
                }
            }
        }

        private void simplifyBinary(IElementType tokenType, Boolean lConstBoolean, PsiExpression rOperand) {
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            if (JavaTokenType.ANDAND == tokenType || JavaTokenType.AND == tokenType) {
                this.resultExpression = lConstBoolean != false ? rOperand : this.falseExpression;
            } else if (JavaTokenType.OROR == tokenType || JavaTokenType.OR == tokenType) {
                this.resultExpression = lConstBoolean != false ? this.trueExpression : rOperand;
            } else if (JavaTokenType.EQEQ == tokenType) {
                this.simplifyEquation(lConstBoolean, rOperand);
            } else if (JavaTokenType.NE == tokenType) {
                PsiPrefixExpression negatedExpression = ExpressionVisitor.createNegatedExpression(rOperand);
                this.resultExpression = negatedExpression;
                this.visitPrefixExpression(negatedExpression);
                this.simplifyEquation(lConstBoolean, this.resultExpression);
            }
        }

        private void simplifyEquation(Boolean constBoolean, PsiExpression otherOperand) {
            if (constBoolean.booleanValue()) {
                this.resultExpression = otherOperand;
            } else {
                PsiPrefixExpression negated = ExpressionVisitor.createNegatedExpression(otherOperand);
                this.resultExpression = negated;
                this.visitPrefixExpression(negated);
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            Boolean condition2 = SimplifyBooleanExpressionFix.getConstBoolean(expression2.getCondition());
            if (condition2 == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = condition2 != false ? expression2.getThenExpression() : expression2.getElseExpression();
        }

        private static PsiPrefixExpression createNegatedExpression(PsiExpression otherOperand) {
            PsiPrefixExpression expression2 = (PsiPrefixExpression)ExpressionVisitor.createExpression(otherOperand.getManager(), "!(xxx)");
            assert (expression2 != null);
            PsiExpression operand2 = expression2.getOperand();
            assert (operand2 != null);
            try {
                operand2.replace((PsiElement)otherOperand);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return expression2;
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            PsiExpression operand2 = expression2.getOperand();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(operand2);
            if (constBoolean == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.EXCL == tokenType) {
                if (!this.markAndCheckCreateResult()) {
                    return;
                }
                this.resultExpression = constBoolean != false ? this.falseExpression : this.trueExpression;
            }
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiExpression subExpr = expression2.getExpression();
            Boolean constBoolean = SimplifyBooleanExpressionFix.getConstBoolean(subExpr);
            if (constBoolean == null) {
                return;
            }
            if (!this.markAndCheckCreateResult()) {
                return;
            }
            this.resultExpression = constBoolean != false ? this.trueExpression : this.falseExpression;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void clear() {
            this.resultExpression = null;
        }
    }
}

