/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

abstract class StaticMembersProcessor<T extends PsiMember & PsiDocCommentOwner>
implements Processor<T> {
    private final MultiMap<PsiClass, T> mySuggestions;
    private final Map<PsiClass, Boolean> myPossibleClasses;
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final SearchMode mySearchMode;
    private final boolean myShowMembersFromDefaultPackage;
    private PsiType myExpectedType;

    protected StaticMembersProcessor(@NotNull PsiElement place, boolean showMembersFromDefaultPackage, @NotNull SearchMode searchMode) {
        if (place == null) {
            StaticMembersProcessor.$$$reportNull$$$0(0);
        }
        if (searchMode == null) {
            StaticMembersProcessor.$$$reportNull$$$0(1);
        }
        this.mySuggestions = new LinkedMultiMap();
        this.myPossibleClasses = new HashMap<PsiClass, Boolean>();
        this.myPlace = place;
        this.mySearchMode = searchMode;
        this.myShowMembersFromDefaultPackage = showMembersFromDefaultPackage && PsiUtil.isFromDefaultPackage((PsiElement)place);
        this.myExpectedType = PsiType.NULL;
    }

    protected abstract boolean isApplicable(T var1, PsiElement var2);

    @NotNull
    public List<T> getMembersToImport(boolean applicableOnly) {
        ArrayList list2 = new ArrayList();
        ArrayList applicableList = new ArrayList();
        for (Map.Entry methodEntry : this.mySuggestions.entrySet()) {
            this.registerMember((PsiClass)methodEntry.getKey(), (Collection)methodEntry.getValue(), list2, applicableList);
        }
        ArrayList result2 = !applicableOnly && applicableList.isEmpty() ? list2 : applicableList;
        Collections.sort(result2, CodeInsightUtil.createSortIdenticalNamedMembersComparator(this.myPlace));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            StaticMembersProcessor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public PsiType getExpectedType() {
        if (this.myExpectedType == PsiType.NULL) {
            this.myExpectedType = this.getExpectedTypeInternal();
        }
        return this.myExpectedType;
    }

    private PsiType getExpectedTypeInternal() {
        if (!(this.myPlace instanceof PsiExpression)) {
            return null;
        }
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)this.myPlace, false);
        return types.length > 0 ? types[0].getType() : null;
    }

    public boolean process(T member) {
        ProgressManager.checkCanceled();
        if (StaticImportMemberFix.isExcluded(member)) {
            return true;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null) {
            String qualifiedName = containingClass.getQualifiedName();
            PsiFile containingFile = this.myPlace.getContainingFile();
            if (qualifiedName != null && containingFile != null && !ImportFilter.shouldImport((PsiFile)containingFile, (String)qualifiedName)) {
                return true;
            }
            PsiModifierList modifierList = member.getModifierList();
            if (modifierList != null && member instanceof PsiMethod && member.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && !modifierList.hasExplicitModifier("static")) {
                return true;
            }
        }
        if (this.myShowMembersFromDefaultPackage || !PsiUtil.isFromDefaultPackage(member)) {
            this.mySuggestions.putValue((Object)containingClass, member);
        }
        return this.processCondition();
    }

    private boolean processCondition() {
        return this.mySuggestions.size() < this.mySearchMode.count;
    }

    private void registerMember(PsiClass containingClass, Collection<T> members, List<T> list2, List<T> applicableList) {
        Boolean alreadyMentioned = this.myPossibleClasses.get(containingClass);
        if (alreadyMentioned == Boolean.TRUE) {
            return;
        }
        if (containingClass.getQualifiedName() == null) {
            return;
        }
        if (alreadyMentioned == null) {
            this.myPossibleClasses.put(containingClass, false);
        }
        for (PsiMember member : members) {
            if (!member.hasModifierProperty("static")) continue;
            if (alreadyMentioned == null) {
                list2.add(member);
                alreadyMentioned = Boolean.FALSE;
            }
            if (!PsiUtil.isAccessible((Project)this.myPlace.getProject(), (PsiMember)member, (PsiElement)this.myPlace, (PsiClass)containingClass) || !this.isApplicable(member, this.myPlace)) continue;
            applicableList.add(member);
            this.myPossibleClasses.put(containingClass, true);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticMembersProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticMembersProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SearchMode {
        MAX_2_MEMBERS(2),
        MAX_100_MEMBERS(100);

        private final int count;

        private SearchMode(int count) {
            this.count = count;
        }
    }
}

