/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingPass;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class XmlTagTreeHighlightingConfigurable
implements UnnamedConfigurable {
    private JCheckBox myEnableTagTreeHighlightingCheckBox;
    private JSpinner myLevelsSpinner;
    private JPanel myLevelsPanel;
    private JPanel myContentPanel;
    private JSpinner myOpacitySpinner;

    public XmlTagTreeHighlightingConfigurable() {
        this.$$$setupUI$$$();
        this.myLevelsSpinner.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.myOpacitySpinner.setModel(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        this.myEnableTagTreeHighlightingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = XmlTagTreeHighlightingConfigurable.this.myEnableTagTreeHighlightingCheckBox.isSelected();
                UIUtil.setEnabled((Component)XmlTagTreeHighlightingConfigurable.this.myLevelsPanel, (boolean)enabled, (boolean)true);
            }
        });
    }

    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        WebEditorOptions options = WebEditorOptions.getInstance();
        if (this.myEnableTagTreeHighlightingCheckBox.isSelected() != options.isTagTreeHighlightingEnabled()) {
            return true;
        }
        if (this.getLevelCount() != options.getTagTreeHighlightingLevelCount()) {
            return true;
        }
        return this.getOpacity() != options.getTagTreeHighlightingOpacity();
    }

    public void apply() throws ConfigurationException {
        WebEditorOptions options = WebEditorOptions.getInstance();
        options.setTagTreeHighlightingEnabled(this.myEnableTagTreeHighlightingCheckBox.isSelected());
        options.setTagTreeHighlightingLevelCount(this.getLevelCount());
        options.setTagTreeHighlightingOpacity(this.getOpacity());
        XmlTagTreeHighlightingConfigurable.clearTagTreeHighlighting();
    }

    private int getLevelCount() {
        return (Integer)this.myLevelsSpinner.getValue();
    }

    private int getOpacity() {
        return (int)((Double)this.myOpacitySpinner.getValue() * 100.0);
    }

    private static void clearTagTreeHighlighting() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project2).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                XmlTagTreeHighlightingPass.clearHighlightingAndLineMarkers(editor, project2);
                BreadcrumbsXmlWrapper breadcrumbsXmlWrapper = BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor);
                if (breadcrumbsXmlWrapper == null) continue;
                breadcrumbsXmlWrapper.queueUpdate();
            }
        }
    }

    public void reset() {
        WebEditorOptions options = WebEditorOptions.getInstance();
        boolean enabled = options.isTagTreeHighlightingEnabled();
        this.myEnableTagTreeHighlightingCheckBox.setSelected(enabled);
        this.myLevelsSpinner.setValue(options.getTagTreeHighlightingLevelCount());
        this.myOpacitySpinner.setValue((double)options.getTagTreeHighlightingOpacity() * 0.01);
        UIUtil.setEnabled((Component)this.myLevelsPanel, (boolean)enabled, (boolean)true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEnableTagTreeHighlightingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable HTML/XML tag tree highlighting");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myLevelsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Levels to highlight:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myLevelsSpinner = jSpinner2 = new JSpinner();
        jPanel.add((Component)jSpinner2, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(75, -1), new Dimension(75, -1)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Opacity:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myOpacitySpinner = jSpinner = new JSpinner();
        jPanel.add((Component)jSpinner, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(75, -1), new Dimension(75, -1)));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jSpinner2);
        jLabel2.setLabelFor(jSpinner);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

