/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;

public class CompletionAutoPopupHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler");
    public static volatile boolean ourTestingAutopopup = false;

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project2, Editor editor, PsiFile file2) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkAutoPopup: character=" + charTyped + ";");
            LOG.debug("phase=" + CompletionServiceImpl.getCompletionPhase());
            LOG.debug("lookup=" + lookup);
            LOG.debug("currentCompletion=" + CompletionServiceImpl.getCompletionService().getCurrentCompletion());
        }
        if (lookup != null) {
            if (editor.getSelectionModel().hasSelection()) {
                lookup.performGuardedChange(() -> EditorModificationUtil.deleteSelectedText((Editor)editor));
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        if (Character.isLetterOrDigit(charTyped) || charTyped == '_') {
            AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static void invokeCompletion(@NotNull CompletionType completionType, boolean autopopup, Project project2, Editor editor, int time, boolean restart) {
        if (completionType == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(0);
        }
        if (editor.isDisposed()) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return;
        }
        Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(topLevelEditor.getDocument());
        if (file2 == null) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        if (!PsiDocumentManager.getInstance((Project)project2).isCommitted(editor.getDocument())) {
            LOG.error("Non-committed document");
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        }
        Editor newEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(topLevelEditor, topLevelFile);
        try {
            CodeCompletionHandlerBase.createHandler(completionType, false, autopopup, false).invokeCompletion(project2, newEditor, time, false, restart);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void runLaterWithCommitted(@NotNull Project project2, Document document, @NotNull Runnable runnable2) {
        if (project2 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            CompletionAutoPopupHandler.$$$reportNull$$$0(2);
        }
        AutoPopupController.runTransactionWithEverythingCommitted(project2, runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/CompletionAutoPopupHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeCompletion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runLaterWithCommitted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

