/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocLineStartHandler
extends EditorActionHandler {
    private static final String WHITESPACE = " \t";
    private final EditorActionHandler myOriginalHandler;

    public JavadocLineStartHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        PsiDocumentManager psiDocumentManager;
        PsiFile file2;
        int lineStartOffset;
        int nonWsStartOffset;
        Document document;
        CharSequence text2;
        if (editor == null) {
            JavadocLineStartHandler.$$$reportNull$$$0(0);
        }
        assert (caret != null);
        Project project2 = editor.getProject();
        if (project2 != null && EditorSettingsExternalizable.getInstance().isSmartHome() && (CharArrayUtil.regionMatches((CharSequence)(text2 = (document = editor.getDocument()).getImmutableCharSequence()), (int)(nonWsStartOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)(lineStartOffset = document.getLineStartOffset(caret.getLogicalPosition().line)), (String)WHITESPACE)), (CharSequence)"/**") || CharArrayUtil.regionMatches((CharSequence)text2, (int)nonWsStartOffset, (CharSequence)"*")) && (file2 = (psiDocumentManager = PsiDocumentManager.getInstance((Project)project2)).getPsiFile(document)) instanceof PsiJavaFile) {
            IElementType type2;
            psiDocumentManager.commitDocument(document);
            PsiElement startElement = file2.findElementAt(nonWsStartOffset);
            if (startElement instanceof PsiDocToken && ((type2 = ((PsiDocToken)startElement).getTokenType()) == JavaDocTokenType.DOC_COMMENT_START || type2 == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS)) {
                int targetOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)startElement.getTextRange().getEndOffset(), (String)WHITESPACE);
                if (caret.getOffset() == targetOffset) {
                    targetOffset = lineStartOffset;
                }
                caret.moveToOffset(targetOffset);
                caret.removeSelection();
                EditorModificationUtil.scrollToCaret((Editor)editor);
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JavadocLineStartHandler", "doExecute"));
    }
}

