/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarargsSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiExpressionList;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        if (!(e instanceof PsiExpressionList)) {
            return Collections.emptyList();
        }
        PsiExpressionList expressionList = (PsiExpressionList)e;
        PsiParameterList parameterList = VarargsSelectioner.getParameterList(expressionList);
        if (parameterList == null) {
            return Collections.emptyList();
        }
        PsiExpression[] varargArgs = VarargsSelectioner.getVarargArgs(parameterList, expressionList);
        if (varargArgs.length == 0) {
            return Collections.emptyList();
        }
        TextRange firstExpressionRange = varargArgs[0].getTextRange();
        TextRange lastExpressionRange = varargArgs[varargArgs.length - 1].getTextRange();
        return Collections.singletonList(new TextRange(firstExpressionRange.getStartOffset(), lastExpressionRange.getEndOffset()));
    }

    @NotNull
    private static PsiExpression[] getVarargArgs(@NotNull PsiParameterList parameterList, @NotNull PsiExpressionList expressionList) {
        if (parameterList == null) {
            VarargsSelectioner.$$$reportNull$$$0(0);
        }
        if (expressionList == null) {
            VarargsSelectioner.$$$reportNull$$$0(1);
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiExpression[] expressions2 = expressionList.getExpressions();
        if (parameters2.length == 0 || expressions2.length == 0) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                VarargsSelectioner.$$$reportNull$$$0(2);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        int varargIndex = parameters2.length - 1;
        PsiParameter varargParam = parameters2[varargIndex];
        if (!varargParam.isVarArgs() || parameters2.length > expressions2.length) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                VarargsSelectioner.$$$reportNull$$$0(3);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        PsiExpression[] psiExpressionArray = Arrays.copyOfRange(expressions2, varargIndex, expressions2.length);
        if (psiExpressionArray == null) {
            VarargsSelectioner.$$$reportNull$$$0(4);
        }
        return psiExpressionArray;
    }

    @Nullable
    private static PsiParameterList getParameterList(@NotNull PsiExpressionList list2) {
        if (list2 == null) {
            VarargsSelectioner.$$$reportNull$$$0(5);
        }
        if (!(list2.getParent() instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethod method = ((PsiMethodCallExpression)list2.getParent()).resolveMethod();
        return method != null ? method.getParameterList() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/VarargsSelectioner";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarargArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVarargArgs";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameterList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

