/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.progress.util.ProgressWithTimeoutInDispatch;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DocumentFoldingInfo
implements JDOMExternalizable,
CodeFoldingState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.DocumentFoldingInfo");
    private static final Key<FoldingInfo> FOLDING_INFO_KEY = Key.create((String)"FOLDING_INFO");
    @NotNull
    private final Project myProject;
    private final VirtualFile myFile;
    @NotNull
    private final List<SmartPsiElementPointer<PsiElement>> myPsiElements;
    @NotNull
    private final List<SerializedPsiElement> mySerializedElements;
    @NotNull
    private final List<RangeMarker> myRangeMarkers;
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "ph";

    DocumentFoldingInfo(@NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(1);
        }
        this.myPsiElements = ContainerUtil.createLockFreeCopyOnWriteList();
        this.mySerializedElements = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project2;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
    }

    void loadFromEditor(@NotNull Editor editor) {
        FoldRegion[] foldRegions;
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(2);
        }
        DocumentFoldingInfo.assertDispatchThread();
        LOG.assertTrue(!editor.isDisposed());
        this.clear();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        EditorFoldingInfo info = EditorFoldingInfo.get(editor);
        for (FoldRegion region : foldRegions = editor.getFoldingModel().getAllFoldRegions()) {
            boolean collapseByDefault;
            if (!region.isValid()) continue;
            PsiElement element = info.getPsiElement(region);
            boolean expanded = region.isExpanded();
            Boolean storedCollapseByDefault = (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
            boolean bl = collapseByDefault = storedCollapseByDefault != null && storedCollapseByDefault != false && !FoldingUtil.caretInsideRange(editor, TextRange.create((Segment)region));
            if (collapseByDefault != expanded && element != null) continue;
            FoldingInfo fi = new FoldingInfo(region.getPlaceholderText(), expanded);
            if (element != null) {
                this.myPsiElements.add((SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer(element, file2));
                element.putUserData(FOLDING_INFO_KEY, (Object)fi);
                continue;
            }
            RangeMarker marker = editor.getDocument().createRangeMarker(region.getStartOffset(), region.getEndOffset());
            this.myRangeMarkers.add(marker);
            marker.putUserData(FOLDING_INFO_KEY, (Object)fi);
        }
    }

    private static void assertDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
    }

    @Override
    public void setToEditor(@NotNull Editor editor) {
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(3);
        }
        DocumentFoldingInfo.assertDispatchThread();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.myFile);
        if (psiFile == null) {
            return;
        }
        if (!this.mySerializedElements.isEmpty()) {
            assert (this.myPsiElements.isEmpty()) : "Sequential deserialization";
            for (SerializedPsiElement entry : this.mySerializedElements) {
                PsiElement restoredElement = FoldingPolicy.restoreBySignature(psiFile, entry.mySerializedElement);
                if (restoredElement == null || !restoredElement.isValid()) continue;
                this.myPsiElements.add((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(restoredElement));
                restoredElement.putUserData(FOLDING_INFO_KEY, (Object)entry.myFoldingInfo);
            }
            this.mySerializedElements.clear();
        }
        Map<PsiElement, FoldingDescriptor> ranges = null;
        for (SmartPsiElementPointer<PsiElement> ptr : this.myPsiElements) {
            TextRange range;
            FoldRegion region;
            FoldingDescriptor descriptor2;
            PsiElement element = ptr.getElement();
            if (element == null || !element.isValid()) continue;
            if (ranges == null) {
                ranges = DocumentFoldingInfo.buildRanges(editor, psiFile);
            }
            if ((descriptor2 = (FoldingDescriptor)ranges.get(element)) == null || (region = FoldingUtil.findFoldRegion(editor, (range = descriptor2.getRange()).getStartOffset(), range.getEndOffset())) == null) continue;
            FoldingInfo fi = (FoldingInfo)element.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            region.setExpanded(state);
        }
        for (RangeMarker marker : this.myRangeMarkers) {
            if (!marker.isValid() || marker.getStartOffset() == marker.getEndOffset()) continue;
            FoldRegion region = FoldingUtil.findFoldRegion(editor, marker.getStartOffset(), marker.getEndOffset());
            FoldingInfo info = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (region == null) {
                if (info != null) {
                    region = editor.getFoldingModel().addFoldRegion(marker.getStartOffset(), marker.getEndOffset(), info.placeHolder);
                }
                if (region == null) {
                    return;
                }
            }
            boolean state = info != null && info.expanded;
            region.setExpanded(state);
        }
    }

    @NotNull
    private static Map<PsiElement, FoldingDescriptor> buildRanges(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(5);
        }
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        FileASTNode node = psiFile.getNode();
        if (node == null) {
            Map<PsiElement, FoldingDescriptor> map = Collections.emptyMap();
            if (map == null) {
                DocumentFoldingInfo.$$$reportNull$$$0(6);
            }
            return map;
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiFile, (Document)editor.getDocument(), (boolean)true);
        HashMap<PsiElement, FoldingDescriptor> ranges = new HashMap<PsiElement, FoldingDescriptor>();
        for (FoldingDescriptor descriptor2 : descriptors) {
            ASTNode ast = descriptor2.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges.put(psi, descriptor2);
        }
        HashMap<PsiElement, FoldingDescriptor> hashMap = ranges;
        if (hashMap == null) {
            DocumentFoldingInfo.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    void clear() {
        this.myPsiElements.clear();
        for (RangeMarker marker : this.myRangeMarkers) {
            marker.dispose();
        }
        this.myRangeMarkers.clear();
        this.mySerializedElements.clear();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (this.myPsiElements.isEmpty() && this.myRangeMarkers.isEmpty() && this.mySerializedElements.isEmpty()) {
            throw new WriteExternalException();
        }
        if (this.mySerializedElements.isEmpty()) {
            ProgressWithTimeoutInDispatch.execInDispatchWithTimeout(() -> {
                for (SmartPsiElementPointer<PsiElement> ptr : this.myPsiElements) {
                    boolean state;
                    PsiElement psiElement = ptr.getElement();
                    if (psiElement == null || !psiElement.isValid()) continue;
                    FoldingInfo fi = (FoldingInfo)psiElement.getUserData(FOLDING_INFO_KEY);
                    boolean bl = state = fi != null && fi.expanded;
                    String signature = FoldingPolicy.getSignature(psiElement);
                    if (signature == null) continue;
                    PsiFile containingFile = psiElement.getContainingFile();
                    PsiElement restoredElement = FoldingPolicy.restoreBySignature(containingFile, signature);
                    if (!psiElement.equals(restoredElement)) {
                        StringBuilder trace = new StringBuilder();
                        PsiElement restoredAgain = FoldingPolicy.restoreBySignature(containingFile, signature, trace);
                        LOG.error("element: " + psiElement + "(" + psiElement.getText() + "); restoredElement: " + restoredElement + "; signature: '" + signature + "'; file: " + containingFile + "; injected: " + InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(containingFile) + "; languages: " + containingFile.getViewProvider().getLanguages() + "; restored again: " + restoredAgain + "; restore produces same results: " + (restoredAgain == restoredElement) + "; trace:\n" + trace);
                    }
                    Element e = new Element(ELEMENT_TAG);
                    e.setAttribute(SIGNATURE_ATT, signature);
                    e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
                    element.addContent(e);
                }
                return Void.TYPE;
            }, Registry.get((String)"save.folding.state.timeout").asInteger());
        } else {
            for (SerializedPsiElement entry : this.mySerializedElements) {
                Element e = new Element(ELEMENT_TAG);
                e.setAttribute(SIGNATURE_ATT, entry.mySerializedElement);
                e.setAttribute(EXPANDED_ATT, Boolean.toString(entry.myFoldingInfo.getExpanded()));
                element.addContent(e);
            }
        }
        String date = null;
        for (RangeMarker marker : this.myRangeMarkers) {
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            boolean state = fi != null && fi.expanded;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if (date.isEmpty()) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, Boolean.toString(state));
            String signature = marker.getStartOffset() + ":" + marker.getEndOffset();
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = fi == null ? DEFAULT_PLACEHOLDER : fi.placeHolder;
            e.setAttribute(PLACEHOLDER_ATT, XmlStringUtil.escapeIllegalXmlChars((String)placeHolderText));
            element.addContent(e);
        }
    }

    public void readExternal(Element element) {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.clear();
            if (!this.myFile.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
            if (document == null) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            String date = null;
            boolean canRestoreElement = psiFile != null && (!DumbService.getInstance((Project)this.myProject).isDumb() || FoldingUpdate.supportsDumbModeFolding(psiFile));
            for (Object o : element.getChildren()) {
                Element e = (Element)o;
                Boolean expanded = Boolean.valueOf(e.getAttributeValue(EXPANDED_ATT));
                if (ELEMENT_TAG.equals(e.getName())) {
                    String signature = e.getAttributeValue(SIGNATURE_ATT);
                    if (signature == null) continue;
                    FoldingInfo fi = new FoldingInfo(DEFAULT_PLACEHOLDER, expanded);
                    if (canRestoreElement) {
                        PsiElement restoredElement = FoldingPolicy.restoreBySignature(psiFile, signature);
                        if (restoredElement == null || !restoredElement.isValid()) continue;
                        this.myPsiElements.add((SmartPsiElementPointer<PsiElement>)SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(restoredElement));
                        restoredElement.putUserData(FOLDING_INFO_KEY, (Object)fi);
                        continue;
                    }
                    this.mySerializedElements.add(new SerializedPsiElement(signature, fi));
                    continue;
                }
                if (MARKER_TAG.equals(e.getName())) {
                    if (date == null) {
                        date = this.getTimeStamp();
                    }
                    if (date.isEmpty() || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                    StringTokenizer tokenizer = new StringTokenizer(e.getAttributeValue(SIGNATURE_ATT), ":");
                    try {
                        int start = Integer.valueOf(tokenizer.nextToken());
                        int end = Integer.valueOf(tokenizer.nextToken());
                        if (start < 0 || end >= document.getTextLength() || start > end) continue;
                        RangeMarker marker = document.createRangeMarker(start, end);
                        this.myRangeMarkers.add(marker);
                        String placeholderAttributeValue = e.getAttributeValue(PLACEHOLDER_ATT);
                        String placeHolderText = placeholderAttributeValue == null ? DEFAULT_PLACEHOLDER : XmlStringUtil.unescapeIllegalXmlChars((String)placeholderAttributeValue);
                        FoldingInfo fi = new FoldingInfo(placeHolderText, expanded);
                        marker.putUserData(FOLDING_INFO_KEY, (Object)fi);
                    }
                    catch (NoSuchElementException exc) {
                        LOG.error((Throwable)exc);
                    }
                    continue;
                }
                throw new IllegalStateException("unknown tag: " + e.getName());
            }
        });
    }

    private String getTimeStamp() {
        if (!this.myFile.isValid()) {
            return "";
        }
        return Long.toString(this.myFile.getTimeStamp());
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.myPsiElements.hashCode();
        result2 = 31 * result2 + this.myRangeMarkers.hashCode();
        result2 = 31 * result2 + this.mySerializedElements.hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFoldingInfo info = (DocumentFoldingInfo)o;
        if (this.myFile != null ? !this.myFile.equals(info.myFile) : info.myFile != null) {
            return false;
        }
        if (!(this.myProject.equals(info.myProject) && this.myPsiElements.equals(info.myPsiElements) && this.mySerializedElements.equals(info.mySerializedElements))) {
            return false;
        }
        if (this.myRangeMarkers.size() != info.myRangeMarkers.size()) {
            return false;
        }
        for (int i = 0; i < this.myRangeMarkers.size(); ++i) {
            FoldingInfo ofi;
            RangeMarker other;
            RangeMarker marker = this.myRangeMarkers.get(i);
            if (marker == (other = info.myRangeMarkers.get(i)) || !marker.isValid() || !other.isValid()) continue;
            if (!TextRange.areSegmentsEqual((Segment)marker, (Segment)other)) {
                return false;
            }
            FoldingInfo fi = (FoldingInfo)marker.getUserData(FOLDING_INFO_KEY);
            if (Comparing.equal((Object)fi, (Object)(ofi = (FoldingInfo)other.getUserData(FOLDING_INFO_KEY)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToEditor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildRanges";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FoldingInfo {
        private final String placeHolder;
        private final boolean expanded;

        private FoldingInfo(@NotNull String placeHolder, boolean expanded) {
            if (placeHolder == null) {
                FoldingInfo.$$$reportNull$$$0(0);
            }
            this.placeHolder = placeHolder;
            this.expanded = expanded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FoldingInfo info = (FoldingInfo)o;
            return this.expanded == info.expanded && this.placeHolder.equals(info.placeHolder);
        }

        public int hashCode() {
            int result2 = this.placeHolder.hashCode();
            result2 = 31 * result2 + (this.expanded ? 1 : 0);
            return result2;
        }

        public boolean getExpanded() {
            return this.expanded;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeHolder", "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$FoldingInfo", "<init>"));
        }
    }

    private static class SerializedPsiElement {
        private final String mySerializedElement;
        private final FoldingInfo myFoldingInfo;

        SerializedPsiElement(@NotNull String serialized, @NotNull FoldingInfo foldingInfo) {
            if (serialized == null) {
                SerializedPsiElement.$$$reportNull$$$0(0);
            }
            if (foldingInfo == null) {
                SerializedPsiElement.$$$reportNull$$$0(1);
            }
            this.mySerializedElement = serialized;
            this.myFoldingInfo = foldingInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "serialized";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foldingInfo";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/folding/impl/DocumentFoldingInfo$SerializedPsiElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

