/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;

public abstract class GetterSetterPrototypeProvider {
    public static final ExtensionPointName<GetterSetterPrototypeProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.getterSetterProvider");

    public abstract boolean canGeneratePrototypeFor(PsiField var1);

    public abstract PsiMethod[] generateGetters(PsiField var1);

    public abstract PsiMethod[] generateSetters(PsiField var1);

    public PsiMethod[] findGetters(PsiClass psiClass, String propertyName) {
        return null;
    }

    public String suggestGetterName(String propertyName) {
        return null;
    }

    public boolean isSimpleGetter(PsiMethod method, String oldPropertyName) {
        return false;
    }

    public abstract boolean isReadOnly(PsiField var1);

    public static PsiMethod[] generateGetterSetters(PsiField field, boolean generateGetter) {
        return GetterSetterPrototypeProvider.generateGetterSetters(field, generateGetter, true);
    }

    public static PsiMethod[] generateGetterSetters(PsiField field, boolean generateGetter, boolean ignoreInvalidTemplate) {
        for (GetterSetterPrototypeProvider provider : (GetterSetterPrototypeProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.canGeneratePrototypeFor(field)) continue;
            return generateGetter ? provider.generateGetters(field) : provider.generateSetters(field);
        }
        return new PsiMethod[]{generateGetter ? GenerateMembersUtil.generateGetterPrototype(field, ignoreInvalidTemplate) : GenerateMembersUtil.generateSetterPrototype(field, ignoreInvalidTemplate)};
    }

    public static boolean isReadOnlyProperty(PsiField field) {
        for (GetterSetterPrototypeProvider provider : (GetterSetterPrototypeProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.canGeneratePrototypeFor(field)) continue;
            return provider.isReadOnly(field);
        }
        return field.hasModifierProperty("final");
    }

    public static PsiMethod[] findGetters(PsiClass aClass, String propertyName, boolean isStatic) {
        PsiMethod propertyGetterSetter;
        if (!isStatic) {
            for (GetterSetterPrototypeProvider provider : (GetterSetterPrototypeProvider[])Extensions.getExtensions(EP_NAME)) {
                PsiMethod[] getterSetter = provider.findGetters(aClass, propertyName);
                if (getterSetter == null) continue;
                return getterSetter;
            }
        }
        if ((propertyGetterSetter = PropertyUtilBase.findPropertyGetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false)) != null) {
            return new PsiMethod[]{propertyGetterSetter};
        }
        return null;
    }

    public static String suggestNewGetterName(String oldPropertyName, String newPropertyName, PsiMethod method) {
        for (GetterSetterPrototypeProvider provider : (GetterSetterPrototypeProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isSimpleGetter(method, oldPropertyName)) continue;
            return provider.suggestGetterName(newPropertyName);
        }
        return null;
    }
}

