/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;

public class JavaWithTryCatchSurrounder
extends JavaStatementsSurrounder {
    protected boolean myGenerateFinally;

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.catch.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project2, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, true)).length == 0) {
            return null;
        }
        List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions(statements);
        if (exceptions.isEmpty() && (exceptions = ExceptionUtil.getThrownExceptions(statements)).isEmpty()) {
            exceptions = Collections.singletonList(factory.createTypeByFQClassName("java.lang.Exception", container.getResolveScope()));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("try{\n}");
        for (PsiClassType exception : exceptions) {
            buffer.append("catch(Exception e){\n}");
        }
        if (this.myGenerateFinally) {
            buffer.append("finally{\n}");
        }
        String text2 = buffer.toString();
        PsiTryStatement tryStatement = (PsiTryStatement)factory.createStatementFromText(text2, null);
        tryStatement = (PsiTryStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)tryStatement);
        tryStatement = (PsiTryStatement)container.addAfter((PsiElement)tryStatement, statements[statements.length - 1]);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        SurroundWithUtil.indentCommentIfNecessary(tryBlock, statements);
        tryBlock.addRange(statements[0], statements[statements.length - 1]);
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        for (int i = 0; i < exceptions.size(); ++i) {
            PsiCatchSection catchSection;
            PsiClassType exception = exceptions.get(i);
            String[] nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)exception).names;
            String name2 = codeStyleManager.suggestUniqueVariableName(nameSuggestions[0], (PsiElement)tryBlock, false);
            try {
                catchSection = factory.createCatchSection((PsiType)exception, name2, null);
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)project2, (String)CodeInsightBundle.message((String)"surround.with.try.catch.incorrect.template.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"surround.with.try.catch.incorrect.template.title", (Object[])new Object[0]));
                return null;
            }
            catchSection = (PsiCatchSection)catchSections[i].replace((PsiElement)catchSection);
            codeStyleManager.shortenClassReferences((PsiElement)catchSection);
        }
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiCodeBlock firstCatch = tryStatement.getCatchBlocks()[0];
        return SurroundWithUtil.getRangeToSelect(firstCatch);
    }
}

