/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ExpressionTypeMemoryState
extends DfaMemoryStateImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState");
    public static final TObjectHashingStrategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.computeHashCode(o1) != this.computeHashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.computeHashCode(o1) + "!=" + this.computeHashCode(o2));
                }
                return true;
            }
            return false;
        }
    };
    private final Map<PsiExpression, PsiType> myStates = new THashMap(EXPRESSION_HASHING_STRATEGY);

    public ExpressionTypeMemoryState(DfaValueFactory factory) {
        super(factory);
    }

    private ExpressionTypeMemoryState(DfaMemoryStateImpl toCopy) {
        super(toCopy);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        ExpressionTypeMemoryState copy = new ExpressionTypeMemoryState(this);
        copy.myStates.putAll(this.myStates);
        ExpressionTypeMemoryState expressionTypeMemoryState = copy;
        if (expressionTypeMemoryState == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(0);
        }
        return expressionTypeMemoryState;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        DfaInstanceofValue value2;
        if (dfaCond instanceof DfaInstanceofValue && !(value2 = (DfaInstanceofValue)dfaCond).isNegated()) {
            this.setExpressionType(value2.getExpression(), value2.getCastType());
        }
        return super.applyCondition(dfaCond);
    }

    public Map<PsiExpression, PsiType> getStates() {
        return this.myStates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionTypeMemoryState that = (ExpressionTypeMemoryState)o;
        return this.myStates.equals(that.myStates);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStates.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return super.toString() + " states=[" + new HashMap(this.myStates) + "]";
    }

    public void setExpressionType(PsiExpression expression2, @NotNull PsiType type2) {
        PsiType prev;
        if (type2 == null) {
            ExpressionTypeMemoryState.$$$reportNull$$$0(1);
        }
        if ((prev = this.myStates.get(expression2)) == null || !type2.isAssignableFrom(prev)) {
            this.myStates.put(expression2, type2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

