/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightInfo>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project2) {
        this.myProject = project2;
        ActionManagerEx.getInstanceEx().addAnActionListener((AnActionListener)new MyAnActionListener(), (Disposable)this.myProject);
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Editor[] editors;
                Document document = event.getDocument();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                    Map<RangeHighlighter, HighlightInfo> map = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map.keySet()) {
                        HighlightInfo info = map.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || !BitUtil.isSet((int)info.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this.myProject);
    }

    @Nullable
    public Map<RangeHighlighter, HighlightInfo> getHighlightInfoMap(@NotNull Editor editor, boolean toCreate) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(0);
        }
        if (editor instanceof EditorWindow) {
            return this.getHighlightInfoMap(((EditorWindow)editor).getDelegate(), toCreate);
        }
        Map map = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY);
        if (map == null && toCreate) {
            map = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, (Object)new HashMap());
        }
        return map;
    }

    @NotNull
    public RangeHighlighter[] getHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightInfo> highlightersMap;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(1);
        }
        if ((highlightersMap = this.getHighlightInfoMap(editor, false)) == null) {
            if (RangeHighlighter.EMPTY_ARRAY == null) {
                HighlightManagerImpl.$$$reportNull$$$0(2);
            }
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set2 = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightInfo> entry : highlightersMap.entrySet()) {
            HighlightInfo info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set2.add(entry.getKey());
        }
        RangeHighlighter[] rangeHighlighterArray = set2.toArray(new RangeHighlighter[set2.size()]);
        if (rangeHighlighterArray == null) {
            HighlightManagerImpl.$$$reportNull$$$0(3);
        }
        return rangeHighlighterArray;
    }

    private RangeHighlighter addSegmentHighlighter(@NotNull Editor editor, int startOffset, int endOffset, TextAttributes attributes, @HighlightManager.HideFlags int flags) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(4);
        }
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        HighlightInfo info = new HighlightInfo(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, true);
        map.put(highlighter, info);
        return highlighter;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightInfo> map;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(5);
        }
        if (highlighter == null) {
            HighlightManagerImpl.$$$reportNull$$$0(6);
        }
        if ((map = this.getHighlightInfoMap(editor, false)) == null) {
            return false;
        }
        HighlightInfo info = map.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiReference[] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(7);
        }
        if (occurrences == null) {
            HighlightManagerImpl.$$$reportNull$$$0(8);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(9);
        }
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project2;
            PsiElement element = occurrence.getElement();
            int startOffset = element.getTextRange().getStartOffset();
            int start = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project2 = element.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start, end, attributes, flags, outHighlighters, scrollmarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addElementsOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(12);
        }
        this.addOccurrenceHighlights(editor, elements, attributes, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start, int end, TextAttributes attributes, int flags, Collection<RangeHighlighter> outHighlighters, Color scrollmarkColor) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(13);
        }
        RangeHighlighter highlighter = this.addSegmentHighlighter(editor, start, end, attributes, flags);
        if (outHighlighters != null) {
            outHighlighters.add(highlighter);
        }
        if (scrollmarkColor != null) {
            highlighter.setErrorStripeMarkColor(scrollmarkColor);
        }
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(14);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(15);
        }
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(16);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(17);
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, flags, highlighters, scrollmarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(18);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(19);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(20);
        }
        if (elements.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            range = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, range);
            this.addOccurrenceHighlight(editor, HighlightManagerImpl.trimOffsetToDocumentSize(editor, range.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor, range.getEndOffset()), attributes, flags, outHighlighters, scrollmarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor, int offset) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(21);
        }
        if (offset < 0) {
            return 0;
        }
        int textLength = editor.getDocument().getTextLength();
        return offset < textLength ? offset : textLength;
    }

    @Nullable
    private static Color getScrollMarkColor(@NotNull TextAttributes attributes, @NotNull EditorColorsScheme colorScheme) {
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(22);
        }
        if (colorScheme == null) {
            HighlightManagerImpl.$$$reportNull$$$0(23);
        }
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            boolean isDark = ColorUtil.isDark((Color)colorScheme.getDefaultBackground());
            return isDark ? attributes.getBackgroundColor().brighter() : attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightInfo> map;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(24);
        }
        if ((map = this.getHighlightInfoMap(editor, false)) == null) {
            return false;
        }
        boolean done2 = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map.keySet()) {
            HighlightInfo info = map.get(highlighter);
            if (!info.editor.equals(editor) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done2 = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoMap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighters";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSegmentHighlighter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeSegmentHighlighter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlights";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addElementsOccurrenceHighlights";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlight";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlight";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "trimOffsetToDocumentSize";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScrollMarkColor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hideHighlights";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class HighlightInfo {
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        public HighlightInfo(Editor editor, @HighlightManager.HideFlags int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            this.requestHideHighlights(dataContext);
        }

        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        public void beforeEditorTyping(char c, DataContext dataContext) {
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }
    }
}

