/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usages.UsageView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowImplementationsAction
extends AnAction
implements PopupAction {
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE = "codeassists.quickdefinition.lookup";
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_FEATURE = "codeassists.quickdefinition";
    private static final Logger LOG = Logger.getInstance(ShowImplementationsAction.class);
    private Reference<JBPopup> myPopupRef;
    private Reference<ImplementationsUpdaterTask> myTaskRef;

    public ShowImplementationsAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        this.performForContext(e.getDataContext(), true);
    }

    public void performForContext(DataContext dataContext) {
        this.performForContext(dataContext, true);
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = ShowImplementationsAction.getEditor(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiFile containingFile = (element = ShowImplementationsAction.getElement(project2, file2, editor, element)) != null ? element.getContainingFile() : file2;
        boolean enabled = containingFile != null && containingFile.getViewProvider().isPhysical();
        e.getPresentation().setEnabled(enabled);
    }

    protected static Editor getEditor(@NotNull DataContext dataContext) {
        FileEditor fileEditor;
        VirtualFile virtualFile;
        PsiFile file2;
        Editor editor;
        if (dataContext == null) {
            ShowImplementationsAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null && (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null && (virtualFile = file2.getVirtualFile()) != null && (fileEditor = FileEditorManager.getInstance((Project)file2.getProject()).getSelectedEditor(virtualFile)) instanceof TextEditor) {
            editor = ((TextEditor)fileEditor).getEditor();
        }
        return editor;
    }

    public void performForContext(@NotNull DataContext dataContext, boolean invokedByShortcut) {
        PsiFile containingFile;
        Project project2;
        if (dataContext == null) {
            ShowImplementationsAction.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = ShowImplementationsAction.getEditor(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        boolean isInvokedFromEditor = CommonDataKeys.EDITOR.getData(dataContext) != null;
        element = ShowImplementationsAction.getElement(project2, file2, editor, element);
        if (element == null && file2 == null) {
            return;
        }
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : file2;
        if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
            return;
        }
        PsiReference ref = null;
        if (editor != null) {
            ref = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
            if (element == null && ref != null) {
                element = TargetElementUtil.getInstance().adjustReference(ref);
            }
        }
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        String text2 = "";
        PsiElement[] impls = PsiElement.EMPTY_ARRAY;
        if (element != null) {
            impls = ShowImplementationsAction.getSelfAndImplementations(editor, element, this.createImplementationsSearcher());
            text2 = SymbolPresentationUtil.getSymbolPresentableText(element);
        }
        if (impls.length == 0 && ref instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyReference = (PsiPolyVariantReference)ref;
            PsiElement refElement = polyReference.getElement();
            TextRange rangeInElement = polyReference.getRangeInElement();
            String refElementText = refElement.getText();
            LOG.assertTrue(rangeInElement.getEndOffset() <= refElementText.length(), (Object)("Ref:" + polyReference + "; refElement: " + refElement + "; refText:" + refElementText));
            text2 = rangeInElement.substring(refElementText);
            ResolveResult[] results = polyReference.multiResolve(false);
            ArrayList<PsiElement> implsList = new ArrayList<PsiElement>(results.length);
            for (ResolveResult result2 : results) {
                PsiElement resolvedElement = result2.getElement();
                if (resolvedElement == null || !resolvedElement.isPhysical()) continue;
                implsList.add(resolvedElement);
            }
            if (!implsList.isEmpty()) {
                impls = implsList.toArray(new PsiElement[implsList.size()]);
            }
        }
        this.showImplementations(impls, project2, text2, editor, file2, element, isInvokedFromEditor, invokedByShortcut);
    }

    protected static PsiElement getElement(@NotNull Project project2, PsiFile file2, Editor editor, PsiElement element) {
        if (project2 == null) {
            ShowImplementationsAction.$$$reportNull$$$0(2);
        }
        if (element == null && editor != null) {
            element = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getAllAccepted());
            PsiElement adjustedElement = TargetElementUtil.getInstance().adjustElement(editor, TargetElementUtil.getInstance().getAllAccepted(), element, null);
            if (adjustedElement != null) {
                element = adjustedElement;
            } else if (file2 != null) {
                element = DocumentationManager.getInstance(project2).getElementFromLookup(editor, file2);
            }
        }
        return element;
    }

    @NotNull
    ImplementationSearcher createImplementationsSearcher() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ImplementationSearcher implementationSearcher = new ImplementationSearcher(){

                @Override
                protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
                    return ShowImplementationsAction.filterElements(targetElements);
                }
            };
            if (implementationSearcher == null) {
                ShowImplementationsAction.$$$reportNull$$$0(3);
            }
            return implementationSearcher;
        }
        ImplementationSearcher.FirstImplementationsSearcher firstImplementationsSearcher = new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
                return ShowImplementationsAction.filterElements(targetElements);
            }

            @Override
            protected boolean isSearchDeep() {
                return ShowImplementationsAction.this.isSearchDeep();
            }
        };
        if (firstImplementationsSearcher == null) {
            ShowImplementationsAction.$$$reportNull$$$0(4);
        }
        return firstImplementationsSearcher;
    }

    private void updateElementImplementations(PsiElement element, Editor editor, @NotNull Project project2, PsiFile file2) {
        if (project2 == null) {
            ShowImplementationsAction.$$$reportNull$$$0(5);
        }
        PsiElement[] impls = new PsiElement[]{};
        String text2 = "";
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
                return;
            }
            impls = ShowImplementationsAction.getSelfAndImplementations(editor, element, this.createImplementationsSearcher());
            text2 = SymbolPresentationUtil.getSymbolPresentableText(element);
        }
        this.showImplementations(impls, project2, text2, editor, file2, element, false, false);
    }

    protected void showImplementations(@NotNull PsiElement[] impls, final @NotNull Project project2, String text2, final Editor editor, final PsiFile file2, PsiElement element, boolean invokedFromEditor, boolean invokedByShortcut) {
        if (impls == null) {
            ShowImplementationsAction.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            ShowImplementationsAction.$$$reportNull$$$0(7);
        }
        if (impls.length == 0) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_FEATURE);
        if (LookupManager.getInstance(project2).getActiveLookup() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE);
        }
        int index = 0;
        if (invokedFromEditor && file2 != null && impls.length > 1) {
            PsiFile secondContainingFile;
            VirtualFile virtualFile = file2.getVirtualFile();
            PsiFile containingFile = impls[0].getContainingFile();
            if (virtualFile != null && containingFile != null && virtualFile.equals(containingFile.getVirtualFile()) && (secondContainingFile = impls[1].getContainingFile()) != containingFile) {
                index = 1;
            }
        }
        Ref usageView = new Ref();
        String title = CodeInsightBundle.message((String)"implementation.view.title", (Object[])new Object[]{text2});
        JBPopup popup2 = (JBPopup)SoftReference.dereference(this.myPopupRef);
        if (popup2 != null && popup2.isVisible() && popup2 instanceof AbstractPopup) {
            ImplementationViewComponent component = (ImplementationViewComponent)((AbstractPopup)popup2).getComponent();
            ((AbstractPopup)popup2).setCaption(title);
            component.update(impls, index);
            this.updateInBackground(editor, element, component, title, (AbstractPopup)popup2, (Ref<UsageView>)usageView);
            if (invokedByShortcut) {
                ((AbstractPopup)popup2).focusPreferredComponent();
            }
            return;
        }
        ImplementationViewComponent component = new ImplementationViewComponent(impls, index);
        if (component.hasElementsToShow()) {
            PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project2){

                public void updatePopup(Object lookupItemObject) {
                    PsiElement element = lookupItemObject instanceof PsiElement ? (PsiElement)lookupItemObject : DocumentationManager.getInstance(project2).getElementFromLookup(editor, file2);
                    ShowImplementationsAction.this.updateElementImplementations(element, editor, project2, file2);
                }
            };
            popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPreferredFocusableComponent()).setProject(project2).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setDimensionServiceKey(project2, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(invokedFromEditor && LookupManager.getActiveLookup(editor) == null).setTitle(title).setCouldPin(popup1 -> {
                usageView.set((Object)component.showInUsageView());
                popup1.cancel();
                this.myTaskRef = null;
                return false;
            }).setCancelCallback(() -> {
                ImplementationsUpdaterTask task = (ImplementationsUpdaterTask)((Object)((Object)SoftReference.dereference(this.myTaskRef)));
                if (task != null) {
                    task.cancelTask();
                }
                return Boolean.TRUE;
            }).createPopup();
            this.updateInBackground(editor, element, component, title, (AbstractPopup)popup2, (Ref<UsageView>)usageView);
            PopupPositionManager.positionPopupInBestPosition(popup2, editor, DataManager.getInstance().getDataContext());
            component.setHint(popup2, title);
            this.myPopupRef = new WeakReference<JBPopup>(popup2);
        }
    }

    private void updateInBackground(Editor editor, @Nullable PsiElement element, @NotNull ImplementationViewComponent component, String title, @NotNull AbstractPopup popup2, @NotNull Ref<UsageView> usageView) {
        ImplementationsUpdaterTask updaterTask;
        if (component == null) {
            ShowImplementationsAction.$$$reportNull$$$0(8);
        }
        if (popup2 == null) {
            ShowImplementationsAction.$$$reportNull$$$0(9);
        }
        if (usageView == null) {
            ShowImplementationsAction.$$$reportNull$$$0(10);
        }
        if ((updaterTask = (ImplementationsUpdaterTask)((Object)SoftReference.dereference(this.myTaskRef))) != null) {
            updaterTask.cancelTask();
        }
        if (element == null) {
            return;
        }
        ImplementationsUpdaterTask task = new ImplementationsUpdaterTask(element, editor, title, this.isIncludeAlwaysSelf());
        task.init(popup2, component, usageView);
        this.myTaskRef = new WeakReference<ImplementationsUpdaterTask>(task);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    protected boolean isIncludeAlwaysSelf() {
        return true;
    }

    @NotNull
    private static PsiElement[] getSelfAndImplementations(Editor editor, @NotNull PsiElement element, @NotNull ImplementationSearcher handler2) {
        if (element == null) {
            ShowImplementationsAction.$$$reportNull$$$0(11);
        }
        if (handler2 == null) {
            ShowImplementationsAction.$$$reportNull$$$0(12);
        }
        PsiElement[] psiElementArray = ShowImplementationsAction.getSelfAndImplementations(editor, element, handler2, !(element instanceof PomTargetPsiElement));
        if (psiElementArray == null) {
            ShowImplementationsAction.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    @NotNull
    static PsiElement[] getSelfAndImplementations(Editor editor, @NotNull PsiElement element, @NotNull ImplementationSearcher handler2, boolean includeSelfAlways) {
        PsiElement[] handlerImplementations;
        if (element == null) {
            ShowImplementationsAction.$$$reportNull$$$0(14);
        }
        if (handler2 == null) {
            ShowImplementationsAction.$$$reportNull$$$0(15);
        }
        if ((handlerImplementations = handler2.searchImplementations(element, editor, includeSelfAlways, true)).length > 0) {
            if (handlerImplementations == null) {
                ShowImplementationsAction.$$$reportNull$$$0(16);
            }
            return handlerImplementations;
        }
        PsiElement[] psiElementArray = (PsiElement[])ReadAction.compute(() -> {
            PsiElement psiElement;
            PsiFile psiFile;
            if (element == null) {
                ShowImplementationsAction.$$$reportNull$$$0(21);
            }
            if ((psiFile = (psiElement = element).getContainingFile()) == null && (psiFile = (psiElement = psiElement.getNavigationElement()).getContainingFile()) == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            if (psiFile.getVirtualFile() != null && (psiElement.getTextRange() != null || psiElement instanceof PsiFile)) {
                return new PsiElement[]{psiElement};
            }
            return PsiElement.EMPTY_ARRAY;
        });
        if (psiElementArray == null) {
            ShowImplementationsAction.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement[] filterElements(@NotNull PsiElement[] targetElements) {
        if (targetElements == null) {
            ShowImplementationsAction.$$$reportNull$$$0(18);
        }
        LinkedHashSet<PsiElement> unique = new LinkedHashSet<PsiElement>(Arrays.asList(targetElements));
        for (PsiElement elt : targetElements) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile containingFile = elt.getContainingFile();
                LOG.assertTrue(containingFile != null, (Object)elt);
                PsiFile psiFile = containingFile.getOriginalFile();
                if (psiFile.getVirtualFile() == null) {
                    unique.remove(elt);
                }
            });
        }
        for (int i = 1; i < targetElements.length; ++i) {
            PsiElement targetElement = targetElements[i];
            if (!((Boolean)ReadAction.compute(() -> {
                if (targetElements == null) {
                    ShowImplementationsAction.$$$reportNull$$$0(20);
                }
                return PsiTreeUtil.isAncestor((PsiElement)targetElement, (PsiElement)targetElements[0], (boolean)true);
            })).booleanValue()) continue;
            unique.remove(targetElements[0]);
            break;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(unique);
        if (psiElementArray == null) {
            ShowImplementationsAction.$$$reportNull$$$0(19);
        }
        return psiElementArray;
    }

    protected boolean isSearchDeep() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/actions/ShowImplementationsAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impls";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 11: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/actions/ShowImplementationsAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementationsSearcher";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfAndImplementations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "filterElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performForContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateElementImplementations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showImplementations";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateInBackground";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSelfAndImplementations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterElements$4";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSelfAndImplementations$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask<ImplementationViewComponent> {
        private final String myCaption;
        private final Editor myEditor;
        @NotNull
        private final PsiElement myElement;
        private final boolean myIncludeSelf;
        private PsiElement[] myElements;

        private ImplementationsUpdaterTask(PsiElement element, Editor editor, String caption, boolean includeSelf) {
            if (element == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            super(element.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS, null);
            this.myCaption = caption;
            this.myEditor = editor;
            this.myElement = element;
            this.myIncludeSelf = includeSelf;
        }

        @Override
        public String getCaption(int size) {
            return this.myCaption;
        }

        @Override
        protected void paintBusy(boolean paintBusy) {
        }

        @Override
        protected void replaceModel(@NotNull List<PsiElement> data) {
            if (data == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(1);
            }
            PsiElement[] elements = ((ImplementationViewComponent)this.myComponent).getElements();
            int includeSelfIdx = this.myElement instanceof PomTargetPsiElement ? 0 : 1;
            int startIdx = elements.length - includeSelfIdx;
            PsiElement[] result2 = new PsiElement[data.size() + includeSelfIdx];
            System.arraycopy(elements, 0, result2, 0, elements.length);
            System.arraycopy(PsiUtilCore.toPsiElementArray(data), startIdx, result2, elements.length, data.size() - startIdx);
            ((ImplementationViewComponent)this.myComponent).update(result2, ((ImplementationViewComponent)this.myComponent).getIndex());
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(2);
            }
            super.run(indicator);
            ImplementationSearcher.BackgroundableImplementationSearcher implementationSearcher = new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected boolean isSearchDeep() {
                    return ShowImplementationsAction.this.isSearchDeep();
                }

                @Override
                protected void processElement(PsiElement element) {
                    if (!ImplementationsUpdaterTask.this.updateComponent(element)) {
                        indicator.cancel();
                    }
                    indicator.checkCanceled();
                }

                @Override
                protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
                    return ShowImplementationsAction.filterElements(targetElements);
                }
            };
            this.myElements = !this.myIncludeSelf ? ShowImplementationsAction.getSelfAndImplementations(this.myEditor, this.myElement, implementationSearcher, false) : ShowImplementationsAction.getSelfAndImplementations(this.myEditor, this.myElement, implementationSearcher);
        }

        @Override
        public int getCurrentSize() {
            if (this.myElements != null) {
                return this.myElements.length;
            }
            return super.getCurrentSize();
        }

        @Override
        public void onSuccess() {
            if (!this.cancelTask()) {
                ((ImplementationViewComponent)this.myComponent).update(this.myElements, ((ImplementationViewComponent)this.myComponent).getIndex());
            }
            super.onSuccess();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/actions/ShowImplementationsAction$ImplementationsUpdaterTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

