/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiExpressionList, Object, PsiExpression>,
DumbAware {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{PsiMethodCallExpression.class, PsiNewExpression.class, PsiAnonymousClass.class, PsiEnumConstant.class});
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(PsiMethod.class);
    private Inlay myHighlightedHint;

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List<? extends PsiElement> elements = JavaCompletionUtil.getAllPsiElements(item);
        return elements != null && !elements.isEmpty() && elements.get(0) instanceof PsiMethod ? elements.toArray() : null;
    }

    public Object[] getParametersForDocumentation(Object p, ParameterInfoContext context) {
        if (p instanceof MethodCandidateInfo) {
            return ((MethodCandidateInfo)p).getElement().getParameterList().getParameters();
        }
        if (p instanceof PsiMethod) {
            return ((PsiMethod)p).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public PsiExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PsiExpressionList argumentList;
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((argumentList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart(), true)) != null) {
            return MethodParameterInfoHandler.findMethodsForArgumentList(context, argumentList);
        }
        return null;
    }

    private PsiExpressionList findArgumentList(PsiFile file2, int offset, int parameterStart, boolean allowOuter) {
        PsiMethodCallExpression methodCall;
        PsiExpressionList argumentList = (PsiExpressionList)ParameterInfoUtils.findArgumentList((PsiFile)file2, (int)offset, (int)parameterStart, (ParameterInfoHandlerWithTabActionSupport)this, (boolean)allowOuter);
        if (argumentList == null && allowOuter && (methodCall = (PsiMethodCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, PsiMethodCallExpression.class, (Class[])new Class[]{PsiMethod.class})) != null) {
            argumentList = methodCall.getArgumentList();
        }
        return argumentList;
    }

    private static PsiExpressionList findMethodsForArgumentList(CreateParameterInfoContext context, @NotNull PsiExpressionList argumentList) {
        Object[] candidates;
        if (argumentList == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if ((candidates = MethodParameterInfoHandler.getMethods(argumentList)).length == 0) {
            DaemonCodeAnalyzer.getInstance((Project)context.getProject()).updateVisibleHighlighters(context.getEditor());
            return null;
        }
        context.setItemsToShow(candidates);
        return argumentList;
    }

    public void showParameterInfo(@NotNull PsiExpressionList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(3);
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        Object[] candidates;
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context.isPreservedOnHintHidden() && MethodParameterInfoHandler.isOutsideOfCompletedInvocation(context)) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(context.getEditor());
            context.setPreservedOnHintHidden(false);
            return null;
        }
        PsiExpressionList expressionList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart(), false);
        if (expressionList != null && (candidates = context.getObjectsToView()) != null && candidates.length != 0) {
            PsiElement element;
            Object currentMethodInfo = context.getHighlightedParameter();
            if (currentMethodInfo == null) {
                currentMethodInfo = candidates[0];
            }
            Object object = currentMethodInfo instanceof CandidateInfo ? ((CandidateInfo)currentMethodInfo).getElement() : (element = currentMethodInfo instanceof PsiElement ? (PsiElement)currentMethodInfo : null);
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiElement parent = expressionList.getParent();
                String originalMethodName = method.getName();
                PsiReferenceExpression currentMethodReference = null;
                if (parent instanceof PsiMethodCallExpression && !method.isConstructor()) {
                    currentMethodReference = ((PsiMethodCallExpression)parent).getMethodExpression();
                } else if (parent instanceof PsiNewExpression) {
                    currentMethodReference = ((PsiNewExpression)parent).getClassReference();
                } else if (parent instanceof PsiAnonymousClass) {
                    currentMethodReference = ((PsiAnonymousClass)parent).getBaseClassReference();
                }
                if (currentMethodReference == null || originalMethodName.equals(currentMethodReference.getReferenceName())) {
                    int currentNumberOfParameters = expressionList.getExpressions().length;
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
                    Document document = psiDocumentManager.getCachedDocument(context.getFile());
                    if (parent instanceof PsiCallExpression && JavaMethodCallElement.isCompletionMode((PsiCall)parent)) {
                        PsiMethod chosenMethod = CompletionMemory.getChosenMethod((PsiCall)parent);
                        if ((context.getHighlightedParameter() != null || candidates.length == 1) && chosenMethod != null && document != null && psiDocumentManager.isCommitted(document) && MethodParameterInfoHandler.isIncompatibleParameterCount(chosenMethod, currentNumberOfParameters)) {
                            JavaMethodCallElement.setCompletionMode((PsiCall)parent, false);
                            this.highlightHints(context.getEditor(), null, -1);
                        } else {
                            int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)expressionList.getNode(), (int)context.getOffset(), (IElementType)JavaTokenType.COMMA);
                            TextRange textRange = expressionList.getTextRange();
                            if (context.getOffset() <= textRange.getStartOffset() || context.getOffset() >= textRange.getEndOffset()) {
                                index = -1;
                            }
                            this.highlightHints(context.getEditor(), expressionList, context.isInnermostContext() ? index : -1);
                        }
                    }
                    return expressionList;
                }
            }
        }
        this.highlightHints(context.getEditor(), null, -1);
        return null;
    }

    private static boolean isOutsideOfCompletedInvocation(UpdateParameterInfoContext context) {
        PsiElement owner2 = context.getParameterOwner();
        if (owner2 != null && owner2.isValid()) {
            TextRange ownerTextRange = owner2.getTextRange();
            int caretOffset = context.getOffset();
            if (ownerTextRange != null) {
                int parametersCount;
                PsiMethod chosenMethod;
                PsiElement parent;
                if (caretOffset >= ownerTextRange.getStartOffset() && caretOffset <= ownerTextRange.getEndOffset()) {
                    return false;
                }
                for (PsiElement element : owner2.getChildren()) {
                    if (!(element instanceof PsiErrorElement)) continue;
                    return false;
                }
                if (owner2 instanceof PsiExpressionList && ((PsiExpressionList)owner2).getExpressions().length == 0 && (parent = owner2.getParent()) instanceof PsiCall && (chosenMethod = CompletionMemory.getChosenMethod((PsiCall)parent)) != null && ((parametersCount = chosenMethod.getParameterList().getParametersCount()) == 1 && !chosenMethod.isVarArgs() || parametersCount == 2 && chosenMethod.isVarArgs()) && !MethodParameterInfoHandler.overloadWithNoParametersExists(chosenMethod, context.getObjectsToView())) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean overloadWithNoParametersExists(PsiMethod method, Object[] candidates) {
        String methodName = method.getName();
        return ContainerUtil.find((Object[])candidates, c -> {
            if (!(c instanceof CandidateInfo)) {
                return false;
            }
            PsiElement e = ((CandidateInfo)c).getElement();
            if (!(e instanceof PsiMethod)) {
                return false;
            }
            PsiMethod m = (PsiMethod)e;
            return m.getParameterList().getParametersCount() == 0 && m.getName().equals(methodName);
        }) != null;
    }

    private static boolean isIncompatibleParameterCount(@NotNull PsiMethod method, int numberOfParameters) {
        if (method == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int originalNumberOfParameters = method.getParameterList().getParametersCount();
        return PsiImplUtil.isVarArgs(method) ? originalNumberOfParameters > 2 && numberOfParameters < originalNumberOfParameters - 1 : originalNumberOfParameters != numberOfParameters && (originalNumberOfParameters != 1 || numberOfParameters != 0);
    }

    public void updateParameterInfo(@NotNull PsiExpressionList o, @NotNull UpdateParameterInfoContext context) {
        PsiMethod method;
        Object highlightedCandidate;
        TextRange elRange;
        PsiElement parameterOwner;
        if (o == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if ((parameterOwner = context.getParameterOwner()) != o) {
            context.removeHint();
            return;
        }
        int offset = context.getOffset();
        int index = offset <= (elRange = o.getTextRange()).getStartOffset() || offset >= elRange.getEndOffset() ? -1 : ParameterInfoUtils.getCurrentParameterIndex((ASTNode)o.getNode(), (int)offset, (IElementType)JavaTokenType.COMMA);
        context.setCurrentParameter(index);
        Object[] candidates = context.getObjectsToView();
        PsiExpression[] args = o.getExpressions();
        PsiCall call = MethodParameterInfoHandler.getCall(o);
        PsiMethod realResolve = call != null ? call.resolveMethod() : null;
        PsiMethod chosenMethod = CompletionMemory.getChosenMethod(call);
        CandidateInfo chosenInfo = null;
        CandidateInfo completeMatch = null;
        for (int i = 0; i < candidates.length; ++i) {
            CandidateInfo candidate = (CandidateInfo)candidates[i];
            PsiMethod method2 = (PsiMethod)candidate.getElement();
            if (!method2.isValid()) continue;
            PsiSubstitutor substitutor = MethodParameterInfoHandler.getCandidateInfoSubstitutor((PsiElement)o, candidate);
            assert (substitutor != null);
            if (!method2.isValid() || !substitutor.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PsiParameter[] parms = method2.getParameterList().getParameters();
            boolean enabled = true;
            if (parms.length <= index) {
                if (parms.length > 0) {
                    if (method2.isVarArgs()) {
                        for (int j = 0; j < parms.length - 1; ++j) {
                            PsiType parmType = substitutor.substitute(parms[j].getType());
                            PsiType argType = args[j].getType();
                            if (argType == null || parmType.isAssignableFrom(argType)) continue;
                            enabled = false;
                            break;
                        }
                        if (enabled) {
                            PsiArrayType lastParmType = (PsiArrayType)substitutor.substitute(parms[parms.length - 1].getType());
                            PsiType componentType = lastParmType.getComponentType();
                            if (parms.length == args.length) {
                                PsiType lastArgType = args[args.length - 1].getType();
                                if (lastArgType != null && !lastParmType.isAssignableFrom(lastArgType) && !componentType.isAssignableFrom(lastArgType)) {
                                    enabled = false;
                                }
                            } else {
                                for (int j = parms.length; j <= index && j < args.length; ++j) {
                                    PsiExpression arg = args[j];
                                    PsiType argType = arg.getType();
                                    if (argType == null || componentType.isAssignableFrom(argType)) continue;
                                    enabled = false;
                                    break;
                                }
                            }
                        }
                    } else {
                        enabled = false;
                    }
                } else {
                    enabled = index == 0;
                }
            } else {
                enabled = MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, index, substitutor);
            }
            context.setUIComponentEnabled(i, enabled);
            if (candidates.length <= 1 || !enabled) continue;
            if (chosenMethod == method2) {
                chosenInfo = candidate;
            }
            if (parms.length != args.length || realResolve != method2 || !MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, args.length, substitutor)) continue;
            completeMatch = candidate;
        }
        if (chosenInfo != null) {
            context.setHighlightedParameter(chosenInfo);
        } else if (completeMatch != null) {
            context.setHighlightedParameter(completeMatch);
        }
        Object object = highlightedCandidate = candidates.length == 1 ? candidates[0] : context.getHighlightedParameter();
        if (highlightedCandidate != null && !(method = (PsiMethod)(highlightedCandidate instanceof CandidateInfo ? ((CandidateInfo)highlightedCandidate).getElement() : highlightedCandidate)).isVarArgs() && index >= method.getParameterList().getParametersCount()) {
            context.setCurrentParameter(-1);
        }
    }

    private void highlightHints(@NotNull Editor editor, @Nullable PsiExpressionList expressionList, int currentHintIndex) {
        if (editor == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (editor.isDisposed()) {
            return;
        }
        ParameterHintsPresentationManager presentationManager = ParameterHintsPresentationManager.getInstance();
        Inlay hint = null;
        if (expressionList != null && expressionList.isValid() && currentHintIndex >= 0 && (currentHintIndex < expressionList.getExpressions().length || currentHintIndex == 0 && expressionList.getExpressions().length == 0)) {
            PsiElement nextDelimiter;
            PsiElement prevDelimiter;
            if (currentHintIndex < expressionList.getExpressions().length) {
                PsiExpression expression2 = expressionList.getExpressions()[currentHintIndex];
                for (prevDelimiter = expression2; prevDelimiter != null && !(prevDelimiter instanceof PsiJavaToken); prevDelimiter = prevDelimiter.getPrevSibling()) {
                }
                for (nextDelimiter = expression2; nextDelimiter != null && !(nextDelimiter instanceof PsiJavaToken); nextDelimiter = nextDelimiter.getNextSibling()) {
                }
            } else {
                prevDelimiter = expressionList.getFirstChild();
                nextDelimiter = expressionList.getLastChild();
            }
            if (prevDelimiter != null && nextDelimiter != null) {
                ParameterHintsPass.syncUpdate(expressionList.getParent(), editor);
                for (Inlay inlay : editor.getInlayModel().getInlineElementsInRange(prevDelimiter.getTextRange().getEndOffset(), nextDelimiter.getTextRange().getStartOffset())) {
                    if (!presentationManager.isParameterHint(inlay)) continue;
                    hint = inlay;
                    break;
                }
            }
        }
        if (hint == this.myHighlightedHint) {
            return;
        }
        if (this.myHighlightedHint != null && this.myHighlightedHint.isValid()) {
            presentationManager.setHighlighted(this.myHighlightedHint, false);
        }
        this.myHighlightedHint = hint;
        if (this.myHighlightedHint != null && this.myHighlightedHint.isValid()) {
            presentationManager.setHighlighted(this.myHighlightedHint, true);
        }
    }

    public void dispose() {
        if (this.myHighlightedHint != null) {
            if (this.myHighlightedHint.isValid()) {
                ParameterHintsPresentationManager.getInstance().setHighlighted(this.myHighlightedHint, false);
            }
            this.myHighlightedHint = null;
        }
    }

    private static PsiSubstitutor getCandidateInfoSubstitutor(PsiElement argList, CandidateInfo candidate) {
        return (PsiSubstitutor)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(ObjectUtils.notNull((Object)argList, (Object)candidate.getElement()), false, () -> candidate instanceof MethodCandidateInfo && ((MethodCandidateInfo)candidate).isInferencePossible() ? ((MethodCandidateInfo)candidate).inferTypeArguments((ParameterTypeInferencePolicy)CompletionParameterTypeInferencePolicy.INSTANCE, true) : candidate.getSubstitutor());
    }

    private static boolean isAssignableParametersBeforeGivenIndex(PsiParameter[] parms, PsiExpression[] args, int length, PsiSubstitutor substitutor) {
        for (int j = 0; j < length; ++j) {
            PsiParameter parm = parms[j];
            PsiExpression arg = args[j];
            assert (parm.isValid());
            assert (arg.isValid());
            PsiType parmType = parm.getType();
            PsiType argType = arg.getType();
            if (argType == null) continue;
            if (parmType instanceof PsiEllipsisType) {
                parmType = ((PsiEllipsisType)parmType).getComponentType();
            }
            if ((parmType = substitutor.substitute(parmType)).isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    @NotNull
    public Class<PsiExpressionList> getArgumentListClass() {
        if (PsiExpressionList.class == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return PsiExpressionList.class;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JavaTokenType.RBRACE;
        if (iElementType == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set2 = ourArgumentListAllowedParentClassesSet;
        if (set2 == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return set2;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set2 = ourStopSearch;
        if (set2 == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return set2;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JavaTokenType.COMMA;
        if (iElementType == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(13);
        }
        return iElementType;
    }

    @NotNull
    public PsiExpression[] getActualParameters(@NotNull PsiExpressionList psiExpressionList) {
        if (psiExpressionList == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(14);
        }
        PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
        if (psiExpressionArray == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(15);
        }
        return psiExpressionArray;
    }

    private static PsiCall getCall(PsiExpressionList list2) {
        PsiElement listParent = list2.getParent();
        if (listParent instanceof PsiMethodCallExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiNewExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiAnonymousClass) {
            return (PsiCall)listParent.getParent();
        }
        if (listParent instanceof PsiEnumConstant) {
            return (PsiCall)listParent;
        }
        return null;
    }

    private static CandidateInfo[] getMethods(PsiExpressionList argList) {
        PsiCall call = MethodParameterInfoHandler.getCall(argList);
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)argList.getProject()).getResolveHelper();
        if (call instanceof PsiCallExpression) {
            CandidateInfo[] candidates = MethodParameterInfoHandler.getCandidates((PsiCallExpression)call);
            ArrayList<CandidateInfo> result2 = new ArrayList<CandidateInfo>();
            if (!(argList.getParent() instanceof PsiAnonymousClass)) {
                block0: for (CandidateInfo candidate : candidates) {
                    PsiMethod methodCandidate = (PsiMethod)candidate.getElement();
                    for (CandidateInfo info : result2) {
                        if (!MethodSignatureUtil.isSuperMethod((PsiMethod)methodCandidate, (PsiMethod)((PsiMethod)info.getElement()))) continue;
                        continue block0;
                    }
                    if (!candidate.isStaticsScopeCorrect()) continue;
                    boolean accessible = candidate.isAccessible();
                    if (!accessible && methodCandidate.getModifierList().hasModifierProperty("private")) {
                        accessible = JavaPsiFacade.getInstance((Project)methodCandidate.getProject()).getResolveHelper().isAccessible((PsiMember)methodCandidate, methodCandidate.getModifierList(), (PsiElement)call, null, null);
                    }
                    if (!accessible) continue;
                    result2.add(candidate);
                }
            } else {
                PsiClass aClass = (PsiClass)argList.getParent();
                for (CandidateInfo candidate : candidates) {
                    if (!candidate.isStaticsScopeCorrect() || !helper.isAccessible((PsiMember)((PsiMethod)candidate.getElement()), (PsiElement)argList, aClass)) continue;
                    result2.add(candidate);
                }
            }
            return result2.isEmpty() ? candidates : result2.toArray(new CandidateInfo[result2.size()]);
        }
        assert (call instanceof PsiEnumConstant);
        PsiMethod[] constructors = ((PsiEnumConstant)call).getContainingClass().getConstructors();
        CandidateInfo[] result3 = new CandidateInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result3[i] = new CandidateInfo((PsiElement)constructors[i], PsiSubstitutor.EMPTY);
        }
        return result3;
    }

    private static CandidateInfo[] getCandidates(PsiCallExpression call) {
        MethodResolverProcessor processor2 = new MethodResolverProcessor((PsiElement)call, call.getContainingFile(), new PsiConflictResolver[0]){

            @Override
            protected boolean acceptVarargs() {
                return false;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor2, call, true);
        }
        catch (MethodProcessorSetupFailedException e) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        List<CandidateInfo> results = processor2.getResults();
        return results.toArray(new CandidateInfo[results.size()]);
    }

    public static String updateMethodPresentation(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutor, @NotNull ParameterInfoUIContext context) {
        if (method == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(16);
        }
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(17);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!method.isValid() || substitutor != null && !substitutor.isValid()) {
            context.setUIComponentEnabled(false);
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO && !context.isSingleParameterInfo()) {
            if (!method.isConstructor()) {
                PsiType returnType = method.getReturnType();
                if (substitutor != null) {
                    returnType = substitutor.substitute(returnType);
                }
                assert (returnType != null) : method;
                MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)method);
                buffer.append(returnType.getPresentableText(true));
                buffer.append(" ");
            }
            buffer.append(method.getName());
            buffer.append("(");
        }
        int currentParameter = context.getCurrentParameterIndex();
        PsiParameter[] parms = method.getParameterList().getParameters();
        int numParams = parms.length;
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams > 0) {
            if (context.isSingleParameterInfo() && method.isVarArgs() && currentParameter >= numParams) {
                currentParameter = numParams - 1;
            }
            for (int j = 0; j < numParams; ++j) {
                if (context.isSingleParameterInfo() && j != currentParameter) continue;
                PsiParameter param = parms[j];
                int startOffset = buffer.length();
                if (param.isValid()) {
                    PsiType paramType = param.getType();
                    assert (paramType.isValid());
                    if (substitutor != null) {
                        assert (substitutor.isValid());
                        paramType = substitutor.substitute(paramType);
                    }
                    if (context.isSingleParameterInfo()) {
                        buffer.append("<b>");
                    }
                    MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)param);
                    String type2 = paramType.getPresentableText(true);
                    buffer.append(context.isSingleParameterInfo() ? StringUtil.escapeXml((String)type2) : type2);
                    String name2 = param.getName();
                    if (name2 != null && !context.isSingleParameterInfo()) {
                        buffer.append(" ");
                        buffer.append(name2);
                    }
                    if (context.isSingleParameterInfo()) {
                        buffer.append("</b>");
                    }
                }
                if (context.isSingleParameterInfo()) {
                    String javaDoc = new JavaDocInfoGenerator(param.getProject(), (PsiElement)param).generateMethodParameterJavaDoc();
                    if (javaDoc == null) continue;
                    if ((javaDoc = MethodParameterInfoHandler.removeHyperlinks(javaDoc)).length() < 100) {
                        buffer.append("&nbsp;&nbsp;<i>").append(javaDoc).append("</i>");
                        continue;
                    }
                    buffer.insert(0, "<table><tr><td valign='top'>").append("</td><td style='width:400px'>&nbsp;&nbsp;<i>").append(javaDoc).append("</i></td></tr></table>");
                    continue;
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !param.isVarArgs() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        } else {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO && !context.isSingleParameterInfo()) {
            buffer.append(")");
        }
        String text2 = buffer.toString();
        if (context.isSingleParameterInfo()) {
            context.setupRawUIComponentPresentation(text2);
            return text2;
        }
        return context.setupUIComponentPresentation(text2, highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), method.isDeprecated() && !context.isSingleParameterInfo() && !context.isSingleOverload(), false, context.getDefaultParameterColor());
    }

    private static String removeHyperlinks(String html) {
        return html.replaceAll("<a.*?>", "").replaceAll("</a>", "");
    }

    private static void appendModifierList(@NotNull StringBuilder buffer, @NotNull PsiModifierListOwner owner2) {
        if (buffer == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(18);
        }
        if (owner2 == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(19);
        }
        int lastSize = buffer.length();
        HashSet shownAnnotations = ContainerUtil.newHashSet();
        for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner2, (boolean)false, null, (!DumbService.isDumb((Project)owner2.getProject()) ? 1 : 0) != 0)) {
            String referenceName;
            PsiElement resolved;
            PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
            if (element == null || (resolved = element.resolve()) instanceof PsiClass && (!JavaDocInfoGenerator.isDocumentedAnnotationType((PsiClass)resolved) || AnnotationTargetUtil.findAnnotationTarget((PsiClass)((PsiClass)resolved), (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null) || !shownAnnotations.add(referenceName = element.getReferenceName()) && !JavaDocInfoGenerator.isRepeatableAnnotationType(resolved)) continue;
            if (lastSize != buffer.length()) {
                buffer.append(' ');
            }
            buffer.append('@').append(referenceName);
        }
        if (lastSize != buffer.length()) {
            buffer.append(' ');
        }
    }

    public void updateUI(Object p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            MethodParameterInfoHandler.$$$reportNull$$$0(20);
        }
        if (p instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)p;
            PsiMethod method = (PsiMethod)info.getElement();
            if (!method.isValid()) {
                context.setUIComponentEnabled(false);
                return;
            }
            MethodParameterInfoHandler.updateMethodPresentation(method, MethodParameterInfoHandler.getCandidateInfoSubstitutor(context.getParameterOwner(), info), context);
        } else {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, null, context);
        }
    }

    public boolean supportsOverloadSwitching() {
        return CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiExpressionList";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsForArgumentList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatibleParameterCount";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "highlightHints";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateMethodPresentation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendModifierList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

