/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement {
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;
    private final PsiNameValuePair[] myPairs;
    protected final String myText;

    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, @NotNull PsiNameValuePair[] values, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(1);
        }
        if (values == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(2);
        }
        if (annotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(3);
        }
        super((PsiElement)modifierListOwner);
        this.myAnnotation = fqn;
        ObjectUtils.assertAllElementsNotNull((Object[])values);
        this.myPairs = values;
        ObjectUtils.assertAllElementsNotNull((Object[])annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
    }

    public static String calcText(PsiModifierListOwner modifierListOwner, @NotNull String annotation) {
        String name2;
        if (annotation == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(4);
        }
        String shortName = annotation.substring(annotation.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name2 = ((PsiNamedElement)modifierListOwner).getName()) != null) {
            FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(modifierListOwner.getLanguage());
            return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{provider.getType((PsiElement)modifierListOwner), name2, shortName});
        }
        return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{shortName});
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file2, int offset) {
        PsiElement id;
        PsiElement target2;
        PsiReference reference = file2.findReferenceAt(offset);
        if (reference != null && (target2 = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target2;
        }
        PsiElement element = file2.findElementAt(offset);
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
        if (listOwner instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)listOwner).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset)) {
            return listOwner;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Add '" + StringUtil.getShortName((String)this.myAnnotation) + "' Annotation";
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(8);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(9);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(10);
        }
        return AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)startElement, this.myAnnotation);
    }

    public static boolean isAvailable(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotationFQN) {
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(11);
        }
        if (annotationFQN == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(12);
        }
        if (!modifierListOwner.isValid()) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)modifierListOwner)) {
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        return modifierList != null && !(modifierList instanceof LightElement) && !(modifierListOwner instanceof LightElement) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annotationFQN, (boolean)false, (boolean)false, (boolean)true);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(14);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(15);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(16);
        }
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project2);
        PsiModifierList modifierList = myModifierListOwner.getModifierList();
        if (modifierList == null || modifierList.findAnnotation(this.myAnnotation) != null) {
            return;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project2).findClass(this.myAnnotation, myModifierListOwner.getResolveScope());
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = aClass != null && aClass.getManager().isInProject((PsiElement)aClass) && AnnotationsHighlightUtil.getRetentionPolicy(aClass) == RetentionPolicy.RUNTIME ? ExternalAnnotationsManager.AnnotationPlace.IN_CODE : annotationsManager.chooseAnnotationsPlace((PsiElement)myModifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String fqn : this.myAnnotationsToRemove) {
                annotationsManager.deannotate(myModifierListOwner, fqn);
            }
            try {
                annotationsManager.annotateExternally(myModifierListOwner, this.myAnnotation, file2, this.myPairs);
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {}
        } else {
            PsiFile containingFile = myModifierListOwner.getContainingFile();
            WriteCommandAction.runWriteCommandAction((Project)project2, null, null, () -> {
                if (project2 == null) {
                    AddAnnotationPsiFix.$$$reportNull$$$0(20);
                }
                AddAnnotationPsiFix.removePhysicalAnnotations(myModifierListOwner, this.myAnnotationsToRemove);
                PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotation(this.myAnnotation, this.myPairs, modifierList);
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)inserted);
            }, (PsiFile[])new PsiFile[]{containingFile});
            if (containingFile != file2) {
                UndoUtil.markPsiFileForUndo((PsiFile)file2);
            }
        }
    }

    public static PsiAnnotation addPhysicalAnnotation(String fqn, PsiNameValuePair[] pairs, PsiModifierList modifierList) {
        PsiAnnotation inserted = modifierList.addAnnotation(fqn);
        for (PsiNameValuePair pair2 : pairs) {
            inserted.setDeclaredAttributeValue(pair2.getName(), pair2.getValue());
        }
        return inserted;
    }

    public static void removePhysicalAnnotations(@NotNull PsiModifierListOwner owner2, String ... fqns) {
        if (owner2 == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(17);
        }
        if (fqns == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(18);
        }
        for (String fqn : fqns) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (boolean)true, (String[])new String[]{fqn});
            if (annotation == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) continue;
            annotation.delete();
        }
    }

    @NotNull
    protected String[] getAnnotationsToRemove() {
        if (this.myAnnotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(19);
        }
        return this.myAnnotationsToRemove;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 7: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcText";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removePhysicalAnnotations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

