/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIfConditionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiIfStatement ifStatement;
        if (project2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(1);
        }
        if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) == null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null || !(condition2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiType expressionType = polyadicExpression.getType();
        if (expressionType == null || !PsiType.BOOLEAN.isAssignableFrom(expressionType)) {
            return false;
        }
        IElementType operation = polyadicExpression.getOperationTokenType();
        if (operation != JavaTokenType.OROR && operation != JavaTokenType.ANDAND) {
            return false;
        }
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.extract.if.condition.text", (Object[])new Object[]{PsiExpressionTrimRenderer.render((PsiExpression)operand2)}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement;
        if (project2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(3);
        }
        if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiStatement newIfStatement = ExtractIfConditionAction.create(factory, ifStatement, element);
        if (newIfStatement == null) {
            return;
        }
        ifStatement.replace(codeStyleManager.reformat((PsiElement)newIfStatement));
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement element) {
        PsiExpression condition2;
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(4);
        }
        if (ifStatement == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(5);
        }
        if (element == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(6);
        }
        if ((condition2 = ifStatement.getCondition()) == null || !(condition2 instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return null;
        }
        return ExtractIfConditionAction.create(factory, ifStatement.getThenBranch(), ifStatement.getElseBranch(), operand2, ExtractIfConditionAction.removeOperand(factory, polyadicExpression, operand2), polyadicExpression.getOperationTokenType());
    }

    @NotNull
    private static PsiExpression removeOperand(@NotNull PsiElementFactory factory, @NotNull PsiPolyadicExpression expression2, @NotNull PsiExpression operand2) {
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(7);
        }
        if (expression2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(8);
        }
        if (operand2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(9);
        }
        StringBuilder sb = new StringBuilder();
        for (PsiExpression e : expression2.getOperands()) {
            if (e == operand2) continue;
            PsiJavaToken token = expression2.getTokenBeforeOperand(e);
            if (token != null && sb.length() != 0) {
                sb.append(token.getText()).append(" ");
            }
            sb.append(e.getText());
        }
        PsiExpression psiExpression = factory.createExpressionFromText(sb.toString(), (PsiElement)expression2);
        if (psiExpression == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(10);
        }
        return psiExpression;
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @Nullable PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, @NotNull IElementType operation) {
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(11);
        }
        if (extract == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(12);
        }
        if (leave == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(13);
        }
        if (operation == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(14);
        }
        if (thenBranch == null) {
            return null;
        }
        if (operation == JavaTokenType.OROR) {
            return ExtractIfConditionAction.createOrOr(factory, thenBranch, elseBranch, extract, leave);
        }
        if (operation == JavaTokenType.ANDAND) {
            return ExtractIfConditionAction.createAndAnd(factory, thenBranch, elseBranch, extract, leave);
        }
        return null;
    }

    @NotNull
    private static PsiStatement createAndAnd(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave) {
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(15);
        }
        if (thenBranch == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(16);
        }
        if (extract == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(17);
        }
        if (leave == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(18);
        }
        PsiStatement psiStatement = factory.createStatementFromText(ExtractIfConditionAction.createIfString(extract, ExtractIfConditionAction.createIfString(leave, thenBranch, elseBranch), elseBranch), (PsiElement)thenBranch);
        if (psiStatement == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(19);
        }
        return psiStatement;
    }

    @NotNull
    private static PsiStatement createOrOr(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave) {
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(20);
        }
        if (thenBranch == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(21);
        }
        if (extract == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(22);
        }
        if (leave == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(23);
        }
        PsiStatement psiStatement = factory.createStatementFromText(ExtractIfConditionAction.createIfString(extract, thenBranch, ExtractIfConditionAction.createIfString(leave, thenBranch, elseBranch)), (PsiElement)thenBranch);
        if (psiStatement == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(24);
        }
        return psiStatement;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch) {
        if (condition2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(25);
        }
        if (thenBranch == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(26);
        }
        String string = ExtractIfConditionAction.createIfString(condition2.getText(), ExtractIfConditionAction.toThenBranchString(thenBranch), ExtractIfConditionAction.toElseBranchString(elseBranch, false));
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull PsiStatement thenBranch, @Nullable String elseBranch) {
        if (condition2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(28);
        }
        if (thenBranch == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(29);
        }
        String string = ExtractIfConditionAction.createIfString(condition2.getText(), ExtractIfConditionAction.toThenBranchString(thenBranch), elseBranch);
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition2, @NotNull String thenBranch, @Nullable PsiStatement elseBranch) {
        if (condition2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(31);
        }
        if (thenBranch == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(32);
        }
        String string = ExtractIfConditionAction.createIfString(condition2.getText(), thenBranch, ExtractIfConditionAction.toElseBranchString(elseBranch, true));
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static String createIfString(@NotNull String condition2, @NotNull String thenBranch, @Nullable String elseBranch) {
        if (condition2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(34);
        }
        if (thenBranch == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(35);
        }
        String elsePart = elseBranch != null ? " else " + elseBranch : "";
        String string = "if (" + condition2 + ")\n" + thenBranch + elsePart;
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static String toThenBranchString(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(37);
        }
        if (!(statement2 instanceof PsiBlockStatement)) {
            String string = "{ " + statement2.getText() + " }";
            if (string == null) {
                ExtractIfConditionAction.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = statement2.getText();
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    private static String toElseBranchString(@Nullable PsiStatement statement2, boolean skipElse) {
        if (statement2 == null) {
            return null;
        }
        if (statement2 instanceof PsiBlockStatement || skipElse && statement2 instanceof PsiIfStatement) {
            return statement2.getText();
        }
        return "{ " + statement2.getText() + " }";
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression2) {
        if (e == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(40);
        }
        if (expression2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(41);
        }
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand2 : expression2.getOperands()) {
            TextRange operandTextRange = operand2.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand2;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.extract.if.condition.family", (Object[])new Object[0]);
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 8: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 10: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction";
                break;
            }
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extract";
                break;
            }
            case 13: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leave";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 16: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranch";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOperand";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAnd";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrOr";
                break;
            }
            case 27: 
            case 30: 
            case 33: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfString";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "toThenBranchString";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeOperand";
                break;
            }
            case 10: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 42: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createAndAnd";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createOrOr";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createIfString";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toThenBranchString";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findOperand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 19: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

