/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.openapi.editor.actions.FlipCommaIntention;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;

public class JavaFlipper
implements FlipCommaIntention.Flipper {
    @Override
    public boolean flip(PsiElement left, PsiElement right) {
        if (left instanceof PsiVariable && right instanceof PsiVariable) {
            if (left instanceof PsiParameter || right instanceof PsiParameter) {
                return false;
            }
            PsiVariable leftVariable = (PsiVariable)left;
            PsiVariable rightVariable = (PsiVariable)right;
            PsiIdentifier leftIdentifier = leftVariable.getNameIdentifier();
            assert (leftIdentifier != null);
            PsiIdentifier rightIdentifier = rightVariable.getNameIdentifier();
            assert (rightIdentifier != null);
            PsiElement leftLast = leftVariable.getLastChild();
            leftLast = PsiUtil.isJavaToken((PsiElement)leftLast, (IElementType)JavaTokenType.SEMICOLON) ? leftLast.getPrevSibling() : leftLast;
            PsiElement rightLast = rightVariable.getLastChild();
            rightLast = PsiUtil.isJavaToken((PsiElement)rightLast, (IElementType)JavaTokenType.SEMICOLON) ? rightLast.getPrevSibling() : rightLast;
            left.addRangeBefore((PsiElement)rightIdentifier, rightLast, (PsiElement)leftIdentifier);
            right.addRangeBefore((PsiElement)leftIdentifier, leftLast, (PsiElement)rightIdentifier);
            left.deleteChildRange((PsiElement)leftIdentifier, leftLast);
            right.deleteChildRange((PsiElement)rightIdentifier, rightLast);
            return true;
        }
        return false;
    }
}

