/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceCastWithVariableAction
extends PsiElementBaseIntentionAction {
    private String myReplaceVariableName = "";

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(1);
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (typeCastExpression == null || method == null) {
            return false;
        }
        PsiExpression operand2 = typeCastExpression.getOperand();
        if (!(operand2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression operandReference = (PsiReferenceExpression)operand2;
        PsiElement resolved = operandReference.resolve();
        if (resolved == null || !(resolved instanceof PsiParameter) && !(resolved instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable replacement = ReplaceCastWithVariableAction.findReplacement(method, (PsiVariable)resolved, typeCastExpression);
        if (replacement == null) {
            return false;
        }
        this.myReplaceVariableName = replacement.getName();
        this.setText(CodeInsightBundle.message((String)"intention.replace.cast.with.var.text", (Object[])new Object[]{typeCastExpression.getText(), this.myReplaceVariableName}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiTypeCastExpression typeCastExpression;
        if (project2 == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(3);
        }
        if ((typeCastExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class)) == null) {
            return;
        }
        PsiTypeCastExpression toReplace = typeCastExpression.getParent() instanceof PsiParenthesizedExpression ? typeCastExpression.getParent() : typeCastExpression;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        toReplace.replace((PsiElement)factory.createExpressionFromText(this.myReplaceVariableName, (PsiElement)toReplace));
    }

    @Nullable
    private static PsiLocalVariable findReplacement(@NotNull PsiMethod method, @NotNull PsiVariable castedVar, @NotNull PsiTypeCastExpression expression2) {
        if (method == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(4);
        }
        if (castedVar == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(5);
        }
        if (expression2 == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(6);
        }
        TextRange expressionTextRange = expression2.getTextRange();
        for (PsiExpression occurrence : CodeInsightUtil.findExpressionOccurrences((PsiElement)method, (PsiExpression)expression2)) {
            ProgressIndicatorProvider.checkCanceled();
            TextRange occurrenceTextRange = occurrence.getTextRange();
            if (occurrence == expression2 || occurrenceTextRange.getEndOffset() >= expressionTextRange.getStartOffset()) continue;
            PsiLocalVariable variable = ReplaceCastWithVariableAction.getVariable(occurrence);
            PsiCodeBlock methodBody2 = method.getBody();
            if (variable == null || methodBody2 == null || ReplaceCastWithVariableAction.isChangedBetween(castedVar, (PsiElement)methodBody2, (PsiElement)occurrence, (PsiElement)expression2) || ReplaceCastWithVariableAction.isChangedBetween((PsiVariable)variable, (PsiElement)methodBody2, (PsiElement)occurrence, (PsiElement)expression2)) continue;
            return variable;
        }
        return null;
    }

    private static boolean isChangedBetween(final @NotNull PsiVariable variable, @NotNull PsiElement scope, final @NotNull PsiElement start, final @NotNull PsiElement end) {
        if (variable == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(8);
        }
        if (start == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(9);
        }
        if (end == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(10);
        }
        if (variable.hasModifierProperty("final")) {
            return false;
        }
        final Ref result2 = new Ref();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
            private boolean inScope;

            public void visitElement(PsiElement element) {
                if (element == start) {
                    this.inScope = true;
                }
                if (element == end) {
                    this.inScope = false;
                    this.stopWalking();
                }
                super.visitElement(element);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiReferenceExpression referenceExpression;
                if (this.inScope && expression2.getLExpression() instanceof PsiReferenceExpression && variable.equals((referenceExpression = (PsiReferenceExpression)expression2.getLExpression()).resolve())) {
                    result2.set((Object)true);
                    this.stopWalking();
                }
                super.visitAssignmentExpression(expression2);
            }
        });
        return result2.get() == Boolean.TRUE;
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiExpression occurrence) {
        PsiReferenceExpression referenceExpression;
        PsiElement resolved;
        PsiAssignmentExpression assignmentExpression;
        PsiElement parent;
        if (occurrence == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(11);
        }
        if ((parent = occurrence.getParent()) instanceof PsiLocalVariable) {
            return (PsiLocalVariable)parent;
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression() instanceof PsiReferenceExpression && (resolved = (referenceExpression = (PsiReferenceExpression)assignmentExpression.getLExpression()).resolve()) instanceof PsiLocalVariable) {
            return (PsiLocalVariable)resolved;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.replace.cast.with.var.family", (Object[])new Object[0]);
        if (string == null) {
            ReplaceCastWithVariableAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castedVar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReplacement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isChangedBetween";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

