/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundAutoCloseableAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(1);
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(LanguageLevel.JDK_1_7)) {
            return false;
        }
        PsiType type2 = null;
        PsiLocalVariable variable = SurroundAutoCloseableAction.findVariable(element);
        if (variable != null) {
            type2 = variable.getType();
        } else {
            PsiExpression expression2 = SurroundAutoCloseableAction.findExpression(element);
            if (expression2 != null) {
                type2 = expression2.getType();
            }
        }
        return type2 != null && SurroundAutoCloseableAction.rightType(type2);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiLocalVariable variable;
        if (project2 == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(3);
        }
        if ((variable = SurroundAutoCloseableAction.findVariable(element)) != null) {
            SurroundAutoCloseableAction.processVariable(project2, editor, variable);
        } else {
            PsiExpression expression2 = SurroundAutoCloseableAction.findExpression(element);
            if (expression2 != null) {
                SurroundAutoCloseableAction.processExpression(project2, editor, expression2);
            }
        }
    }

    private static PsiLocalVariable findVariable(PsiElement element) {
        PsiElement lastVar;
        PsiElement sibling;
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable != null && variable.getInitializer() != null && variable.getParent() instanceof PsiDeclarationStatement && variable.getParent().getParent() instanceof PsiCodeBlock) {
            return variable;
        }
        if (variable == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiDeclarationStatement && (lastVar = (PsiElement)ArrayUtil.getLastElement((Object[])((PsiDeclarationStatement)sibling).getDeclaredElements())) instanceof PsiLocalVariable && ((PsiLocalVariable)lastVar).getInitializer() != null) {
            return (PsiLocalVariable)lastVar;
        }
        return null;
    }

    private static PsiExpression findExpression(PsiElement element) {
        PsiElement sibling;
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        if (expression2 != null && expression2.getParent() instanceof PsiExpressionStatement && expression2.getParent().getParent() instanceof PsiCodeBlock) {
            return expression2;
        }
        if (expression2 == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)sibling).getExpression();
        }
        return null;
    }

    private static boolean rightType(PsiType type2) {
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.AutoCloseable");
    }

    private static void processVariable(Project project2, Editor editor, PsiLocalVariable variable) {
        PsiJavaToken brace;
        PsiCodeBlock tryBlock;
        PsiExpression initializer = (PsiExpression)ObjectUtils.assertNotNull((Object)variable.getInitializer());
        PsiElement declaration2 = variable.getParent();
        PsiElement codeBlock = declaration2.getParent();
        LocalSearchScope scope = new LocalSearchScope(codeBlock);
        PsiElement last = null;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            PsiElement usage = PsiTreeUtil.findPrevParent((PsiElement)codeBlock, (PsiElement)reference.getElement());
            if (last != null && usage.getTextOffset() <= last.getTextOffset()) continue;
            last = usage;
        }
        String text2 = "try (" + variable.getTypeElement().getText() + " " + variable.getName() + " = " + initializer.getText() + ") {}";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiTryStatement armStatement = (PsiTryStatement)declaration2.replace((PsiElement)factory.createStatementFromText(text2, codeBlock));
        List<PsiElement> toFormat = null;
        if (last != null) {
            toFormat = SurroundAutoCloseableAction.moveStatements(last, armStatement);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiElement formattedElement = codeStyleManager.reformat((PsiElement)armStatement);
        if (toFormat != null) {
            for (PsiElement psiElement : toFormat) {
                codeStyleManager.reformat(psiElement);
            }
        }
        if (last == null && (tryBlock = ((PsiTryStatement)formattedElement).getTryBlock()) != null && (brace = tryBlock.getLBrace()) != null) {
            editor.getCaretModel().moveToOffset(brace.getTextOffset() + 1);
        }
    }

    private static List<PsiElement> moveStatements(PsiElement last, PsiTryStatement statement2) {
        PsiCodeBlock tryBlock = statement2.getTryBlock();
        assert (tryBlock != null) : statement2.getText();
        PsiElement parent = statement2.getParent();
        LocalSearchScope scope = new LocalSearchScope(parent);
        SmartList toFormat = new SmartList();
        PsiElement stopAt = last.getNextSibling();
        PsiElement i = statement2.getNextSibling();
        while (i != null && i != stopAt) {
            PsiElement child = i;
            i = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)i);
            if (!(child instanceof PsiDeclarationStatement)) continue;
            PsiElement anchor = child;
            for (PsiElement declared : ((PsiDeclarationStatement)child).getDeclaredElements()) {
                if (!(declared instanceof PsiLocalVariable)) continue;
                int endOffset = last.getTextRange().getEndOffset();
                boolean contained = ReferencesSearch.search((PsiElement)declared, (SearchScope)scope).forEach(ref -> ref.getElement().getTextOffset() <= endOffset);
                if (contained) continue;
                PsiLocalVariable var = (PsiLocalVariable)declared;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement2.getProject());
                String name2 = var.getName();
                assert (name2 != null) : child.getText();
                toFormat.add(parent.addBefore((PsiElement)factory.createVariableDeclarationStatement(name2, var.getType(), null), (PsiElement)statement2));
                PsiExpression varInit = var.getInitializer();
                if (varInit != null) {
                    String varAssignText = name2 + " = " + varInit.getText() + ";";
                    anchor = parent.addAfter((PsiElement)factory.createStatementFromText(varAssignText, parent), anchor);
                }
                var.delete();
            }
            if (child != last || child.isValid()) continue;
            last = anchor;
        }
        PsiElement first = statement2.getNextSibling();
        tryBlock.addRangeBefore(first, last, (PsiElement)tryBlock.getRBrace());
        parent.deleteChildRange(first, last);
        return toFormat;
    }

    private static void processExpression(Project project2, Editor editor, PsiExpression expression2) {
        PsiType type2 = (PsiType)ObjectUtils.assertNotNull((Object)expression2.getType());
        PsiElement statement2 = expression2.getParent();
        PsiElement codeBlock = statement2.getParent();
        String text2 = "try (" + type2.getCanonicalText(true) + " r = " + expression2.getText() + ") {}";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiTryStatement tryStatement = (PsiTryStatement)statement2.replace((PsiElement)factory.createStatementFromText(text2, codeBlock));
        tryStatement = (PsiTryStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)tryStatement);
        PsiResourceList resourceList = (tryStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(tryStatement)).getResourceList();
        if (resourceList != null) {
            PsiResourceVariable var = (PsiResourceVariable)resourceList.iterator().next();
            PsiIdentifier id = var.getNameIdentifier();
            PsiExpression initializer = var.getInitializer();
            if (id != null && initializer != null) {
                type2 = initializer.getType();
                String[] names = IntroduceVariableBase.getSuggestedName((PsiType)type2, (PsiExpression)initializer).names;
                PsiType[] types = (PsiType[])Stream.of(new TypeSelectorManagerImpl(project2, type2, initializer, PsiExpression.EMPTY_ARRAY).getTypesForAll()).filter(SurroundAutoCloseableAction::rightType).toArray(PsiType[]::new);
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)var);
                builder.replaceElement((PsiElement)id, (Expression)new NamesExpression(names));
                builder.replaceElement((PsiElement)var.getTypeElement(), (Expression)new TypeExpression(project2, types));
                builder.run(editor, true);
            }
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.surround.resource.with.ARM.block", (Object[])new Object[0]);
        if (string == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SurroundAutoCloseableAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Template
    implements SurroundDescriptor,
    Surrounder {
        private Surrounder[] mySurrounders = new Surrounder[]{this};

        @NotNull
        public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
            PsiElement[] psiElementArray;
            PsiExpression expr = CodeInsightUtil.findExpressionInRange(file2, startOffset, endOffset);
            if (expr == null) {
                expr = SurroundAutoCloseableAction.findExpression(file2.findElementAt(endOffset));
            }
            if (expr != null && SurroundAutoCloseableAction.rightType(expr.getType())) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = expr;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            if (psiElementArray == null) {
                Template.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }

        @NotNull
        public Surrounder[] getSurrounders() {
            if (this.mySurrounders == null) {
                Template.$$$reportNull$$$0(1);
            }
            return this.mySurrounders;
        }

        public boolean isExclusive() {
            return false;
        }

        public String getTemplateDescription() {
            return CodeInsightBundle.message((String)"intention.surround.with.ARM.block.template", (Object[])new Object[0]);
        }

        public boolean isApplicable(@NotNull PsiElement[] elements) {
            if (elements == null) {
                Template.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Nullable
        public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement[] elements) {
            if (project2 == null) {
                Template.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                Template.$$$reportNull$$$0(4);
            }
            if (elements == null) {
                Template.$$$reportNull$$$0(5);
            }
            if (elements.length == 1 && elements[0] instanceof PsiExpression) {
                SurroundAutoCloseableAction.processExpression(project2, editor, (PsiExpression)elements[0]);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsToSurround";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSurrounders";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "surroundElements";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NamesExpression
    extends Expression {
        private final String[] myNames;

        public NamesExpression(String[] names) {
            this.myNames = names;
        }

        public Result calculateResult(ExpressionContext context) {
            return this.calculateQuickResult(context);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myNames[0]);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return (LookupElement[])Stream.of(this.myNames).map(LookupElementBuilder::create).toArray(LookupElement[]::new);
        }
    }
}

