/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener {
    private static final Logger LOG = Logger.getInstance(ImageOrColorPreviewManager.class);
    private static final Key<KeyListener> EDITOR_LISTENER_ADDED = Key.create((String)"previewManagerListenerAdded");
    private final Alarm alarm = new Alarm();
    @Nullable
    private Collection<PsiElement> myElements;

    public ImageOrColorPreviewManager(EditorFactory editorFactory) {
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ImageOrColorPreviewManager.this.registerListeners(event.getEditor());
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                Editor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((editor = event.getEditor()).isOneLineMode()) {
                    return;
                }
                KeyListener keyListener = (KeyListener)EDITOR_LISTENER_ADDED.get((UserDataHolder)editor);
                if (keyListener != null) {
                    EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, null);
                    editor.getContentComponent().removeKeyListener(keyListener);
                    editor.removeEditorMouseMotionListener((EditorMouseMotionListener)ImageOrColorPreviewManager.this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private void registerListeners(final Editor editor) {
        if (editor.isOneLineMode()) {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !ImageOrColorPreviewManager.isSupportedFile(psiFile)) {
            return;
        }
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PointerInfo pointerInfo;
                if (e.getKeyCode() == 16 && !editor.isOneLineMode() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location, editor.getContentComponent());
                    ImageOrColorPreviewManager.this.alarm.cancelAllRequests();
                    ImageOrColorPreviewManager.this.alarm.addRequest((Runnable)new PreviewRequest(location, editor, true), 100);
                }
            }
        };
        editor.getContentComponent().addKeyListener(keyListener);
        EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, (Object)keyListener);
    }

    private static boolean isSupportedFile(PsiFile psiFile) {
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            for (ElementPreviewProvider provider : (ElementPreviewProvider[])Extensions.getExtensions((ExtensionPointName)ElementPreviewProvider.EP_NAME)) {
                if (!provider.isSupportedFile(file2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> getPsiElementsAt(Point point, Editor editor) {
        Document document;
        if (editor.isDisposed()) {
            Set<PsiElement> set2 = Collections.emptySet();
            if (set2 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(0);
            }
            return set2;
        }
        Project project2 = editor.getProject();
        if (project2 == null || project2.isDisposed()) {
            Set<PsiElement> set3 = Collections.emptySet();
            if (set3 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(1);
            }
            return set3;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getPsiFile(document = editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !psiFile.isValid()) {
            Set<PsiElement> set4 = Collections.emptySet();
            if (set4 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(2);
            }
            return set4;
        }
        Set<PsiElement> elements = Collections.newSetFromMap(ContainerUtil.createWeakMap());
        int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
        if (documentManager.isCommitted(document)) {
            ContainerUtil.addIfNotNull(elements, (Object)InjectedLanguageUtil.findElementAtNoCommit(psiFile, offset));
        }
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            ContainerUtil.addIfNotNull(elements, (Object)file2.findElementAt(offset));
        }
        Set<PsiElement> set5 = elements;
        if (set5 == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(3);
        }
        return set5;
    }

    public void dispose() {
        this.alarm.cancelAllRequests();
        this.myElements = null;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Editor editor;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(4);
        }
        if ((editor = event.getEditor()).isOneLineMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        Point point = event.getMouseEvent().getPoint();
        if (this.myElements == null && event.getMouseEvent().isShiftDown()) {
            this.alarm.addRequest((Runnable)new PreviewRequest(point, editor, false), 100);
        } else if (this.myElements != null) {
            Collection<PsiElement> elements = this.myElements;
            if (!ImageOrColorPreviewManager.getPsiElementsAt(point, editor).equals(elements)) {
                this.myElements = null;
                for (ElementPreviewProvider provider : (ElementPreviewProvider[])Extensions.getExtensions((ExtensionPointName)ElementPreviewProvider.EP_NAME)) {
                    try {
                        if (elements != null) {
                            for (PsiElement element : elements) {
                                provider.hide(element, editor);
                            }
                            continue;
                        }
                        provider.hide(null, editor);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementsAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PreviewRequest
    implements Runnable {
        private final Point point;
        private final Editor editor;
        private final boolean keyTriggered;

        public PreviewRequest(Point point, Editor editor, boolean keyTriggered) {
            this.point = point;
            this.editor = editor;
            this.keyTriggered = keyTriggered;
        }

        @Override
        public void run() {
            Collection elements = ImageOrColorPreviewManager.getPsiElementsAt(this.point, this.editor);
            if (elements.equals(ImageOrColorPreviewManager.this.myElements)) {
                return;
            }
            for (PsiElement element : elements) {
                if (element == null || !element.isValid()) {
                    return;
                }
                if (PsiDocumentManager.getInstance((Project)element.getProject()).isUncommited(this.editor.getDocument()) || DumbService.getInstance((Project)element.getProject()).isDumb()) {
                    return;
                }
                for (ElementPreviewProvider provider : (ElementPreviewProvider[])ElementPreviewProvider.EP_NAME.getExtensions()) {
                    if (!provider.isSupportedFile(element.getContainingFile())) continue;
                    try {
                        provider.show(element, this.editor, this.point, this.keyTriggered);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            ImageOrColorPreviewManager.this.myElements = elements;
        }
    }
}

