/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.HtmlTextContextType;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlZenCodingGeneratorImpl
extends XmlZenCodingGenerator {
    public static final XmlZenCodingGeneratorImpl INSTANCE = new XmlZenCodingGeneratorImpl();

    private static boolean isTrueXml(FileType type2) {
        return type2 == StdFileTypes.XHTML || type2 == StdFileTypes.JSPX || type2 == StdFileTypes.XML;
    }

    @Override
    @NotNull
    public String toString(@NotNull XmlTag tag, @NotNull Map<String, String> attributes, boolean hasChildren, @NotNull PsiElement context) {
        FileType fileType;
        if (tag == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(1);
        }
        if (context == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(2);
        }
        if (XmlZenCodingGeneratorImpl.isTrueXml(fileType = context.getContainingFile().getFileType())) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (tag == null) {
                    XmlZenCodingGeneratorImpl.$$$reportNull$$$0(11);
                }
                XmlZenCodingGeneratorImpl.closeUnclosingTags(tag);
            });
        }
        String string = tag.getContainingFile().getText();
        if (string == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildAttributesString(@NotNull Map<String, String> attributes, boolean hasChildren, int numberInIteration, int totalIterations, @Nullable String surroundedText) {
        if (attributes == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(4);
        }
        StringBuilder result2 = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String name2 = entry.getKey();
            String value2 = ZenCodingUtil.getValue(entry.getValue(), numberInIteration, totalIterations, surroundedText);
            result2.append(XmlZenCodingGeneratorImpl.getAttributeString(name2, value2));
            result2.append(' ');
        }
        String string = result2.toString().trim();
        if (string == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isMyContext(@NotNull CustomTemplateCallback callback, boolean wrapping) {
        if (callback == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(6);
        }
        return this.isMyContext(callback.getContext(), wrapping);
    }

    public boolean isMyContext(@NotNull PsiElement context, boolean wrapping) {
        if (context == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(7);
        }
        return this.isMyLanguage(context.getLanguage()) && (wrapping || HtmlTextContextType.isInContext(context));
    }

    protected boolean isMyLanguage(Language language) {
        return language instanceof XMLLanguage;
    }

    @Override
    public String getSuffix() {
        return "html";
    }

    @Override
    public boolean isEnabled() {
        return EmmetOptions.getInstance().isEmmetEnabled();
    }

    @Override
    public boolean isAppliedByDefault(@NotNull PsiElement context) {
        if (context == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(8);
        }
        return true;
    }

    private static String getAttributeString(String name2, String value2) {
        return name2 + "=\"" + value2 + '\"';
    }

    private static void closeUnclosingTags(@NotNull XmlTag root) {
        if (root == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(9);
        }
        final ArrayList tagToClose = new ArrayList();
        Project project2 = root.getProject();
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project2);
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!XmlZenCodingGeneratorImpl.isTagClosed(tag)) {
                    tagToClose.add(pointerManager.createSmartPsiElementPointer((PsiElement)tag));
                }
            }
        });
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        for (SmartPsiElementPointer pointer : tagToClose) {
            Document document;
            ASTNode child;
            XmlTag tag = (XmlTag)pointer.getElement();
            if (tag == null || (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) == null) continue;
            int offset = child.getTextRange().getStartOffset();
            VirtualFile file2 = tag.getContainingFile().getVirtualFile();
            if (file2 == null || (document = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ApplicationManager.getApplication().runWriteAction(() -> {
                document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
                documentManager.commitDocument(document);
            });
        }
    }

    private static boolean isTagClosed(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlZenCodingGeneratorImpl.$$$reportNull$$$0(10);
        }
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(node);
        ASTNode endTagEnd = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(node);
        return emptyTagEnd != null || endTagEnd != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAttributesString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildAttributesString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMyContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAppliedByDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "closeUnclosingTags";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTagClosed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toString$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

