/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeMethodReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AnonymousCanBeMethodReferenceInspection.class);
    public boolean reportNotAnnotatedInterfaces = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            AnonymousCanBeMethodReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with method reference" == null) {
            AnonymousCanBeMethodReferenceInspection.$$$reportNull$$$0(1);
        }
        return "Anonymous type can be replaced with method reference";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Anonymous2MethodRef" == null) {
            AnonymousCanBeMethodReferenceInspection.$$$reportNull$$$0(2);
        }
        return "Anonymous2MethodRef";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when interface is not annotated with @FunctionalInterface", (InspectionProfileEntry)this, "reportNotAnnotatedInterfaces");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnonymousCanBeMethodReferenceInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, true, AnonymousCanBeMethodReferenceInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiJavaCodeReferenceElement classReference2;
                    PsiElement parent;
                    PsiCallExpression callExpression;
                    PsiMethod resolveMethod;
                    PsiMethod method = aClass.getMethods()[0];
                    PsiCodeBlock body2 = method.getBody();
                    LambdaCanBeMethodReferenceInspection.MethodReferenceCandidate methodReferenceCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression((PsiElement)body2);
                    if (methodReferenceCandidate == null) {
                        return;
                    }
                    PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])method.getParameterList().getParameters(), (PsiType)aClass.getBaseClassType(), aClass.getParent(), methodReferenceCandidate.myExpression);
                    if (candidate instanceof PsiCallExpression && (resolveMethod = (callExpression = (PsiCallExpression)candidate).resolveMethod()) != method && !AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(resolveMethod, aClass, callExpression) && (parent = aClass.getParent()) instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)parent).getClassOrAnonymousClassReference()) != null) {
                        PsiElement lBrace = aClass.getLBrace();
                        LOG.assertTrue(lBrace != null);
                        TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                        ProblemHighlightType type2 = methodReferenceCandidate.mySafeQualifier && methodReferenceCandidate.myConformsCodeStyle ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.INFORMATION;
                        ProblemDescriptorBase descriptor2 = new ProblemDescriptorBase(parent, parent, "Anonymous #ref #loc can be replaced with method reference", new LocalQuickFix[]{new ReplaceWithMethodRefFix()}, type2, false, rangeInElement, type2 != ProblemHighlightType.INFORMATION, true);
                        holder.registerProblem((ProblemDescriptor)descriptor2);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            AnonymousCanBeMethodReferenceInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    static void replaceWithMethodReference(@NotNull Project project2, String methodRefText, PsiType castType, PsiElement replacementTarget) {
        if (project2 == null) {
            AnonymousCanBeMethodReferenceInspection.$$$reportNull$$$0(5);
        }
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)replacementTarget, PsiComment.class), comment -> (PsiComment)comment.copy());
        if (methodRefText != null) {
            PsiElement anchor;
            String canonicalText = castType.getCanonicalText();
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("(" + canonicalText + ")" + methodRefText, replacementTarget);
            PsiElement castExpr = replacementTarget.replace((PsiElement)psiExpression);
            if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)castExpr))) {
                PsiExpression operand2 = ((PsiTypeCastExpression)castExpr).getOperand();
                LOG.assertTrue(operand2 != null);
                castExpr = castExpr.replace((PsiElement)operand2);
            }
            if ((anchor = PsiTreeUtil.getParentOfType((PsiElement)castExpr, PsiStatement.class)) == null) {
                anchor = castExpr;
            }
            for (PsiComment comment2 : comments) {
                anchor.getParent().addBefore((PsiElement)comment2, anchor);
            }
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(castExpr);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithMethodReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with method reference" == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(0);
            }
            return "Replace with method reference";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project2 == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) instanceof PsiNewExpression) {
                PsiAnonymousClass anonymousClass = ((PsiNewExpression)element).getAnonymousClass();
                if (anonymousClass == null) {
                    return;
                }
                PsiMethod[] methods = anonymousClass.getMethods();
                if (methods.length != 1) {
                    return;
                }
                PsiParameter[] parameters2 = methods[0].getParameterList().getParameters();
                PsiClassType functionalInterfaceType = anonymousClass.getBaseClassType();
                LambdaCanBeMethodReferenceInspection.MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression((PsiElement)methods[0].getBody());
                if (methodRefCandidate == null) {
                    return;
                }
                PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])parameters2, (PsiType)functionalInterfaceType, anonymousClass.getParent(), methodRefCandidate.myExpression);
                String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)candidate, (PsiType)functionalInterfaceType, (PsiVariable[])parameters2);
                AnonymousCanBeMethodReferenceInspection.replaceWithMethodReference(project2, methodRefText, (PsiType)anonymousClass.getBaseClassType(), anonymousClass.getParent());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

