/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorCombinatorsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ComparatorCombinatorsInspection.class);
    private static final EquivalenceChecker ourEquivalence = EquivalenceChecker.getCanonicalPsiEquivalence();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiType type2 = lambda2.getFunctionalInterfaceType();
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 2 || !(type2 instanceof PsiClassType) || !((PsiClassType)type2).rawType().equalsToText("java.util.Comparator")) {
                    return;
                }
                PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
                String methodName = null;
                if (body2 instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body2;
                    PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                    if (args.length == 1 && MethodCallUtils.isCompareToCall(methodCall)) {
                        PsiExpression left = methodCall.getMethodExpression().getQualifierExpression();
                        if (left == null) {
                            return;
                        }
                        PsiExpression right = args[0];
                        if (left instanceof PsiReferenceExpression && right instanceof PsiReferenceExpression) {
                            PsiElement leftElement = ((PsiReferenceExpression)left).resolve();
                            PsiElement rightElement = ((PsiReferenceExpression)right).resolve();
                            if (leftElement == parameters2[0] && rightElement == parameters2[1]) {
                                methodName = "naturalOrder";
                            } else if (leftElement == parameters2[1] && rightElement == parameters2[0]) {
                                methodName = "reverseOrder";
                            }
                        }
                        if (methodName == null && ComparatorCombinatorsInspection.areEquivalent(parameters2, left, right)) {
                            methodName = "comparing";
                        }
                    } else {
                        PsiClass compareClass;
                        PsiMethod method = methodCall.resolveMethod();
                        if (args.length == 2 && method != null && method.getName().equals("compare") && (compareClass = method.getContainingClass()) != null) {
                            methodName = ComparatorCombinatorsInspection.getComparingMethodName(compareClass.getQualifiedName());
                            if (!ComparatorCombinatorsInspection.areEquivalent(parameters2, args[0], args[1])) {
                                return;
                            }
                        }
                    }
                } else if (body2 instanceof PsiBinaryExpression) {
                    PsiBinaryExpression binOp = (PsiBinaryExpression)body2;
                    if (binOp.getOperationTokenType().equals(JavaTokenType.MINUS) && ComparatorCombinatorsInspection.areEquivalent(parameters2, binOp.getLOperand(), binOp.getROperand())) {
                        PsiType opType = binOp.getLOperand().getType();
                        if (opType == null) {
                            return;
                        }
                        methodName = ComparatorCombinatorsInspection.getComparingMethodName(opType.getCanonicalText());
                    }
                } else if (lambda2.getBody() instanceof PsiCodeBlock) {
                    PsiStatement[] statements = ((PsiCodeBlock)lambda2.getBody()).getStatements();
                    if (ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]) == null) {
                        return;
                    }
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator chain", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix("Comparator chain")});
                }
                if (methodName != null) {
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator." + methodName, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix("Comparator." + methodName)});
                }
            }
        };
        if (javaElementVisitor == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable(value="when failed to extract")
    private static List<ComparisonBlock> extractComparisonChain(@NotNull PsiStatement[] statements, @NotNull PsiVariable first, @NotNull PsiVariable second) {
        if (statements == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(2);
        }
        if (first == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(3);
        }
        if (second == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(4);
        }
        if (statements.length == 0) {
            return null;
        }
        ComparisonBlock firstBlock = ComparisonBlock.extractBlock(statements[0], first, second, null);
        if (firstBlock == null) {
            return null;
        }
        ArrayList<ComparisonBlock> blocks = new ArrayList<ComparisonBlock>();
        blocks.add(firstBlock);
        PsiVariable lastResult = firstBlock.getResult();
        int index = 1;
        while (index < statements.length - 1) {
            ComparisonBlock block;
            PsiStatement current = statements[index];
            if (ComparatorCombinatorsInspection.isNotZeroCheck(current, lastResult)) {
                if (index + 1 >= statements.length) {
                    return null;
                }
                PsiStatement next = statements[index + 1];
                block = ComparisonBlock.extractBlock(next, first, second, lastResult);
                if (block == null) {
                    return null;
                }
                blocks.add(block);
                index += 2;
                continue;
            }
            PsiStatement nextComparisonStmt = ComparatorCombinatorsInspection.extractZeroCheckedWay(current, lastResult);
            if (nextComparisonStmt != null) {
                block = ComparisonBlock.extractBlock(nextComparisonStmt, first, second, lastResult);
                if (block == null) {
                    return null;
                }
                blocks.add(block);
                if (block.getResult() != lastResult) {
                    lastResult = block.getResult();
                }
                ++index;
                continue;
            }
            return null;
        }
        PsiStatement lastStmt = statements[statements.length - 1];
        if (lastStmt instanceof PsiReturnStatement) {
            PsiExpression returnExpr = ((PsiReturnStatement)lastStmt).getReturnValue();
            if (returnExpr == null) {
                return null;
            }
            if (ExpressionUtils.isReferenceTo(returnExpr, lastResult)) {
                return blocks;
            }
            ComparisonBlock lastBlock = ComparatorCombinatorsInspection.extractTernaryComparison(first, second, lastResult, returnExpr);
            if (lastBlock == null) {
                return null;
            }
            blocks.add(lastBlock);
            return blocks;
        }
        return null;
    }

    @Nullable
    private static ComparisonBlock extractTernaryComparison(@NotNull PsiVariable first, @NotNull PsiVariable second, PsiVariable lastResult, PsiExpression returnExpr) {
        PsiConditionalExpression ternary;
        if (first == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(5);
        }
        if (second == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(6);
        }
        if ((ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)returnExpr, PsiConditionalExpression.class)) == null) {
            return null;
        }
        PsiExpression elseExpression2 = ternary.getElseExpression();
        PsiExpression thenExpression2 = ternary.getThenExpression();
        if (elseExpression2 == null || thenExpression2 == null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ternary.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression finalResult = ExpressionUtils.getValueComparedWithZero(binOp);
        boolean inverted = false;
        if (finalResult == null) {
            finalResult = ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.NE);
            inverted = true;
        }
        if (!ExpressionUtils.isReferenceTo(finalResult, lastResult)) {
            return null;
        }
        if (!ExpressionUtils.isReferenceTo(inverted ? thenExpression2 : elseExpression2, lastResult)) {
            return null;
        }
        PsiMethodCallExpression lastComparison = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)(inverted ? elseExpression2 : thenExpression2), PsiMethodCallExpression.class);
        ComparisonBlock lastBlock = ComparisonBlock.extractBlock((PsiExpression)lastComparison, first, second, lastResult);
        if (lastBlock == null) {
            return null;
        }
        return lastBlock;
    }

    @Nullable
    private static PsiStatement extractZeroCheckedWay(@Nullable PsiStatement statement2, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement;
        if (last == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(7);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement2, PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression maybeResult = ExpressionUtils.getValueComparedWithZero(binOp);
        if (!ExpressionUtils.isReferenceTo(maybeResult, last)) {
            return null;
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    private static boolean isNotZeroCheck(@NotNull PsiStatement statement2, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement;
        if (statement2 == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(8);
        }
        if (last == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(9);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement2, PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return false;
        }
        if (!ExpressionUtils.isReferenceTo(ExpressionUtils.getValueComparedWithZero(binaryExpression, JavaTokenType.NE), last)) {
            return false;
        }
        PsiStatement thenStmt = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenStmt instanceof PsiReturnStatement)) {
            return false;
        }
        return ExpressionUtils.isReferenceTo(((PsiReturnStatement)thenStmt).getReturnValue(), last);
    }

    @NotNull
    private static String generateComparison(@NotNull String methodName, @Nullable PsiType type2, @NotNull String varName, @NotNull PsiExpression expression2, @NotNull PsiVariable exprVariable) {
        if (methodName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(10);
        }
        if (varName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(11);
        }
        if (expression2 == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(12);
        }
        if (exprVariable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(13);
        }
        String lambdaExpr = ComparatorCombinatorsInspection.getExpressionReplacingReferences(expression2, varName, exprVariable);
        String parameter2 = type2 == null ? varName : "(" + type2.getCanonicalText() + " " + varName + ")";
        String string = methodName + "(" + parameter2 + "->" + lambdaExpr + ")";
        if (string == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static String generateCode(@NotNull List<ComparisonBlock> blocks, @NotNull PsiVariable firstVar, @NotNull PsiVariable secondVar) {
        if (blocks == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(15);
        }
        if (firstVar == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(16);
        }
        if (secondVar == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(17);
        }
        if (blocks.size() < 2) {
            return null;
        }
        ComparisonBlock first = blocks.get(0);
        StringBuilder builder = new StringBuilder();
        PsiType type2 = secondVar.getType();
        String name2 = ComparatorCombinatorsInspection.suggestVarName(firstVar);
        if (name2 == null) {
            return null;
        }
        PsiExpression firstKey = first.getKey();
        String firstMethodName = ComparatorCombinatorsInspection.getComparingMethodName(firstKey.getType(), true);
        if (firstMethodName == null) {
            return null;
        }
        builder.append("java.util.Comparator").append(".").append(ComparatorCombinatorsInspection.generateComparison(firstMethodName, type2, name2, firstKey, secondVar));
        for (int i = 1; i < blocks.size(); ++i) {
            ComparisonBlock block = blocks.get(i);
            PsiExpression blockKey = block.getKey();
            String comparatorMethodName = ComparatorCombinatorsInspection.getComparingMethodName(blockKey.getType(), false);
            if (comparatorMethodName == null) {
                return null;
            }
            builder.append(".").append(ComparatorCombinatorsInspection.generateComparison(comparatorMethodName, null, name2, blockKey, secondVar));
        }
        return builder.toString();
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static String getComparingMethodName(@Nullable PsiType exprType, boolean first) {
        if (exprType == null) {
            return null;
        }
        String name2 = ComparatorCombinatorsInspection.getComparingMethodName(exprType.getCanonicalText(), first);
        if (name2 != null) {
            return name2;
        }
        if (InheritanceUtil.isInheritor((PsiType)exprType, (String)"java.lang.Comparable")) {
            return first ? "comparing" : "thenComparing";
        }
        return null;
    }

    @Nullable
    private static String suggestVarName(@NotNull PsiVariable variable) {
        String[] names;
        if (variable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(18);
        }
        String name2 = variable.getName();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
        SuggestedNameInfo nameCandidate = null;
        if (name2 != null) {
            if (name2.length() > 1 && name2.endsWith("1")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, name2.substring(0, name2.length() - 1), null, variable.getType(), true);
            } else if (name2.equals("first")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, variable.getType(), true);
            }
        }
        if (nameCandidate != null && (names = codeStyleManager.suggestUniqueVariableName(nameCandidate, (PsiElement)variable, (boolean)true).names).length > 0) {
            return names[0];
        }
        return name2;
    }

    private static String getExpressionReplacingReferences(@NotNull PsiExpression expression2, @NotNull String varName, @NotNull PsiVariable exprVariable) {
        if (expression2 == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(19);
        }
        if (varName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(20);
        }
        if (exprVariable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(21);
        }
        PsiExpression copy = (PsiExpression)expression2.copy();
        ReferencesSearch.search((PsiElement)exprVariable, (SearchScope)new LocalSearchScope((PsiElement)copy)).forEach(reference -> {
            PsiReferenceExpression ref;
            if (varName == null) {
                ComparatorCombinatorsInspection.$$$reportNull$$$0(26);
            }
            if ((ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), PsiReferenceExpression.class)) == null) {
                return;
            }
            ExpressionUtils.bindReferenceTo(ref, varName);
        });
        return copy.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2) {
        return ComparatorCombinatorsInspection.getComparingMethodName(type2, true);
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2, boolean first) {
        if (type2 == null) {
            return null;
        }
        switch (PsiTypesUtil.unboxIfPossible((String)type2)) {
            case "int": 
            case "short": 
            case "byte": 
            case "char": {
                return first ? "comparingInt" : "thenComparingInt";
            }
            case "long": {
                return first ? "comparingLong" : "thenComparingLong";
            }
            case "double": {
                return first ? "comparingDouble" : "thenComparingDouble";
            }
        }
        return null;
    }

    @Contract(value="_, null, _ -> false; _, !null, null -> false")
    private static boolean areEquivalent(@NotNull PsiParameter[] parameters2, @Nullable PsiExpression left, @Nullable PsiExpression right) {
        if (parameters2 == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(22);
        }
        if (left == null || right == null) {
            return false;
        }
        if (!PsiTreeUtil.processElements((PsiElement)left, e -> {
            if (parameters2 == null) {
                ComparatorCombinatorsInspection.$$$reportNull$$$0(25);
            }
            return !(e instanceof PsiReferenceExpression) || ((PsiReferenceExpression)e).resolve() != parameters2[1];
        }) || !PsiTreeUtil.processElements((PsiElement)right, e -> {
            if (parameters2 == null) {
                ComparatorCombinatorsInspection.$$$reportNull$$$0(24);
            }
            return !(e instanceof PsiReferenceExpression) || ((PsiReferenceExpression)e).resolve() != parameters2[0];
        })) {
            return false;
        }
        PsiExpression copy = (PsiExpression)right.copy();
        PsiElement[] rightRefs = PsiTreeUtil.collectElements((PsiElement)copy, e -> {
            if (parameters2 == null) {
                ComparatorCombinatorsInspection.$$$reportNull$$$0(23);
            }
            return e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == parameters2[1];
        });
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)left.getProject());
        String paramName = parameters2[0].getName();
        if (paramName == null) {
            return false;
        }
        for (PsiElement ref : rightRefs) {
            PsiElement nameElement = ((PsiReferenceExpression)ref).getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            nameElement.replace((PsiElement)factory.createIdentifier(paramName));
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, copy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprVariable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstVar";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondVar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateComparison";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 14: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractComparisonChain";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractTernaryComparison";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractZeroCheckedWay";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNotZeroCheck";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateComparison";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateCode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "suggestVarName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionReplacingReferences";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$areEquivalent$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$areEquivalent$2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$areEquivalent$1";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExpressionReplacingReferences$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReplaceWithComparatorFix
    implements LocalQuickFix {
        private final String myMessage;

        public ReplaceWithComparatorFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with " + this.myMessage;
            if (string == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify comparator using Comparator static methods" == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(1);
            }
            return "Simplify comparator using Comparator static methods";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement result2;
            PsiStatement[] statements;
            PsiElement element;
            if (project2 == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getStartElement()) instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 2) {
                return;
            }
            if (lambda2.getBody() instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambda2.getBody()).getStatements()).length > 1) {
                List chain = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                if (chain == null) {
                    return;
                }
                String code2 = ComparatorCombinatorsInspection.generateCode(chain, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                if (code2 == null) {
                    return;
                }
                PsiElement result3 = new CommentTracker().replaceAndRestoreComments((PsiElement)lambda2, code2);
                PsiDiamondTypeUtil.removeRedundantTypeArguments(result3);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result3);
                CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result3));
                return;
            }
            PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            PsiExpression keyExtractor = null;
            String methodName = null;
            if (body2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body2;
                if (MethodCallUtils.isCompareToCall(methodCall)) {
                    methodName = "comparing";
                    keyExtractor = methodCall.getMethodExpression().getQualifierExpression();
                    if (keyExtractor instanceof PsiReferenceExpression) {
                        PsiElement keyElement = ((PsiReferenceExpression)keyExtractor).resolve();
                        if (keyElement == parameters2[0]) {
                            methodName = "naturalOrder";
                        } else if (keyElement == parameters2[1]) {
                            methodName = "reverseOrder";
                        }
                    }
                } else {
                    PrimitiveComparison comparison = PrimitiveComparison.from(methodCall);
                    if (comparison == null) {
                        return;
                    }
                    methodName = comparison.getMethodName();
                    keyExtractor = comparison.getKeyExtractor();
                }
            } else if (body2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)body2;
                if (!binOp.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    return;
                }
                keyExtractor = binOp.getLOperand();
                PsiType type2 = keyExtractor.getType();
                if (type2 == null) {
                    return;
                }
                methodName = ComparatorCombinatorsInspection.getComparingMethodName(type2.getCanonicalText());
            }
            if (methodName == null || keyExtractor == null) {
                return;
            }
            String parameterName = parameters2[0].getName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            if (!methodName.startsWith("comparing")) {
                result2 = lambda2.replace((PsiElement)factory.createExpressionFromText("java.util.Comparator." + methodName + "()", element));
            } else {
                String newLambda = parameterName + " -> " + keyExtractor.getText();
                PsiExpression replacement = factory.createExpressionFromText("java.util.Comparator." + methodName + "(" + newLambda + ")", element);
                result2 = lambda2.replace((PsiElement)replacement);
                ReplaceWithComparatorFix.normalizeLambda(((PsiMethodCallExpression)result2).getArgumentList().getExpressions()[0], factory);
            }
            CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2));
        }

        private static void normalizeLambda(PsiExpression expression2, PsiElementFactory factory) {
            PsiParameter parameter2;
            String name2;
            if (!(expression2 instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            if (LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2) == lambda2 && (name2 = ComparatorCombinatorsInspection.suggestVarName((PsiVariable)(parameter2 = parameters2[0]))) != null) {
                Collection references = PsiTreeUtil.collectElementsOfType((PsiElement)body2, (Class[])new Class[]{PsiReferenceExpression.class});
                ((StreamEx)StreamEx.of((Collection)references).filter(ref -> ref.isReferenceTo((PsiElement)parameter2))).map(PsiJavaCodeReferenceElement::getReferenceNameElement).nonNull().forEach(nameElement -> nameElement.replace((PsiElement)factory.createIdentifier(name2)));
                parameter2.setName(name2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PrimitiveComparison {
        @NotNull
        private final PsiExpression myKeyExtractor;
        @NotNull
        private final String myMethodName;

        private PrimitiveComparison(@NotNull PsiExpression extractor, @NotNull String name2) {
            if (extractor == null) {
                PrimitiveComparison.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                PrimitiveComparison.$$$reportNull$$$0(1);
            }
            this.myKeyExtractor = extractor;
            this.myMethodName = name2;
        }

        @NotNull
        public PsiExpression getKeyExtractor() {
            PsiExpression psiExpression = this.myKeyExtractor;
            if (psiExpression == null) {
                PrimitiveComparison.$$$reportNull$$$0(2);
            }
            return psiExpression;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                PrimitiveComparison.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private static PrimitiveComparison from(PsiMethodCallExpression methodCall) {
            String className;
            PsiClass containingClass;
            PsiMethod method = methodCall.resolveMethod();
            if (method != null && method.getName().equals("compare") && (containingClass = method.getContainingClass()) != null && (className = containingClass.getQualifiedName()) != null) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return null;
                }
                PsiExpression keyExtractor = args[0];
                String methodName = ComparatorCombinatorsInspection.getComparingMethodName(className);
                if (methodName == null) {
                    return null;
                }
                return new PrimitiveComparison(keyExtractor, methodName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$PrimitiveComparison";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$PrimitiveComparison";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyExtractor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ComparisonBlock {
        private final PsiExpression myKey;
        private final PsiVariable myResult;

        private ComparisonBlock(PsiExpression key2, PsiVariable result2) {
            this.myKey = key2;
            this.myResult = result2;
        }

        public PsiExpression getKey() {
            return this.myKey;
        }

        public PsiVariable getResult() {
            return this.myResult;
        }

        @Nullable
        static ComparisonBlock extractBlock(@NotNull PsiStatement statement2, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiVariable previousResult) {
            if (statement2 == null) {
                ComparisonBlock.$$$reportNull$$$0(0);
            }
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(1);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(2);
            }
            if (statement2 instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement2;
                PsiElement[] elements = declaration2.getDeclaredElements();
                if (elements.length == 0) {
                    return null;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
                if (variable == null) {
                    return null;
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                return ComparisonBlock.extractBlock(initializer, firstParam, secondParam, (PsiVariable)variable);
            }
            if (previousResult != null && statement2 instanceof PsiExpressionStatement) {
                PsiExpression expr = ExpressionUtils.getAssignmentTo((PsiElement)((PsiExpressionStatement)statement2).getExpression(), previousResult);
                return ComparisonBlock.extractBlock(expr, firstParam, secondParam, previousResult);
            }
            return null;
        }

        @Contract(value="null, _, _, _ -> null")
        @Nullable
        private static ComparisonBlock extractBlock(@Nullable PsiExpression expr, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @NotNull PsiVariable variable) {
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(3);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(4);
            }
            if (variable == null) {
                ComparisonBlock.$$$reportNull$$$0(5);
            }
            PsiExpression first = null;
            PsiExpression second = null;
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                PsiExpression[] parameters2 = call.getArgumentList().getExpressions();
                if (PrimitiveComparison.from(call) != null) {
                    first = parameters2[0];
                    second = parameters2[1];
                } else if (MethodCallUtils.isCompareToCall(call)) {
                    first = call.getMethodExpression().getQualifierExpression();
                    second = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                }
            } else if (expr instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)expr;
                if (binOp.getOperationTokenType() != JavaTokenType.MINUS) {
                    return null;
                }
                first = binOp.getLOperand();
                if (ComparatorCombinatorsInspection.getComparingMethodName(first.getType(), true) == null) {
                    return null;
                }
                second = binOp.getROperand();
            }
            if (first == null || second == null) {
                return null;
            }
            if (!ComparisonBlock.usagesAreAllowed(firstParam, secondParam, first, second)) {
                return null;
            }
            if (!ComparisonBlock.keyAccessEquivalent(firstParam, secondParam, first, second)) {
                return null;
            }
            return new ComparisonBlock(second, variable);
        }

        private static boolean keyAccessEquivalent(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, PsiExpression first, PsiExpression second) {
            String secondParamName;
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(6);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(7);
            }
            if ((secondParamName = secondParam.getName()) == null) {
                return false;
            }
            PsiExpression firstCopy = ComparisonBlock.replaceVariableInExpression(firstParam, first, secondParamName);
            return ourEquivalence.expressionsAreEquivalent(firstCopy, second);
        }

        @NotNull
        private static PsiExpression replaceVariableInExpression(@NotNull PsiVariable variable, PsiExpression expression2, String newName) {
            if (variable == null) {
                ComparisonBlock.$$$reportNull$$$0(8);
            }
            PsiExpression qualifierCopy = (PsiExpression)expression2.copy();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)qualifierCopy))) {
                if (!(ref instanceof PsiReferenceExpression)) continue;
                ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref, newName);
            }
            PsiExpression psiExpression = qualifierCopy;
            if (psiExpression == null) {
                ComparisonBlock.$$$reportNull$$$0(9);
            }
            return psiExpression;
        }

        private static boolean usagesAreAllowed(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiExpression firstExpr, @Nullable PsiExpression secondExpr) {
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(10);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(11);
            }
            return VariableAccessUtils.variableIsUsed(firstParam, (PsiElement)firstExpr) && VariableAccessUtils.variableIsUsed(secondParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed(firstParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed(secondParam, (PsiElement)firstExpr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstParam";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondParam";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ComparisonBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ComparisonBlock";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceVariableInExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extractBlock";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "keyAccessEquivalent";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceVariableInExpression";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "usagesAreAllowed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

