/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaCodeBlockInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(RedundantLambdaCodeBlockInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Statement lambda can be replaced with expression lambda" == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(1);
        }
        return "Statement lambda can be replaced with expression lambda";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("CodeBlock2Expr" == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(2);
        }
        return "CodeBlock2Expr";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2;
                PsiExpression psiExpression;
                super.visitLambdaExpression(expression2);
                if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)expression2) && (psiExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body2 = expression2.getBody())) != null) {
                    PsiElement parent = psiExpression.getParent();
                    PsiElement errorElement = parent instanceof PsiReturnStatement ? parent.getFirstChild() : body2.getFirstChild();
                    holder.registerProblem(errorElement, "Statement lambda can be replaced with expression lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithExprFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            RedundantLambdaCodeBlockInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    public static PsiExpression isCodeBlockRedundant(PsiElement body2) {
        PsiExpression psiExpression;
        if (body2 instanceof PsiCodeBlock && (psiExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2)) != null && !RedundantLambdaCodeBlockInspection.findCommentsOutsideExpression(body2, psiExpression)) {
            PsiMethod oldTarget;
            PsiCall call;
            if (LambdaUtil.isExpressionStatementExpression((PsiElement)psiExpression) && (call = LambdaUtil.treeWalkUp((PsiElement)body2)) != null && (oldTarget = call.resolveMethod()) != null) {
                PsiElement parent;
                int offsetInTopCall = body2.getTextRange().getStartOffset() - call.getTextRange().getStartOffset();
                PsiCall copyCall = LambdaUtil.copyTopLevelCall((PsiCall)call);
                if (copyCall == null) {
                    return null;
                }
                PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)copyCall.findElementAt(offsetInTopCall), PsiCodeBlock.class);
                if (codeBlock != null && (parent = codeBlock.getParent()) instanceof PsiLambdaExpression) {
                    codeBlock.replace((PsiElement)psiExpression);
                    if (copyCall.resolveMethod() != oldTarget || ((PsiLambdaExpression)parent).getFunctionalInterfaceType() == null) {
                        return null;
                    }
                }
            }
            return psiExpression;
        }
        return null;
    }

    private static boolean findCommentsOutsideExpression(PsiElement body2, PsiExpression psiExpression) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)body2, PsiComment.class);
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)comment, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithExprFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with expression lambda" == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(0);
            }
            return "Replace with expression lambda";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiExpression expression2;
            PsiElement body2;
            PsiLambdaExpression lambdaExpression;
            PsiElement element;
            if (project2 == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithExprFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor2.getPsiElement()) != null && (lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) != null && (body2 = lambdaExpression.getBody()) != null && (expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2)) != null) {
                body2.replace((PsiElement)expression2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

