/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnimplementInterfaceAction
implements IntentionAction {
    private String myName = "Interface";

    @NotNull
    public String getText() {
        String string = "Unimplement " + this.myName;
        if (string == null) {
            UnimplementInterfaceAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Unimplement Interface/Class" == null) {
            UnimplementInterfaceAction.$$$reportNull$$$0(1);
        }
        return "Unimplement Interface/Class";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            UnimplementInterfaceAction.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiReference psiReference = TargetElementUtil.findReference(editor);
        if (psiReference == null) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = UnimplementInterfaceAction.getTopLevelRef(psiReference, referenceList);
        if (referenceElement == null) {
            return false;
        }
        PsiElement target2 = referenceElement.resolve();
        if (target2 == null || !(target2 instanceof PsiClass)) {
            return false;
        }
        PsiClass targetClass = (PsiClass)target2;
        this.myName = targetClass.isInterface() ? "Interface" : "Class";
        return true;
    }

    @Nullable
    private static PsiJavaCodeReferenceElement getTopLevelRef(PsiReference psiReference, PsiReferenceList referenceList) {
        PsiElement element = psiReference.getElement();
        while (element.getParent() != referenceList) {
            if ((element = element.getParent()) != null) continue;
            return null;
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)element;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiMethod[] psiMethods;
        PsiReference psiReference;
        if (project2 == null) {
            UnimplementInterfaceAction.$$$reportNull$$$0(3);
        }
        if ((psiReference = TargetElementUtil.findReference(editor)) == null) {
            return;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return;
        }
        PsiJavaCodeReferenceElement element = UnimplementInterfaceAction.getTopLevelRef(psiReference, referenceList);
        if (element == null) {
            return;
        }
        PsiElement target2 = element.resolve();
        if (target2 == null || !(target2 instanceof PsiClass)) {
            return;
        }
        PsiClass targetClass = (PsiClass)target2;
        HashMap implementations = new HashMap();
        for (PsiMethod psiMethod : targetClass.getAllMethods()) {
            PsiMethod implementingMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)psiClass, (PsiMethod)psiMethod, (boolean)false);
            if (implementingMethod == null) continue;
            implementations.put(psiMethod, implementingMethod);
        }
        element.delete();
        if (target2 == psiClass) {
            return;
        }
        HashSet superMethods = new HashSet();
        for (PsiClass aClass : psiClass.getSupers()) {
            Collections.addAll(superMethods, aClass.getAllMethods());
        }
        for (PsiMethod psiMethod : psiMethods = targetClass.getAllMethods()) {
            PsiMethod impl;
            if (superMethods.contains(psiMethod) || (impl = (PsiMethod)implementations.get(psiMethod)) == null) continue;
            impl.delete();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/UnimplementInterfaceAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/UnimplementInterfaceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

