/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.EntryPointsNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationPresentation
extends DefaultInspectionToolPresentation {
    private final Map<RefEntity, UnusedDeclarationHint> myFixedElements;
    private final Set<RefEntity> myExcludedElements;
    private WeakUnreferencedFilter myFilter;
    private DeadHTMLComposer myComposer;
    @NonNls
    private static final String DELETE = "delete";
    @NonNls
    private static final String COMMENT = "comment";
    final QuickFixAction[] myQuickFixActions;
    private static final String DELETE_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
    private static final String COMMENT_OUT_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);

    public UnusedDeclarationPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(0);
        }
        if (context == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(1);
        }
        super(toolWrapper, context);
        this.myFixedElements = ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy());
        this.myExcludedElements = ConcurrentCollectionFactory.createConcurrentSet(ContainerUtil.identityStrategy());
        this.myQuickFixActions = this.createQuickFixes(toolWrapper);
        ((EntryPointsManagerBase)this.getEntryPointsManager()).setAddNonJavaEntries(this.getTool().ADD_NONJAVA_TO_ENTRIES);
    }

    public RefFilter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = new WeakUnreferencedFilter(this.getTool(), this.getContext());
        }
        return this.myFilter;
    }

    @NotNull
    private UnusedDeclarationInspectionBase getTool() {
        UnusedDeclarationInspectionBase unusedDeclarationInspectionBase = (UnusedDeclarationInspectionBase)this.getToolWrapper().getTool();
        if (unusedDeclarationInspectionBase == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(2);
        }
        return unusedDeclarationInspectionBase;
    }

    @Override
    @NotNull
    public DeadHTMLComposer getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DeadHTMLComposer(this);
        }
        DeadHTMLComposer deadHTMLComposer = this.myComposer;
        if (deadHTMLComposer == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(3);
        }
        return deadHTMLComposer;
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(4);
        }
        return this.myExcludedElements.contains(entity);
    }

    @Override
    public void amnesty(@NotNull RefEntity element) {
        if (element == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(5);
        }
        this.myExcludedElements.remove(element);
    }

    @Override
    public void exclude(@NotNull RefEntity element) {
        if (element == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(6);
        }
        this.myExcludedElements.add(element);
    }

    @Override
    public void exportResults(@NotNull org.jdom.Element parentNode, @NotNull RefEntity refEntity, @NotNull Predicate<CommonProblemDescriptor> excludedDescriptions) {
        if (parentNode == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(7);
        }
        if (refEntity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(8);
        }
        if (excludedDescriptions == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(9);
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return;
        }
        RefFilter filter2 = this.getFilter();
        if (!this.myFixedElements.containsKey(refEntity) && filter2.accepts((RefJavaElement)refEntity)) {
            refEntity = this.getRefManager().getRefinedElement(refEntity);
            if (!refEntity.isValid()) {
                return;
            }
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (!UnusedDeclarationPresentation.compareVisibilities(refElement, this.getTool().getSharedLocalInspectionTool())) {
                return;
            }
            if (this.skipEntryPoints(refElement)) {
                return;
            }
            org.jdom.Element element = refEntity.getRefManager().export(refEntity, parentNode, -1);
            if (element == null) {
                return;
            }
            org.jdom.Element problemClassElement = new org.jdom.Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            HighlightSeverity severity = this.getSeverity((RefElement)refElement);
            String attributeKey = UnusedDeclarationPresentation.getTextAttributeKey(refElement.getRefManager().getProject(), severity, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            problemClassElement.setAttribute("severity", severity.myName);
            problemClassElement.setAttribute("attribute_key", attributeKey);
            problemClassElement.addContent(InspectionsBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
            element.addContent(problemClassElement);
            org.jdom.Element hintsElement = new org.jdom.Element("hints");
            for (UnusedDeclarationHint hint : UnusedDeclarationHint.values()) {
                org.jdom.Element hintElement = new org.jdom.Element("hint");
                hintElement.setAttribute("value", hint.toString().toLowerCase());
                hintsElement.addContent(hintElement);
            }
            element.addContent(hintsElement);
            org.jdom.Element descriptionElement = new org.jdom.Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
            StringBuffer buf = new StringBuffer();
            DeadHTMLComposer.appendProblemSynopsis((RefElement)refEntity, buf);
            descriptionElement.addContent(buf.toString());
            element.addContent(descriptionElement);
        }
        super.exportResults(parentNode, refEntity, excludedDescriptions);
    }

    @Override
    @NotNull
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements, @Nullable InspectionTree tree) {
        if (refElements == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(10);
        }
        boolean showFixes = false;
        for (RefEntity element : refElements) {
            if (this.myFixedElements.containsKey(element) || !element.isValid()) continue;
            showFixes = true;
            break;
        }
        if (showFixes) {
            long count;
            TreePath[] paths;
            TreePath[] treePathArray = paths = tree != null ? tree.getSelectionPaths() : null;
            if (paths != null && (count = Arrays.stream(paths).map(TreePath::getLastPathComponent).filter(component -> component instanceof ProblemDescriptionNode).count()) > 0L) {
                QuickFixAction[] fixes = super.getQuickFixes(refElements, tree);
                QuickFixAction[] quickFixActionArray = count == (long)paths.length ? fixes : (QuickFixAction[])ArrayUtil.mergeArrays((Object[])fixes, (Object[])this.myQuickFixActions);
                if (quickFixActionArray == null) {
                    UnusedDeclarationPresentation.$$$reportNull$$$0(11);
                }
                return quickFixActionArray;
            }
            if (this.myQuickFixActions == null) {
                UnusedDeclarationPresentation.$$$reportNull$$$0(12);
            }
            return this.myQuickFixActions;
        }
        if (QuickFixAction.EMPTY == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(13);
        }
        return QuickFixAction.EMPTY;
    }

    @NotNull
    private QuickFixAction[] createQuickFixes(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(14);
        }
        QuickFixAction[] quickFixActionArray = new QuickFixAction[]{new PermanentDeleteAction(toolWrapper), new CommentOutBin(toolWrapper), new MoveToEntries(toolWrapper)};
        if (quickFixActionArray == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(15);
        }
        return quickFixActionArray;
    }

    private EntryPointsManager getEntryPointsManager() {
        return ((GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(this.getContext().getRefManager());
    }

    private static void commentOutDead(PsiElement psiElement) {
        Document doc;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
            int line2;
            TextRange textRange = psiElement.getTextRange();
            String date = DateFormatUtil.formatDateTime((Date)new Date());
            int startOffset = textRange.getStartOffset();
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = doc.getLineStartOffset(line);
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
            }
            int endOffset = textRange.getEndOffset();
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(endOffset - 1))) {
                doc.insertString(startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i = line1; i <= line2; ++i) {
                    doc.insertString(doc.getLineStartOffset(i), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
            }
        }
    }

    @Override
    public void createToolNode(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupByStructure) {
        if (context == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(16);
        }
        if (node == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(18);
        }
        if (parentNode == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(19);
        }
        EntryPointsNode entryPointsNode = new EntryPointsNode(context);
        InspectionToolWrapper dummyToolWrapper = entryPointsNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(dummyToolWrapper);
        presentation.updateContent();
        provider.appendToolNodeContent(context, entryPointsNode, node, showStructure, groupByStructure);
        this.myToolNode = entryPointsNode;
    }

    @Override
    @NotNull
    public RefElementNode createRefNode(@Nullable RefEntity entity) {
        RefElementNode refElementNode = new RefElementNode(entity, this){

            @Override
            @Nullable
            public String getTailText() {
                UnusedDeclarationHint hint = (UnusedDeclarationHint)((Object)UnusedDeclarationPresentation.this.myFixedElements.get(this.getElement()));
                if (hint != null) {
                    return hint.getDescription();
                }
                return super.getTailText();
            }

            @Override
            public boolean isQuickFixAppliedFromView() {
                return UnusedDeclarationPresentation.this.myFixedElements.containsKey(this.getElement());
            }
        };
        if (refElementNode == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(20);
        }
        return refElementNode;
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myFixedElements.containsKey(entity);
    }

    @Override
    public synchronized void updateContent() {
        this.getTool().checkForReachableRefs(this.getContext());
        this.myContents.clear();
        final UnusedSymbolLocalInspectionBase localInspectionTool = this.getTool().getSharedLocalInspectionTool();
        this.getContext().getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (!UnusedDeclarationPresentation.compareVisibilities(refElement, localInspectionTool)) {
                    return;
                }
                if ((!UnusedDeclarationPresentation.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS || !UnusedDeclarationPresentation.this.myFixedElements.containsKey(refElement) && !UnusedDeclarationPresentation.this.isExcluded(refEntity) && !UnusedDeclarationPresentation.this.isSuppressed((RefEntity)refElement)) && refElement.isValid() && UnusedDeclarationPresentation.this.getFilter().accepts(refElement)) {
                    if (UnusedDeclarationPresentation.this.skipEntryPoints(refElement)) {
                        return;
                    }
                    UnusedDeclarationPresentation.this.registerContentEntry(refEntity, RefJavaUtil.getInstance().getPackageName(refEntity));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$2", "visitElement"));
            }
        });
        this.updateProblemElements();
    }

    protected boolean skipEntryPoints(RefJavaElement refElement) {
        return this.getTool().isEntryPoint((RefElement)refElement);
    }

    @PsiModifier.ModifierConstant
    private static String getAcceptedVisibility(UnusedSymbolLocalInspectionBase tool, RefJavaElement element) {
        if (element instanceof RefImplicitConstructor) {
            element = ((RefImplicitConstructor)element).getOwnerClass();
        }
        if (element instanceof RefClass) {
            return element.getOwner() instanceof RefClass ? tool.getInnerClassVisibility() : tool.getClassVisibility();
        }
        if (element instanceof RefField) {
            return tool.getFieldVisibility();
        }
        if (element instanceof RefMethod) {
            PsiModifierListOwner listOwner;
            String methodVisibility = tool.getMethodVisibility();
            if (methodVisibility != null && tool.isIgnoreAccessors() && (listOwner = ((RefMethod)element).getElement()) instanceof PsiMethod && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)listOwner))) {
                return null;
            }
            return methodVisibility;
        }
        if (element instanceof RefParameter) {
            return tool.getParameterVisibility();
        }
        return "public";
    }

    protected static boolean compareVisibilities(RefJavaElement listOwner, UnusedSymbolLocalInspectionBase localInspectionTool) {
        return UnusedDeclarationPresentation.compareVisibilities(listOwner, UnusedDeclarationPresentation.getAcceptedVisibility(localInspectionTool, listOwner));
    }

    protected static boolean compareVisibilities(RefJavaElement listOwner, String acceptedVisibility) {
        if (acceptedVisibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare((String)listOwner.getAccessModifier(), (String)acceptedVisibility) >= 0) {
                    return true;
                }
                RefEntity parent = listOwner.getOwner();
                if (!(parent instanceof RefJavaElement)) break;
                listOwner = (RefJavaElement)parent;
            }
        }
        return false;
    }

    @Override
    public void ignoreElement(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] descriptors;
        if (refEntity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(21);
        }
        if (refEntity instanceof RefElement && (descriptors = this.getProblemElements().get(refEntity)) != null) {
            PsiElement psiElement = (PsiElement)ReadAction.compute(() -> {
                if (refEntity == null) {
                    UnusedDeclarationPresentation.$$$reportNull$$$0(26);
                }
                return ((RefElement)refEntity).getElement();
            });
            ArrayList<CommonProblemDescriptor> foreignDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (CommonProblemDescriptor descriptor2 : descriptors) {
                if (descriptor2 instanceof ProblemDescriptor && ReadAction.compute(() -> ((ProblemDescriptor)descriptor2).getPsiElement()) == psiElement) continue;
                foreignDescriptors.add(descriptor2);
            }
            if (foreignDescriptors.size() == descriptors.length) {
                return;
            }
        }
        super.ignoreElement(refEntity);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.myFixedElements.clear();
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(@NotNull CommonProblemDescriptor descriptor2, String hint) {
        if (descriptor2 == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(22);
        }
        if (descriptor2 instanceof ProblemDescriptor) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteFix(((ProblemDescriptor)descriptor2).getPsiElement());
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutFix(((ProblemDescriptor)descriptor2).getPsiElement());
            }
            return super.findQuickFixes(descriptor2, hint);
        }
        return null;
    }

    @Override
    @NotNull
    public JComponent getCustomPreviewPanel(@NotNull RefEntity entity) {
        if (entity == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(23);
        }
        final Project project2 = entity.getRefManager().getProject();
        JEditorPane htmlView = new JEditorPane(){

            @Override
            public String getToolTipText(MouseEvent evt) {
                String objectPackage;
                HTMLDocument hdoc;
                Element e;
                AttributeSet a;
                SimpleAttributeSet value2;
                int pos = this.viewToModel(evt.getPoint());
                if (pos >= 0 && (value2 = (SimpleAttributeSet)(a = (e = (hdoc = (HTMLDocument)this.getDocument()).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null && (objectPackage = (String)value2.getAttribute("qualifiedname")) != null) {
                    return objectPackage;
                }
                return null;
            }
        };
        htmlView.setContentType("text/html");
        htmlView.setEditable(false);
        htmlView.setOpaque(false);
        htmlView.setBackground(UIUtil.getLabelBackground());
        htmlView.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                URL url = e.getURL();
                if (url == null) {
                    return;
                }
                String ref = url.getRef();
                int offset = Integer.parseInt(ref);
                String fileURL = url.toExternalForm();
                fileURL = fileURL.substring(0, fileURL.indexOf(35));
                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                if (vFile == null) {
                    vFile = VfsUtil.findFileByURL((URL)url);
                }
                if (vFile != null) {
                    OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, vFile, offset);
                    FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
                }
            }
        });
        StyleSheet css = ((HTMLEditorKit)htmlView.getEditorKit()).getStyleSheet();
        css.addRule("p.problem-description-group {text-indent: " + JBUI.scale((int)9) + "px;font-weight:bold;}");
        css.addRule("div.problem-description {margin-left: " + JBUI.scale((int)9) + "px;}");
        css.addRule("ul {margin-left:" + JBUI.scale((int)10) + "px;text-indent: 0}");
        css.addRule("code {font-family:" + UIUtil.getLabelFont().getFamily() + "}");
        StringBuffer buf = new StringBuffer();
        this.getComposer().compose(buf, entity, false);
        String text2 = buf.toString();
        SingleInspectionProfilePanel.readHTML(htmlView, SingleInspectionProfilePanel.toHTML(htmlView, text2, false));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)htmlView, (boolean)true);
        if (jScrollPane == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(24);
        }
        return jScrollPane;
    }

    @Override
    public int getProblemsCount(@NotNull InspectionTree tree) {
        if (tree == null) {
            UnusedDeclarationPresentation.$$$reportNull$$$0(25);
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation";
                break;
            }
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 8: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefNode";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFixes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createToolNode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findQuickFixes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPreviewPanel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getProblemsCount";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ignoreElement$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PermanentDeleteFix
    implements IntentionAction {
        private final PsiElement myElement;

        private PermanentDeleteFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            String string = DELETE_QUICK_FIX;
            if (string == null) {
                PermanentDeleteFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                PermanentDeleteFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                PermanentDeleteFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                PermanentDeleteFix.$$$reportNull$$$0(3);
            }
            if (this.myElement != null && this.myElement.isValid()) {
                SafeDeleteHandler.invoke(this.myElement.getProject(), new PsiElement[]{PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class)}, false);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CommentOutFix
    implements IntentionAction {
        private final PsiElement myElement;

        private CommentOutFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            String string = COMMENT_OUT_QUICK_FIX;
            if (string == null) {
                CommentOutFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                CommentOutFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                CommentOutFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                CommentOutFix.$$$reportNull$$$0(3);
            }
            if (this.myElement != null && this.myElement.isValid()) {
                UnusedDeclarationPresentation.commentOutDead(PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class));
            }
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class CommentOutBin
    extends QuickFixAction {
        CommentOutBin(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                CommentOutBin.$$$reportNull$$$0(0);
            }
            super(COMMENT_OUT_QUICK_FIX, null, KeyStroke.getKeyStroke(47, SystemInfo.isMac ? 4 : 2), toolWrapper);
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                CommentOutBin.$$$reportNull$$$0(1);
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            ArrayList deletedRefs = new ArrayList(1);
            RefFilter filter2 = UnusedDeclarationPresentation.this.getFilter();
            for (RefEntity refElement : refElements) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
                if (psiElement == null || filter2.getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                RefEntity owner2 = refElement.getOwner();
                if (!(owner2 instanceof RefJavaElement) || filter2.getElementProblemCount((RefJavaElement)owner2) == 0 || ArrayUtil.find((Object[])refElements, (Object)owner2) <= -1) {
                    UnusedDeclarationPresentation.commentOutDead(psiElement);
                }
                refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            for (RefElement ref : deletedRefs) {
                UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.COMMENT);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutBin";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class MoveToEntries
    extends QuickFixAction {
        MoveToEntries(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                MoveToEntries.$$$reportNull$$$0(0);
            }
            super(InspectionsBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            if (e.getPresentation().isEnabledAndVisible()) {
                RefEntity[] elements;
                for (RefEntity element : elements = MoveToEntries.getInvoker(e).getTree().getSelectedElements()) {
                    if (((RefElement)element).isEntry()) continue;
                    return;
                }
                e.getPresentation().setEnabled(false);
            }
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                MoveToEntries.$$$reportNull$$$0(1);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefElement)) continue;
                entryPointsManager.addEntryPoint((RefElement)refElement, true);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$MoveToEntries";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class PermanentDeleteAction
    extends QuickFixAction {
        PermanentDeleteAction(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                PermanentDeleteAction.$$$reportNull$$$0(0);
            }
            super(DELETE_QUICK_FIX, AllIcons.Actions.Cancel, null, toolWrapper);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("SafeDelete"));
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                PermanentDeleteAction.$$$reportNull$$$0(1);
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            RefElement[] filteredRefElements = (RefElement[])Arrays.stream(refElements).filter(entry -> entry instanceof RefJavaElement && UnusedDeclarationPresentation.this.getFilter().accepts((RefJavaElement)entry)).toArray(RefElement[]::new);
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project2 = UnusedDeclarationPresentation.this.getContext().getProject();
                if (UnusedDeclarationPresentation.this.isDisposed() || project2.isDisposed()) {
                    return;
                }
                Set classes2 = Arrays.stream(filteredRefElements).filter(refElement -> refElement instanceof RefClass).collect(Collectors.toSet());
                PsiElement[] elements = (PsiElement[])Arrays.stream(filteredRefElements).filter(e -> {
                    RefEntity owner2 = e.getOwner();
                    return owner2 == null || !classes2.contains(owner2);
                }).map(e -> e.getElement()).filter(e -> e != null).toArray(PsiElement[]::new);
                SafeDeleteHandler.invoke(project2, elements, false, () -> {
                    PermanentDeleteAction.removeElements((RefEntity[])filteredRefElements, project2, this.myToolWrapper);
                    for (RefElement ref : filteredRefElements) {
                        UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.DELETE);
                    }
                });
            });
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WeakUnreferencedFilter
    extends UnreferencedFilter {
        private WeakUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContextImpl context) {
            if (tool == null) {
                WeakUnreferencedFilter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                WeakUnreferencedFilter.$$$reportNull$$$0(1);
            }
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount;
            if (refElement == null) {
                WeakUnreferencedFilter.$$$reportNull$$$0(2);
            }
            if ((problemCount = super.getElementProblemCount(refElement)) > -1) {
                return problemCount;
            }
            if (!((RefElementImpl)refElement).hasSuspiciousCallers() || ((RefJavaElementImpl)refElement).isSuspiciousRecursive()) {
                return 1;
            }
            for (RefElement element : refElement.getInReferences()) {
                if (refElement instanceof RefFile) {
                    return 1;
                }
                if (!((UnusedDeclarationInspectionBase)this.myTool).isEntryPoint(element)) continue;
                return 1;
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$WeakUnreferencedFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementProblemCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum UnusedDeclarationHint {
        COMMENT("Commented out"),
        DELETE("Deleted");

        private final String myDescription;

        private UnusedDeclarationHint(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

