/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalDescriptorsUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeState;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextImpl
extends GlobalInspectionContextBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Inspection Results", (String)ToolWindowId.INSPECTION);
    private final NotNullLazyValue<ContentManager> myContentManager;
    private volatile InspectionResultsView myView;
    private volatile String myOutputPath;
    private Content myContent;
    private volatile boolean myViewClosed;
    private long myInspectionStartedTimestamp;
    @NotNull
    private AnalysisUIOptions myUIOptions;
    private InspectionTreeState myTreeState;
    private static final PsiFile TOMBSTONE = PsiUtilCore.NULL_PSI_FILE;
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = (tool, elt, context) -> {
        PsiNamedElement problemElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elt, (Class[])new Class[]{PsiFile.class});
        RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
        if (refElement == null && problemElement != null) {
            refElement = GlobalInspectionContextUtil.retrieveRefElement(elt, context);
        }
        return refElement;
    };
    private final ConcurrentMap<InspectionToolWrapper, InspectionToolPresentation> myPresentationMap;

    public GlobalInspectionContextImpl(@NotNull Project project2, @NotNull NotNullLazyValue<ContentManager> contentManager) {
        if (project2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(0);
        }
        if (contentManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myViewClosed = true;
        this.myPresentationMap = ContainerUtil.newConcurrentMap();
        this.myUIOptions = AnalysisUIOptions.getInstance(project2).copy();
        this.myContentManager = contentManager;
    }

    @NotNull
    private ContentManager getContentManager() {
        ContentManager contentManager = (ContentManager)this.myContentManager.getValue();
        if (contentManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(2);
        }
        return contentManager;
    }

    public void setTreeState(InspectionTreeState treeState) {
        this.myTreeState = treeState;
    }

    public void addView(@NotNull InspectionResultsView view, @NotNull String title, boolean isOffline) {
        if (view == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(3);
        }
        if (title == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(this.myContent == null, (Object)"GlobalInspectionContext is busy under other view now");
        ((ContentManager)this.myContentManager.getValue()).addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == GlobalInspectionContextImpl.this.myContent) {
                    if (GlobalInspectionContextImpl.this.myView != null) {
                        GlobalInspectionContextImpl.this.close(false);
                    }
                    GlobalInspectionContextImpl.this.myContent = null;
                }
            }
        });
        this.myView = view;
        if (!isOffline) {
            this.myView.setUpdating(true);
        }
        if (this.myTreeState != null) {
            this.myView.getTree().setTreeState(this.myTreeState);
        }
        this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title, false);
        this.myContent.setDisposer((Disposable)this.myView);
        ContentManager contentManager = this.getContentManager();
        contentManager.addContent(this.myContent);
        contentManager.setSelectedContent(this.myContent);
        ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow(ToolWindowId.INSPECTION).activate(null);
    }

    public void addView(@NotNull InspectionResultsView view) {
        if (view == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(5);
        }
        this.addView(view, InspectionsBundle.message((String)(view.isSingleInspectionRun() ? "inspection.results.for.inspection.toolwindow.title" : "inspection.results.for.profile.toolwindow.title"), (Object[])new Object[]{view.getCurrentProfileName(), this.getCurrentScope().getShortenName()}), false);
    }

    @Override
    public void doInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(6);
        }
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        super.doInspections(scope);
    }

    public void launchInspectionsOffline(@NotNull AnalysisScope scope, @Nullable String outputPath, boolean runGlobalToolsOnly, @NotNull List<File> inspectionsResults) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(7);
        }
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(8);
        }
        this.performInspectionsWithProgressAndExportResults(scope, runGlobalToolsOnly, true, outputPath, inspectionsResults);
    }

    public void performInspectionsWithProgressAndExportResults(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections, @Nullable String outputPath, @NotNull List<File> inspectionsResults) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(9);
        }
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(10);
        }
        this.cleanupTools();
        this.setCurrentScope(scope);
        Runnable action = () -> {
            if (scope == null) {
                GlobalInspectionContextImpl.$$$reportNull$$$0(62);
            }
            if (inspectionsResults == null) {
                GlobalInspectionContextImpl.$$$reportNull$$$0(63);
            }
            this.myOutputPath = outputPath;
            try {
                this.performInspectionsWithProgress(scope, runGlobalToolsOnly, isOfflineInspections);
                this.exportResults(inspectionsResults, outputPath);
            }
            finally {
                this.myOutputPath = null;
            }
        };
        if (isOfflineInspections) {
            ApplicationManager.getApplication().runReadAction(action);
        } else {
            action.run();
        }
    }

    private void exportResults(@NotNull List<File> inspectionsResults, @Nullable String outputPath) {
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(11);
        }
        String ext = ".xml";
        HashMap globalTools = new HashMap();
        for (Map.Entry<String, Tools> entry : this.getTools().entrySet()) {
            Tools sameTools = entry.getValue();
            boolean hasProblems = false;
            String toolName = entry.getKey();
            if (sameTools != null) {
                for (ScopeToolState toolDescr : sameTools.getTools()) {
                    InspectionToolWrapper toolWrapper = toolDescr.getTool();
                    if (toolWrapper instanceof LocalInspectionToolWrapper) {
                        hasProblems = new File(outputPath, toolName + ".xml").exists();
                        continue;
                    }
                    InspectionToolPresentation presentation = this.getPresentation(toolWrapper);
                    presentation.updateContent();
                    if (!presentation.hasReportedProblems()) continue;
                    Element root = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
                    globalTools.put(root, sameTools);
                    LOG.assertTrue(!hasProblems, (Object)toolName);
                    break;
                }
            }
            if (!hasProblems) continue;
            try {
                new File(outputPath).mkdirs();
                File file2 = new File(outputPath, toolName + ".xml");
                inspectionsResults.add(file2);
                FileUtil.writeToFile((File)file2, (byte[])("</" + InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]) + ">").getBytes(CharsetToolkit.UTF8_CHARSET), (boolean)true);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.getRefManager().iterate(new RefVisitor((Map)globalTools){
            final /* synthetic */ Map val$globalTools;
            {
                this.val$globalTools = map;
            }

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (Map.Entry entry : this.val$globalTools.entrySet()) {
                    Tools tools = (Tools)entry.getValue();
                    Element element = (Element)entry.getKey();
                    for (ScopeToolState state : tools.getTools()) {
                        try {
                            InspectionToolWrapper toolWrapper = state.getTool();
                            InspectionToolPresentation presentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                            presentation.exportResults(element, refEntity, d -> false);
                        }
                        catch (Throwable e) {
                            LOG.error("Problem when exporting: " + refEntity.getExternalName(), e);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$2", "visitElement"));
            }
        });
        for (Map.Entry<String, Object> entry : globalTools.entrySet()) {
            String toolName = ((Tools)entry.getValue()).getShortName();
            Element element = (Element)entry.getKey();
            element.setAttribute("is_local_tool", Boolean.toString(false));
            org.jdom.Document doc = new org.jdom.Document(element);
            PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePaths(doc.getRootElement());
            try {
                new File(outputPath).mkdirs();
                File file2 = new File(outputPath, toolName + ".xml");
                inspectionsResults.add(file2);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), CharsetToolkit.UTF8_CHARSET);
                Throwable throwable = null;
                try {
                    JDOMUtil.writeDocument((org.jdom.Document)doc, (Writer)writer, (String)"\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void resolveElement(@NotNull InspectionProfileEntry tool, @NotNull PsiElement element) {
        RefElement refElement;
        if (tool == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(12);
        }
        if (element == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(13);
        }
        if ((refElement = this.getRefManager().getReference(element)) == null) {
            return;
        }
        Tools tools = this.getTools().get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                InspectionToolPresentation presentation = this.getPresentationOrNull(toolWrapper);
                if (presentation == null) continue;
                GlobalInspectionContextImpl.resolveElementRecursively(presentation, (RefEntity)refElement);
            }
        }
    }

    public InspectionResultsView getView() {
        return this.myView;
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    private static void resolveElementRecursively(@NotNull InspectionToolPresentation presentation, @NotNull RefEntity refElement) {
        if (presentation == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(14);
        }
        if (refElement == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(15);
        }
        presentation.suppressProblem(refElement);
        List children2 = refElement.getChildren();
        for (RefEntity child : children2) {
            GlobalInspectionContextImpl.resolveElementRecursively(presentation, child);
        }
    }

    @NotNull
    public AnalysisUIOptions getUIOptions() {
        AnalysisUIOptions analysisUIOptions = this.myUIOptions;
        if (analysisUIOptions == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(16);
        }
        return analysisUIOptions;
    }

    public void setSplitterProportion(float proportion) {
        this.myUIOptions.SPLITTER_PROPORTION = proportion;
    }

    @NotNull
    public ToggleAction createToggleAutoscrollAction() {
        ToggleAction toggleAction = this.myUIOptions.getAutoScrollToSourceHandler().createToggleAction();
        if (toggleAction == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(17);
        }
        return toggleAction;
    }

    @Override
    protected void launchInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(18);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUIOptions = AnalysisUIOptions.getInstance(this.getProject()).copy();
        }
        this.myViewClosed = false;
        super.launchInspections(scope);
    }

    @Override
    @NotNull
    protected PerformInBackgroundOption createOption() {
        PerformAnalysisInBackgroundOption performAnalysisInBackgroundOption = new PerformAnalysisInBackgroundOption(this.getProject());
        if (performAnalysisInBackgroundOption == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(19);
        }
        return performAnalysisInBackgroundOption;
    }

    @Override
    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        long elapsed = System.currentTimeMillis() - this.myInspectionStartedTimestamp;
        LOG.info("Code inspection finished. Took " + elapsed + "ms");
        if (this.getProject().isDisposed()) {
            return;
        }
        InspectionResultsView view = this.myView == null ? new InspectionResultsView(this, this.createContentProvider()) : null;
        if (!(this.myView == null ? view : this.myView).hasProblems()) {
            NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{scope.getFileCount(), scope.getShortenName()}), MessageType.INFO).notify(this.getProject());
            this.close(true);
            if (view != null) {
                Disposer.dispose((Disposable)view);
            }
        } else if (view != null && !view.isDisposed() && this.getCurrentScope() != null) {
            this.addView(view);
            view.update();
        }
        if (this.myView != null) {
            this.myView.setUpdating(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(21);
        }
        this.myInspectionStartedTimestamp = System.currentTimeMillis();
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            throw new IncorrectOperationException("Must be run under progress");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isDispatchThread()) {
            throw new IncorrectOperationException("Must not start inspections from within EDT");
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within write action");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within global read action");
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.getProject());
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        ArrayList<Tools> localTools = new ArrayList<Tools>();
        ArrayList<Tools> globalSimpleTools = new ArrayList<Tools>();
        this.initializeTools(globalTools, localTools, globalSimpleTools);
        this.appendPairedInspectionsForUnfairTools(globalTools, globalSimpleTools, localTools);
        this.runGlobalTools(scope, inspectionManager, globalTools, isOfflineInspections);
        if (runGlobalToolsOnly || localTools.isEmpty() && globalSimpleTools.isEmpty()) {
            return;
        }
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
        THashSet localScopeFiles = searchScope instanceof LocalSearchScope ? new THashSet() : null;
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            tool.inspectionStarted(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)this.getPresentation(toolWrapper));
        }
        boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        Map<String, InspectionToolWrapper> map = GlobalInspectionContextImpl.getInspectionWrappersMap(localTools);
        ArrayBlockingQueue<PsiFile> filesToInspect = new ArrayBlockingQueue<PsiFile>(1000);
        SensitiveProgressWrapper iteratingIndicator = new SensitiveProgressWrapper(progressIndicator);
        Future<?> future2 = this.startIterateScopeInBackground(scope, (Collection<VirtualFile>)localScopeFiles, headlessEnvironment, filesToInspect, iteratingIndicator);
        Processor processor2 = file2 -> {
            if (scope == null) {
                GlobalInspectionContextImpl.$$$reportNull$$$0(60);
            }
            ProgressManager.checkCanceled();
            Boolean readActionSuccess = (Boolean)DumbService.getInstance((Project)this.getProject()).tryRunReadActionInSmartMode(() -> {
                if (scope == null) {
                    GlobalInspectionContextImpl.$$$reportNull$$$0(61);
                }
                if (!file2.isValid()) {
                    return true;
                }
                VirtualFile virtualFile = file2.getVirtualFile();
                if (!scope.contains(virtualFile)) {
                    LOG.info(file2.getName() + "; scope: " + scope + "; " + virtualFile);
                    return true;
                }
                this.inspectFile((PsiFile)file2, GlobalInspectionContextImpl.getEffectiveRange(searchScope, file2), inspectionManager, (List<Tools>)localTools, (List<Tools>)globalSimpleTools, map);
                return true;
            }, "Inspect code is not available until indices are ready");
            if (readActionSuccess == null || !readActionSuccess.booleanValue()) {
                throw new ProcessCanceledException();
            }
            boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
            Stream.concat(GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2, includeDoNotShow).stream(), GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow).stream()).filter(wrapper -> wrapper.getTool() instanceof ExternalAnnotatorBatchInspection).forEach(wrapper -> {
                ProblemDescriptor[] descriptors = ((ExternalAnnotatorBatchInspection)wrapper.getTool()).checkFile((PsiFile)file2, this, inspectionManager);
                InspectionToolPresentation toolPresentation = this.getPresentation((InspectionToolWrapper)wrapper);
                ReadAction.run(() -> LocalDescriptorsUtil.addProblemDescriptors(Arrays.asList(descriptors), false, this, null, CONVERT, toolPresentation));
            });
            return true;
        };
        try {
            LinkedBlockingQueue filesFailedToInspect = new LinkedBlockingQueue();
            while (true) {
                Disposable disposable = Disposer.newDisposable();
                SensitiveProgressWrapper wrapper = new SensitiveProgressWrapper(progressIndicator);
                try {
                    ReadAction.run(() -> {
                        wrapper.start();
                        ProgressIndicatorUtils.forceWriteActionPriority(wrapper, disposable);
                        if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
                            throw new ProcessCanceledException();
                        }
                    });
                    ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(filesToInspect, filesFailedToInspect, wrapper, TOMBSTONE, processor2);
                }
                catch (ProcessCanceledException ignored) {
                    progressIndicator.checkCanceled();
                    assert (!ApplicationManager.getApplication().isReadAccessAllowed());
                    assert (!ApplicationManager.getApplication().isDispatchThread());
                    ApplicationManager.getApplication().runReadAction(EmptyRunnable.getInstance());
                    continue;
                }
                finally {
                    Disposer.dispose((Disposable)disposable);
                    continue;
                }
                break;
            }
        }
        finally {
            iteratingIndicator.cancel();
            filesToInspect.clear();
            try {
                future2.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Thread dump: \n" + ThreadDumper.dumpThreadsToString(), (Throwable)e);
            }
        }
        ProgressManager.checkCanceled();
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor(toolWrapper, map);
            tool.inspectionFinished(inspectionManager, (GlobalInspectionContext)this, problemDescriptionProcessor);
        }
        this.addProblemsToView(globalSimpleTools);
    }

    private static TextRange getEffectiveRange(SearchScope searchScope, PsiFile file2) {
        PsiElement[] scopeFileElements;
        if (searchScope instanceof LocalSearchScope && (scopeFileElements = (PsiElement[])Arrays.stream(((LocalSearchScope)searchScope).getScope()).filter(e -> e.getContainingFile() == file2).toArray(PsiElement[]::new)).length > 0) {
            int start = -1;
            int end = -1;
            for (PsiElement scopeElement : scopeFileElements) {
                TextRange elementRange = scopeElement.getTextRange();
                start = start == -1 ? elementRange.getStartOffset() : Math.min(elementRange.getStartOffset(), start);
                end = end == -1 ? elementRange.getEndOffset() : Math.max(elementRange.getEndOffset(), end);
            }
            return new TextRange(start, end);
        }
        return new TextRange(0, file2.getTextLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectFile(@NotNull PsiFile file2, @NotNull TextRange range, @NotNull InspectionManager inspectionManager, @NotNull List<Tools> localTools, @NotNull List<Tools> globalSimpleTools, @NotNull Map<String, InspectionToolWrapper> wrappersMap) {
        Document document;
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(22);
        }
        if (range == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(23);
        }
        if (inspectionManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(24);
        }
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(25);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(26);
        }
        if (wrappersMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(27);
        }
        if ((document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2)) == null) {
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        String url = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)this.getProject(), (boolean)true, (boolean)false);
        this.incrementJobDoneAmount(this.getStdJobDescriptors().LOCAL_ANALYSIS, url);
        LocalInspectionsPass pass = new LocalInspectionsPass(file2, document, range.getStartOffset(), range.getEndOffset(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty());
        try {
            boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
            List lTools = GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2, includeDoNotShow);
            List<LocalInspectionToolWrapper> nonExternalAnnotators = lTools.stream().filter(wrapper -> !(wrapper.getTool() instanceof ExternalAnnotatorBatchInspection)).collect(Collectors.toList());
            pass.doInspectInBatch(this, inspectionManager, nonExternalAnnotators);
            List globalSTools = GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow);
            List tools = globalSTools.stream().filter(wrapper -> !(wrapper.getTool() instanceof ExternalAnnotatorBatchInspection)).collect(Collectors.toList());
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(tools, this.myProgressIndicator, false, toolWrapper -> {
                if (inspectionManager == null) {
                    GlobalInspectionContextImpl.$$$reportNull$$$0(57);
                }
                if (file2 == null) {
                    GlobalInspectionContextImpl.$$$reportNull$$$0(58);
                }
                if (wrappersMap == null) {
                    GlobalInspectionContextImpl.$$$reportNull$$$0(59);
                }
                GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
                ProblemsHolder holder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor((GlobalInspectionToolWrapper)((Object)toolWrapper), wrappersMap);
                tool.checkFile(file2, inspectionManager, holder, (GlobalInspectionContext)this, problemDescriptionProcessor);
                InspectionToolPresentation toolPresentation = this.getPresentation((InspectionToolWrapper)toolWrapper);
                LocalDescriptorsUtil.addProblemDescriptors(holder.getResults(), false, this, null, CONVERT, toolPresentation);
                return true;
            });
        }
        catch (ProcessCanceledException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            LOG.error("In file: " + file2, cause);
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("In file: " + file2.getName(), e);
        }
        finally {
            InjectedLanguageManager.getInstance((Project)this.getProject()).dropFileCaches(file2);
        }
    }

    protected boolean includeDoNotShow(InspectionProfile profile2) {
        return profile2.getSingleTool() != null;
    }

    @NotNull
    private Future<?> startIterateScopeInBackground(final @NotNull AnalysisScope scope, final @Nullable Collection<VirtualFile> localScopeFiles, final boolean headlessEnvironment, final @NotNull BlockingQueue<PsiFile> outFilesToInspect, @NotNull ProgressIndicator progressIndicator) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(28);
        }
        if (outFilesToInspect == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(29);
        }
        if (progressIndicator == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(30);
        }
        Task.Backgroundable task = new Task.Backgroundable(this.getProject(), "Scanning Files to Inspect"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
                    scope.accept(arg_0 -> this.lambda$run$1((FileIndex)fileIndex, headlessEnvironment, localScopeFiles, outFilesToInspect, arg_0));
                }
                catch (ProcessCanceledException e) {
                }
                finally {
                    try {
                        outFilesToInspect.put(TOMBSTONE);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            private /* synthetic */ boolean lambda$run$1(FileIndex fileIndex, boolean headlessEnvironment2, @Nullable Collection localScopeFiles2, @NotNull BlockingQueue outFilesToInspect2, VirtualFile file2) {
                if (outFilesToInspect2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                ProgressManager.checkCanceled();
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2) || !fileIndex.isInContent(file2)) {
                    return true;
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                    Document document;
                    if (this.getProject().isDisposed()) {
                        throw new ProcessCanceledException();
                    }
                    PsiFile psi = PsiManager.getInstance((Project)this.getProject()).findFile(file2);
                    Document document2 = document = psi == null ? null : GlobalInspectionContextImpl.this.shouldProcess(psi, headlessEnvironment2, localScopeFiles2);
                    if (document != null) {
                        return psi;
                    }
                    return null;
                });
                if (psiFile != null) {
                    try {
                        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                            throw new IllegalStateException("Must not have read action");
                        }
                        outFilesToInspect2.put(psiFile);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
                ProgressManager.checkCanceled();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outFilesToInspect";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Future<?> future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, progressIndicator, null);
        if (future2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(31);
        }
        return future2;
    }

    private Document shouldProcess(@NotNull PsiFile file2, boolean headlessEnvironment, @Nullable Collection<VirtualFile> localScopeFiles) {
        VirtualFile virtualFile;
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(32);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            return null;
        }
        if (GlobalInspectionContextImpl.isBinary(file2)) {
            return null;
        }
        if (this.myViewClosed && !headlessEnvironment) {
            throw new ProcessCanceledException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running local inspections on " + virtualFile.getPath());
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile)) {
            return null;
        }
        if (localScopeFiles != null && !localScopeFiles.add(virtualFile)) {
            return null;
        }
        if (!ProblemHighlightFilter.shouldProcessFileInBatch((PsiFile)file2)) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private void runGlobalTools(@NotNull AnalysisScope scope, @NotNull InspectionManager inspectionManager, @NotNull List<Tools> globalTools, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(33);
        }
        if (inspectionManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(34);
        }
        if (globalTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(35);
        }
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed() || isOfflineInspections, (Object)"Must not run under read action, too unresponsive");
        ArrayList needRepeatSearchRequest = new ArrayList();
        boolean canBeExternalUsages = scope.getScopeType() != 1 || !scope.isIncludeTestSource();
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope stateScope;
                if (!state.isEnabled() || (stateScope = state.getScope(this.getProject())) == null) continue;
                AnalysisScope scopeForState = new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)this.getProject(), (NamedScope)stateScope), this.getProject());
                InspectionToolWrapper toolWrapper = state.getTool();
                GlobalInspectionTool tool = (GlobalInspectionTool)toolWrapper.getTool();
                InspectionToolPresentation toolPresentation = this.getPresentation(toolWrapper);
                try {
                    if (tool.isGraphNeeded()) {
                        try {
                            ((RefManagerImpl)this.getRefManager()).findAllDeclarations();
                        }
                        catch (Throwable e) {
                            this.getStdJobDescriptors().BUILD_GRAPH.setDoneAmount(0);
                            throw e;
                        }
                    }
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (inspectionManager == null) {
                            GlobalInspectionContextImpl.$$$reportNull$$$0(56);
                        }
                        tool.runInspection(scopeForState, inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation);
                        if ((canBeExternalUsages || tool.getAdditionalJobs((GlobalInspectionContext)this) != null) && tool.queryExternalUsagesRequests(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation)) {
                            needRepeatSearchRequest.add(toolWrapper);
                        }
                    });
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            try {
                extension.performPostRunActivities(needRepeatSearchRequest, (GlobalInspectionContext)this);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.addProblemsToView(globalTools);
    }

    public ActionCallback initializeViewIfNeed() {
        if (this.myView != null) {
            return ActionCallback.DONE;
        }
        Application app = ApplicationManager.getApplication();
        Runnable createView = () -> {
            InspectionResultsView view = this.getView();
            if (view == null) {
                view = new InspectionResultsView(this, this.createContentProvider());
                this.addView(view);
            }
        };
        if (app.isUnitTestMode()) {
            createView.run();
            return ActionCallback.DONE;
        }
        return app.getInvokator().invokeLater(createView);
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<Tools> globalTools, @NotNull List<Tools> globalSimpleTools, @NotNull List<Tools> localTools) {
        Tools[] larray;
        if (globalTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(36);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(37);
        }
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(38);
        }
        for (Tools tool : larray = localTools.toArray(new Tools[localTools.size()])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            String batchShortName = ((PairedUnfairLocalInspectionTool)localTool).getInspectionForBatchShortName();
            InspectionProfileImpl currentProfile = this.getCurrentProfile();
            if (currentProfile == null) {
                batchInspection = null;
            } else {
                InspectionToolWrapper pairedWrapper = currentProfile.getInspectionTool(batchShortName, this.getProject());
                InspectionToolWrapper inspectionToolWrapper = batchInspection = pairedWrapper != null ? pairedWrapper.createCopy() : null;
            }
            if (batchInspection == null || this.getTools().containsKey(batchShortName)) continue;
            InspectionProfileEntry batchTool = batchInspection.getTool();
            ScopeToolState defaultState = tool.getDefaultState();
            ToolsImpl newTool = new ToolsImpl(batchInspection, defaultState.getLevel(), true, defaultState.isEnabled());
            for (ScopeToolState state : tool.getTools()) {
                NamedScope scope = state.getScope(this.getProject());
                if (scope == null) continue;
                newTool.addTool(scope, batchInspection, state.isEnabled(), state.getLevel());
            }
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalSimpleInspectionTool) {
                globalSimpleTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                globalTools.add(newTool);
            } else {
                throw new AssertionError(batchTool);
            }
            this.myTools.put(batchShortName, newTool);
            batchInspection.initialize((GlobalInspectionContext)this);
        }
    }

    @NotNull
    private static <T extends InspectionToolWrapper> List<T> getWrappersFromTools(@NotNull List<Tools> localTools, @NotNull PsiFile file2, boolean includeDoNotShow) {
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(40);
        }
        ArrayList<InspectionToolWrapper> lTools = new ArrayList<InspectionToolWrapper>();
        for (Tools tool : localTools) {
            InspectionToolWrapper enabledTool = tool.getEnabledTool((PsiElement)file2, includeDoNotShow);
            if (enabledTool == null) continue;
            lTools.add(enabledTool);
        }
        ArrayList<InspectionToolWrapper> arrayList = lTools;
        if (arrayList == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    private ProblemDescriptionsProcessor getProblemDescriptionProcessor(final @NotNull GlobalInspectionToolWrapper toolWrapper, final @NotNull Map<String, InspectionToolWrapper> wrappersMap) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(42);
        }
        if (wrappersMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(43);
        }
        ProblemDescriptionsProcessor problemDescriptionsProcessor = new ProblemDescriptionsProcessor(){

            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                if (commonProblemDescriptors == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (CommonProblemDescriptor problemDescriptor : commonProblemDescriptors) {
                    GlobalInspectionToolWrapper targetWrapper;
                    if (!(problemDescriptor instanceof ProblemDescriptor)) continue;
                    ProblemGroup problemGroup = ((ProblemDescriptor)problemDescriptor).getProblemGroup();
                    GlobalInspectionToolWrapper globalInspectionToolWrapper = targetWrapper = problemGroup == null ? toolWrapper : (InspectionToolWrapper)wrappersMap.get(problemGroup.getProblemName());
                    if (targetWrapper == null) continue;
                    InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(targetWrapper);
                    toolPresentation.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$4", "addProblemElement"));
            }
        };
        if (problemDescriptionsProcessor == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(44);
        }
        return problemDescriptionsProcessor;
    }

    @NotNull
    private static Map<String, InspectionToolWrapper> getInspectionWrappersMap(@NotNull List<Tools> tools) {
        if (tools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(45);
        }
        HashMap name2Inspection = new HashMap(tools.size());
        for (Tools tool : tools) {
            InspectionToolWrapper toolWrapper = tool.getTool();
            name2Inspection.put(toolWrapper.getShortName(), toolWrapper);
        }
        HashMap hashMap = name2Inspection;
        if (hashMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(46);
        }
        return hashMap;
    }

    @Override
    public void close(boolean noSuspiciousCodeFound) {
        if (!noSuspiciousCodeFound) {
            if (this.myView.isRerun()) {
                this.myViewClosed = true;
                this.myView = null;
            }
            if (this.myView == null) {
                return;
            }
        }
        AnalysisUIOptions.getInstance(this.getProject()).save(this.myUIOptions);
        if (this.myContent != null) {
            ContentManager contentManager = this.getContentManager();
            contentManager.removeContent(this.myContent, true);
        }
        this.myViewClosed = true;
        this.myView = null;
        ((InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject())).closeRunningContext(this);
        this.myPresentationMap.clear();
        super.close(noSuspiciousCodeFound);
    }

    @Override
    public void cleanup() {
        if (this.myView != null) {
            this.myView.setUpdating(false);
        } else {
            this.myPresentationMap.clear();
            super.cleanup();
        }
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.getTree().queueUpdate();
        }
    }

    @Nullable
    public InspectionToolPresentation getPresentationOrNull(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(47);
        }
        return (InspectionToolPresentation)this.myPresentationMap.get(toolWrapper);
    }

    @NotNull
    public InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper toolWrapper) {
        InspectionToolPresentation presentation;
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(48);
        }
        if ((presentation = (InspectionToolPresentation)this.myPresentationMap.get(toolWrapper)) == null) {
            String presentationClass = StringUtil.notNullize((String)(toolWrapper.myEP == null ? null : toolWrapper.myEP.presentation), (String)DefaultInspectionToolPresentation.class.getName());
            try {
                Constructor<?> constructor = Class.forName(presentationClass).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextImpl.class);
                presentation = (InspectionToolPresentation)constructor.newInstance(new Object[]{toolWrapper, this});
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
            presentation = (InspectionToolPresentation)ConcurrencyUtil.cacheOrGet(this.myPresentationMap, (Object)toolWrapper, (Object)presentation);
        }
        InspectionToolPresentation inspectionToolPresentation = presentation;
        if (inspectionToolPresentation == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(49);
        }
        return inspectionToolPresentation;
    }

    @Override
    public void codeCleanup(final @NotNull AnalysisScope scope, final @NotNull InspectionProfile profile2, final @Nullable String commandName, final @Nullable Runnable postRunnable, boolean modal) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(50);
        }
        if (profile2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(51);
        }
        String title = "Inspect Code...";
        Object task = modal ? new Task.Modal(this.getProject(), title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextImpl.this.cleanup(scope, profile2, postRunnable, commandName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5", "run"));
            }
        } : new Task.Backgroundable(this.getProject(), title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextImpl.this.cleanup(scope, profile2, postRunnable, commandName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$6", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile2, @Nullable Runnable postRunnable, @Nullable String commandName) {
        PsiElement[] elements;
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(52);
        }
        if (profile2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(53);
        }
        this.setCurrentScope(scope);
        final int fileCount = scope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        final SearchScope searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
        final TextRange range = searchScope instanceof LocalSearchScope ? ((elements = ((LocalSearchScope)searchScope).getScope()).length == 1 ? (TextRange)ReadAction.compute(() -> ((PsiElement)elements[0]).getTextRange()) : null) : null;
        final List inspectionTools = ContainerUtil.filter((Collection)profile2.getAllEnabledInspectionTools(this.getProject()), tools -> {
            assert (tools != null);
            return tools.getTool().isCleanupTool();
        });
        final boolean includeDoNotShow = this.includeDoNotShow(profile2);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        refManager.inspectionReadActionStarted();
        final ArrayList descriptors = new ArrayList();
        HashSet files = new HashSet();
        try {
            scope.accept(new PsiElementVisitor((Set)files){
                private int myCount;
                final /* synthetic */ Set val$files;
                {
                    this.val$files = set2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitFile(PsiFile file2) {
                    if (progressIndicator != null) {
                        progressIndicator.setFraction((double)(++this.myCount) / (double)fileCount);
                    }
                    if (GlobalInspectionContextImpl.isBinary(file2)) {
                        return;
                    }
                    ArrayList<LocalInspectionToolWrapper> lTools = new ArrayList<LocalInspectionToolWrapper>();
                    for (Tools tools : inspectionTools) {
                        InspectionToolWrapper tool = tools.getEnabledTool((PsiElement)file2, includeDoNotShow);
                        if (tool instanceof GlobalInspectionToolWrapper) {
                            tool = ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper();
                        }
                        if (tool == null) continue;
                        lTools.add((LocalInspectionToolWrapper)tool);
                        tool.initialize((GlobalInspectionContext)GlobalInspectionContextImpl.this);
                    }
                    if (!lTools.isEmpty()) {
                        try {
                            LocalInspectionsPass pass = new LocalInspectionsPass(file2, PsiDocumentManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()).getDocument(file2), range != null ? range.getStartOffset() : 0, range != null ? range.getEndOffset() : file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty());
                            Runnable runnable2 = () -> pass.doInspectInBatch(GlobalInspectionContextImpl.this, InspectionManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()), lTools);
                            ApplicationManager.getApplication().runReadAction(runnable2);
                            TreeSet<ProblemDescriptor> localDescriptors = new TreeSet<ProblemDescriptor>(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
                            for (LocalInspectionToolWrapper tool : lTools) {
                                InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(tool);
                                for (CommonProblemDescriptor descriptor2 : toolPresentation.getProblemDescriptors()) {
                                    if (!(descriptor2 instanceof ProblemDescriptor)) continue;
                                    localDescriptors.add((ProblemDescriptor)descriptor2);
                                }
                            }
                            if (searchScope instanceof LocalSearchScope) {
                                Iterator iterator = localDescriptors.iterator();
                                while (iterator.hasNext()) {
                                    ProblemDescriptor descriptor3 = (ProblemDescriptor)iterator.next();
                                    TextRange infoRange = descriptor3 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor3).getTextRange() : null;
                                    if (infoRange == null || ((LocalSearchScope)searchScope).containsRange(file2, infoRange)) continue;
                                    iterator.remove();
                                }
                            }
                            if (!localDescriptors.isEmpty()) {
                                descriptors.addAll(localDescriptors);
                                this.val$files.add(file2);
                            }
                        }
                        finally {
                            GlobalInspectionContextImpl.this.myPresentationMap.clear();
                        }
                    }
                }
            });
        }
        finally {
            refManager.inspectionReadActionFinished();
        }
        if (files.isEmpty()) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (scope == null) {
                    GlobalInspectionContextImpl.$$$reportNull$$$0(55);
                }
                if (commandName != null) {
                    NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{scope.getFileCount(), scope.getDisplayName()}), MessageType.INFO).notify(this.getProject());
                }
                if (postRunnable != null) {
                    postRunnable.run();
                }
            }, (ModalityState)ModalityState.defaultModalityState());
            return;
        }
        Runnable runnable2 = () -> this.lambda$cleanup$17((Set)files, descriptors, postRunnable);
        TransactionGuard.submitTransaction((Disposable)this.getProject(), (Runnable)runnable2);
    }

    private static boolean isBinary(@NotNull PsiFile file2) {
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(54);
        }
        return file2 instanceof PsiBinaryFile || file2.getFileType().isBinary();
    }

    public boolean isViewClosed() {
        return this.myViewClosed;
    }

    private InspectionRVContentProvider createContentProvider() {
        return new InspectionRVContentProviderImpl(this.getProject());
    }

    private void addProblemsToView(List<Tools> tools) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myView == null && !((Boolean)ReadAction.compute(() -> InspectionResultsView.hasProblems(tools, this, this.createContentProvider()))).booleanValue()) {
            return;
        }
        this.initializeViewIfNeed().doWhenDone(() -> this.myView.addTools(tools));
    }

    private /* synthetic */ void lambda$cleanup$17(Set files, List descriptors, @Nullable Runnable postRunnable) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)files)) {
            return;
        }
        CleanupInspectionIntention.applyFixesNoSort(this.getProject(), "Code Cleanup", descriptors, null, false);
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 16: 
            case 17: 
            case 19: 
            case 31: 
            case 41: 
            case 44: 
            case 46: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 16: 
            case 17: 
            case 19: 
            case 31: 
            case 41: 
            case 44: 
            case 46: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: 
            case 16: 
            case 17: 
            case 19: 
            case 31: 
            case 41: 
            case 44: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 18: 
            case 20: 
            case 21: 
            case 28: 
            case 33: 
            case 50: 
            case 52: 
            case 55: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 22: 
            case 32: 
            case 40: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 24: 
            case 34: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 25: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSimpleTools";
                break;
            }
            case 27: 
            case 43: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappersMap";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFilesToInspect";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 42: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIOptions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleAutoscrollAction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createOption";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "startIterateScopeInBackground";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappersFromTools";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptionProcessor";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionWrappersMap";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 16: 
            case 17: 
            case 19: 
            case 31: 
            case 41: 
            case 44: 
            case 46: 
            case 49: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addView";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doInspections";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "launchInspectionsOffline";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performInspectionsWithProgressAndExportResults";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementRecursively";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "launchInspections";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyInspectionsFinished";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runTools";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "inspectFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "startIterateScopeInBackground";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "runGlobalTools";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "appendPairedInspectionsForUnfairTools";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getWrappersFromTools";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getProblemDescriptionProcessor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionWrappersMap";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationOrNull";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "codeCleanup";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cleanup$16";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runGlobalTools$12";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inspectFile$11";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runTools$5";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performInspectionsWithProgressAndExportResults$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 16: 
            case 17: 
            case 19: 
            case 31: 
            case 41: 
            case 44: 
            case 46: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

