/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixWrapper
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInspection.ex.QuickFixWrapper");
    private final ProblemDescriptor myDescriptor;
    private final LocalQuickFix myFix;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor2, int fixNumber) {
        if (descriptor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(fixNumber >= 0, (Object)fixNumber);
        QuickFix[] fixes = descriptor2.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix = fixes[fixNumber];
        Object object = fix instanceof IntentionAction ? (IntentionAction)fix : new QuickFixWrapper(descriptor2, (LocalQuickFix)fix);
        if (object == null) {
            QuickFixWrapper.$$$reportNull$$$0(1);
        }
        return object;
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor2, @NotNull LocalQuickFix fix) {
        if (descriptor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(2);
        }
        if (fix == null) {
            QuickFixWrapper.$$$reportNull$$$0(3);
        }
        this.myDescriptor = descriptor2;
        this.myFix = fix;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            QuickFixWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getFix().getName();
        if (string == null) {
            QuickFixWrapper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement psiElement;
        if (project2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(6);
        }
        if ((psiElement = this.myDescriptor.getPsiElement()) == null || !psiElement.isValid()) {
            return false;
        }
        LocalQuickFix fix = this.getFix();
        return !(fix instanceof IntentionAction) || ((IntentionAction)fix).isAvailable(project2, editor, file2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement element;
        if (project2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(7);
        }
        PsiFile fileForUndo = (element = this.myDescriptor.getPsiElement()) == null ? null : element.getContainingFile();
        LocalQuickFix fix = this.getFix();
        fix.applyFix(project2, (CommonProblemDescriptor)this.myDescriptor);
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        if (fileForUndo != null && !fileForUndo.equals(file2)) {
            UndoUtil.markPsiFileForUndo((PsiFile)fileForUndo);
        }
    }

    public boolean startInWriteAction() {
        return this.getFix().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(8);
        }
        return this.getFix().getElementToMakeWritable(file2);
    }

    @NotNull
    public LocalQuickFix getFix() {
        LocalQuickFix localQuickFix = this.myFix;
        if (localQuickFix == null) {
            QuickFixWrapper.$$$reportNull$$$0(9);
        }
        return localQuickFix;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myDescriptor.getHighlightType();
    }

    public String toString() {
        return this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

