/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlMissingClosingTagInspection
extends HtmlLocalInspectionTool {
    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlMissingClosingTagInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlMissingClosingTagInspection.$$$reportNull$$$0(1);
        }
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        PsiElement child = tag.getLastChild();
        if (child instanceof PsiErrorElement) {
            return;
        }
        XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        if (tagNameElement == null) {
            return;
        }
        String tagName = tagNameElement.getText();
        if (HtmlUtil.isSingleHtmlTag(tagName) || XmlTagUtil.getEndTagNameElement((XmlTag)tag) != null) {
            return;
        }
        holder.registerProblem((PsiElement)tagNameElement, XmlErrorMessages.message("element.missing.end.tag", new Object[0]), new LocalQuickFix[]{new MissingClosingTagFix(tagName)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection";
        objectArray[2] = "checkTag";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MissingClosingTagFix
    implements LocalQuickFix {
        private final String myName;

        public MissingClosingTagFix(String name2) {
            this.myName = name2;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = XmlErrorMessages.message("add.named.closing.tag", this.myName);
            if (string == null) {
                MissingClosingTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = XmlErrorMessages.message("add.closing.tag", new Object[0]);
            if (string == null) {
                MissingClosingTagFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project2 == null) {
                MissingClosingTagFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                MissingClosingTagFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof XmlToken)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof XmlTag)) {
                return;
            }
            String text2 = parent.getText();
            if (text2.contains("\n")) {
                int cutoff = -1;
                for (int i = text2.length() - 1; i > 0; --i) {
                    char c = text2.charAt(i);
                    if (c == ' ' || c == '\t') continue;
                    if (c != '\n') break;
                    cutoff = i;
                }
                if (cutoff > 0) {
                    text2 = text2.substring(0, cutoff);
                }
            }
            String replacementText = text2 + "</" + element.getText() + ">";
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)project2);
            XmlTag newTag = factory.createHTMLTagFromText(replacementText);
            PsiElement child = parent.getLastChild().copy();
            CodeStyleManager.getInstance((Project)project2).performActionWithFormatterDisabled(() -> {
                PsiElement grandChild;
                PsiElement replacement = parent.replace((PsiElement)newTag);
                if (child instanceof XmlText && (grandChild = child.getLastChild()) instanceof PsiWhiteSpace) {
                    XmlTag dummyTag = factory.createHTMLTagFromText("<dummy>" + grandChild.getText() + "</dummy>");
                    XmlText whitespace = (XmlText)PsiTreeUtil.getChildOfType((PsiElement)dummyTag, XmlText.class);
                    assert (whitespace != null);
                    replacement.getParent().addAfter((PsiElement)whitespace, replacement);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection$MissingClosingTagFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlMissingClosingTagInspection$MissingClosingTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

