/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefParameterImpl
extends RefJavaElementImpl
implements RefParameter {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final String VALUE_UNDEFINED = "#";
    private final short myIndex;
    private String myActualValueTemplate;

    RefParameterImpl(PsiParameter parameter2, int index, RefManager manager) {
        super((PsiModifierListOwner)parameter2, manager);
        this.myIndex = (short)index;
        this.myActualValueTemplate = VALUE_UNDEFINED;
        RefElementImpl owner2 = (RefElementImpl)manager.getReference(PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiMethod.class));
        if (owner2 != null) {
            owner2.add(this);
        }
    }

    public void parameterReferenced(boolean forWriting) {
        if (forWriting) {
            this.setUsedForWriting();
        } else {
            this.setUsedForReading();
        }
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading() {
        this.setFlag(true, 65536L);
    }

    public PsiParameter getElement() {
        return (PsiParameter)super.getElement();
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting() {
        this.setFlag(true, 131072L);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefParameterImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    RefParameterImpl.$$$reportNull$$$0(1);
                }
                ((RefJavaVisitor)visitor).visitParameter((RefParameter)this);
            });
        } else {
            super.accept(visitor);
        }
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public void buildReferences() {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        PsiParameter parameter2 = this.getElement();
        if (parameter2 != null) {
            refUtil.addReferences((PsiModifierListOwner)parameter2, (RefJavaElement)this, (PsiElement)parameter2.getModifierList());
        }
    }

    void updateTemplateValue(PsiExpression expression2) {
        PsiField psiField;
        PsiReferenceExpression referenceExpression;
        PsiElement resolved;
        if (this.myActualValueTemplate == null) {
            return;
        }
        String newTemplate = null;
        if (expression2 instanceof PsiLiteralExpression) {
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)expression2;
            newTemplate = psiLiteralExpression.getText();
        } else if (expression2 instanceof PsiReferenceExpression && (resolved = (referenceExpression = (PsiReferenceExpression)expression2).resolve()) instanceof PsiField && (psiField = (PsiField)resolved).hasModifierProperty("static") && psiField.hasModifierProperty("final") && psiField.getContainingClass().getQualifiedName() != null) {
            newTemplate = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            this.myActualValueTemplate = newTemplate;
        } else if (!Comparing.equal((String)this.myActualValueTemplate, (String)newTemplate)) {
            this.myActualValueTemplate = null;
        }
    }

    public String getActualValueIfSame() {
        if (this.myActualValueTemplate == VALUE_UNDEFINED) {
            return null;
        }
        return this.myActualValueTemplate;
    }

    @Override
    protected void initialize() {
    }

    @Override
    public String getExternalName() {
        String[] result2 = new String[1];
        Runnable runnable2 = () -> {
            PsiParameter parameter2 = this.getElement();
            LOG.assertTrue(parameter2 != null);
            result2[0] = PsiFormatUtil.getExternalName((PsiModifierListOwner)parameter2);
        };
        ApplicationManager.getApplication().runReadAction(runnable2);
        return result2[0];
    }

    @Nullable
    static RefElement parameterFromExternalName(RefManager manager, String fqName) {
        String method;
        RefMethod refMethod;
        int idx = fqName.lastIndexOf(32);
        if (idx > 0 && (refMethod = RefMethodImpl.methodFromExternalName(manager, method = fqName.substring(0, idx))) != null) {
            PsiMethod element = (PsiMethod)refMethod.getElement();
            PsiParameterList list2 = element.getParameterList();
            PsiParameter[] parameters2 = list2.getParameters();
            int paramIdx = 0;
            String paramName = fqName.substring(idx + 1);
            for (PsiParameter parameter2 : parameters2) {
                String name2 = parameter2.getName();
                if (name2 != null && name2.equals(paramName)) {
                    return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getParameterReference(parameter2, paramIdx);
                }
                ++paramIdx;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "visitor";
        objectArray2[1] = "com/intellij/codeInspection/reference/RefParameterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$accept$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

