/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class CountMigration
extends BaseStreamApiMigration {
    CountMigration(boolean shouldWarn) {
        super(shouldWarn, "count()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiExpression operand2;
        PsiExpression expression2;
        if (project2 == null) {
            CountMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            CountMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            CountMigration.$$$reportNull$$$0(2);
        }
        if ((expression2 = tb.getSingleExpression(PsiExpression.class)) == null) {
            expression2 = tb.getCountExpression();
        }
        if (!((operand2 = StreamApiMigrationInspection.extractIncrementedLValue(expression2)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand2).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        return CountMigration.replaceWithOperation(tb.getStreamSourceStatement(), (PsiVariable)var, tb.generate() + ".count()", (PsiType)PsiType.LONG, OperationReductionMigration.SUM_OPERATION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/CountMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

