/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConvertToLocalQuickFix<V extends PsiVariable>
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance(BaseConvertToLocalQuickFix.class);

    @NotNull
    public final String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.convert.to.local.quickfix", (Object[])new Object[0]);
        if (string == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public final void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        V variable;
        if (project2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(2);
        }
        if ((variable = this.getVariable(descriptor2)) == null || !variable.isValid()) {
            return;
        }
        PsiFile myFile = variable.getContainingFile();
        try {
            PsiElement newDeclaration = this.moveDeclaration(project2, variable);
            if (newDeclaration == null) {
                return;
            }
            BaseConvertToLocalQuickFix.positionCaretToDeclaration(project2, myFile, newDeclaration);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    protected abstract V getVariable(@NotNull ProblemDescriptor var1);

    protected static void positionCaretToDeclaration(@NotNull Project project2, @NotNull PsiFile psiFile, @NotNull PsiElement declaration2) {
        PsiFile openedFile;
        Editor editor;
        if (project2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(4);
        }
        if (declaration2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(5);
        }
        if ((editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor()) != null && (IJSwingUtilities.hasFocus(editor.getComponent()) || ApplicationManager.getApplication().isUnitTestMode()) && (openedFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) == psiFile) {
            editor.getCaretModel().moveToOffset(declaration2.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected void beforeDelete(@NotNull Project project2, @NotNull V variable, @NotNull PsiElement newDeclaration) {
        if (project2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(6);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(7);
        }
        if (newDeclaration == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    protected PsiElement moveDeclaration(@NotNull Project project2, @NotNull V variable) {
        Collection references;
        if (project2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(9);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(10);
        }
        if ((references = ReferencesSearch.search(variable).findAll()).isEmpty()) {
            return null;
        }
        return this.moveDeclaration(project2, variable, references, true);
    }

    protected PsiElement moveDeclaration(Project project2, V variable, Collection<PsiReference> references, boolean delete) {
        PsiCodeBlock anchorBlock = BaseConvertToLocalQuickFix.findAnchorBlock(references);
        if (anchorBlock == null) {
            return null;
        }
        PsiElement firstElement = BaseConvertToLocalQuickFix.getLowestOffsetElement(references);
        String localName = this.suggestLocalName(project2, variable, anchorBlock);
        PsiElement anchor = BaseConvertToLocalQuickFix.getAnchorElement(anchorBlock, firstElement);
        PsiAssignmentExpression anchorAssignmentExpression = BaseConvertToLocalQuickFix.searchAssignmentExpression(anchor);
        if (anchorAssignmentExpression != null && BaseConvertToLocalQuickFix.isVariableAssignment(anchorAssignmentExpression, variable)) {
            HashSet refsSet = new HashSet(references);
            refsSet.remove(anchorAssignmentExpression.getLExpression());
            return this.applyChanges(project2, localName, anchorAssignmentExpression.getRExpression(), variable, (Collection<PsiReference>)refsSet, delete, (NotNullFunction<PsiDeclarationStatement, PsiElement>)((NotNullFunction)declaration2 -> {
                if (!BaseConvertToLocalQuickFix.mayBeFinal(firstElement, references)) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiModifierListOwner)declaration2.getDeclaredElements()[0]), (String)"final", (boolean)false);
                }
                return anchor.replace((PsiElement)declaration2);
            }));
        }
        return this.applyChanges(project2, localName, variable.getInitializer(), variable, references, delete, (NotNullFunction<PsiDeclarationStatement, PsiElement>)((NotNullFunction)declaration2 -> anchorBlock.addBefore((PsiElement)declaration2, anchor)));
    }

    protected PsiElement applyChanges(@NotNull Project project2, @NotNull String localName, @Nullable PsiExpression initializer, @NotNull V variable, @NotNull Collection<PsiReference> references, boolean delete, @NotNull NotNullFunction<PsiDeclarationStatement, PsiElement> action) {
        if (project2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(11);
        }
        if (localName == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(12);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(13);
        }
        if (references == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(14);
        }
        if (action == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(15);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        return (PsiElement)WriteAction.compute(() -> {
            if (localName == null) {
                BaseConvertToLocalQuickFix.$$$reportNull$$$0(21);
            }
            if (variable == null) {
                BaseConvertToLocalQuickFix.$$$reportNull$$$0(22);
            }
            if (action == null) {
                BaseConvertToLocalQuickFix.$$$reportNull$$$0(23);
            }
            if (references == null) {
                BaseConvertToLocalQuickFix.$$$reportNull$$$0(24);
            }
            if (project2 == null) {
                BaseConvertToLocalQuickFix.$$$reportNull$$$0(25);
            }
            PsiElement newDeclaration = this.moveDeclaration(elementFactory, localName, variable, initializer, action, references);
            if (delete) {
                this.beforeDelete(project2, variable, newDeclaration);
                variable.normalizeDeclaration();
                variable.delete();
            }
            return newDeclaration;
        });
    }

    protected PsiElement moveDeclaration(PsiElementFactory elementFactory, String localName, V variable, PsiExpression initializer, NotNullFunction<PsiDeclarationStatement, PsiElement> action, Collection<PsiReference> references) {
        PsiDeclarationStatement declaration2 = elementFactory.createVariableDeclarationStatement(localName, variable.getType(), initializer);
        PsiElement newDeclaration = (PsiElement)action.fun((Object)declaration2);
        BaseConvertToLocalQuickFix.retargetReferences(elementFactory, localName, references);
        return newDeclaration;
    }

    @Nullable
    private static PsiAssignmentExpression searchAssignmentExpression(@Nullable PsiElement anchor) {
        if (!(anchor instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression anchorExpression = ((PsiExpressionStatement)anchor).getExpression();
        if (!(anchorExpression instanceof PsiAssignmentExpression)) {
            return null;
        }
        return (PsiAssignmentExpression)anchorExpression;
    }

    private static boolean isVariableAssignment(@NotNull PsiAssignmentExpression expression2, @NotNull PsiVariable variable) {
        if (expression2 == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(16);
        }
        if (variable == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(17);
        }
        if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
            return false;
        }
        if (!(expression2.getLExpression() instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression leftExpression = (PsiReferenceExpression)expression2.getLExpression();
        return leftExpression.isReferenceTo((PsiElement)variable);
    }

    @NotNull
    protected abstract String suggestLocalName(@NotNull Project var1, @NotNull V var2, @NotNull PsiCodeBlock var3);

    private static boolean mayBeFinal(PsiElement firstElement, @NotNull Collection<PsiReference> references) {
        if (references == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(18);
        }
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (element == firstElement || !(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) continue;
            return false;
        }
        return true;
    }

    private static void retargetReferences(PsiElementFactory elementFactory, String localName, Collection<PsiReference> refs) throws IncorrectOperationException {
        PsiReferenceExpression refExpr = (PsiReferenceExpression)elementFactory.createExpressionFromText(localName, null);
        for (PsiReference ref : refs) {
            if (!(ref instanceof PsiReferenceExpression)) continue;
            ((PsiReferenceExpression)ref).replace((PsiElement)refExpr);
        }
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock anchorBlock, @NotNull PsiElement firstElement) {
        PsiElement element;
        if (firstElement == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(19);
        }
        for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
        }
        return element;
    }

    @Nullable
    private static PsiElement getLowestOffsetElement(@NotNull Collection<PsiReference> refs) {
        if (refs == null) {
            BaseConvertToLocalQuickFix.$$$reportNull$$$0(20);
        }
        PsiElement firstElement = null;
        for (PsiReference reference : refs) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiReferenceExpression) || firstElement != null && firstElement.getTextRange().getStartOffset() <= element.getTextRange().getStartOffset()) continue;
            firstElement = element;
        }
        return firstElement;
    }

    private static PsiCodeBlock findAnchorBlock(Collection<PsiReference> refs) {
        PsiCodeBlock result2 = null;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
            if (result2 == null || block == null) {
                result2 = block;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result2, (PsiElement)block);
            result2 = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class, (boolean)false);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeclaration";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localName";
                break;
            }
            case 14: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/BaseConvertToLocalQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "positionCaretToDeclaration";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeDelete";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveDeclaration";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAssignment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mayBeFinal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLowestOffsetElement";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyChanges$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

