/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.xml;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.deprecation.DeprecationInspection;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeprecatedClassUsageInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            DeprecatedClassUsageInspection.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DeprecatedClassUsageInspection.$$$reportNull$$$0(1);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (tag.getValue().getTextElements().length > 0) {
                    DeprecatedClassUsageInspection.checkReferences((PsiElement)tag, holder);
                }
            }

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                DeprecatedClassUsageInspection.checkReferences((PsiElement)value2, holder);
            }
        };
        if (xmlElementVisitor == null) {
            DeprecatedClassUsageInspection.$$$reportNull$$$0(2);
        }
        return xmlElementVisitor;
    }

    private static void checkReferences(PsiElement psiElement, ProblemsHolder holder) {
        Object[] references = psiElement.getReferences();
        PsiReference last = (PsiReference)ArrayUtil.getLastElement((Object[])references);
        if (last != null && (!(last instanceof ResolvingHint) || ((ResolvingHint)last).canResolveTo(PsiDocCommentOwner.class))) {
            PsiElement resolve2 = last.resolve();
            DeprecationInspection.checkDeprecated(resolve2, psiElement, last.getRangeInElement(), holder);
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("XML" == null) {
            DeprecatedClassUsageInspection.$$$reportNull$$$0(3);
        }
        return "XML";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Deprecated API usage in XML" == null) {
            DeprecatedClassUsageInspection.$$$reportNull$$$0(4);
        }
        return "Deprecated API usage in XML";
    }

    @NotNull
    public String getShortName() {
        if ("DeprecatedClassUsageInspection" == null) {
            DeprecatedClassUsageInspection.$$$reportNull$$$0(5);
        }
        return "DeprecatedClassUsageInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

