/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.serialization.java.compiler.AnnotationProcessorProfileSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;

@com.intellij.openapi.components.State(name="CompilerConfiguration", storages={@Storage(value="compiler.xml")})
public class CompilerConfigurationImpl
extends CompilerConfiguration
implements PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.CompilerConfiguration");
    public static final String TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME = "tests.external.compiler.home";
    public static final int DEFAULT_BUILD_PROCESS_HEAP_SIZE = 700;
    private BackendCompiler myDefaultJavaCompiler;
    private State myState = new State();
    private final List<Pattern> myRegexpResourcePatterns = new ArrayList<Pattern>();
    private final List<String> myWildcardPatterns = new ArrayList<String>();
    private final List<CompiledPattern> myCompiledPatterns = new ArrayList<CompiledPattern>();
    private final List<CompiledPattern> myNegatedCompiledPatterns = new ArrayList<CompiledPattern>();
    private boolean myWildcardPatternsInitialized = false;
    private final Project myProject;
    private final ExcludedEntriesConfiguration myExcludesConfiguration;
    private final Collection<BackendCompiler> myRegisteredCompilers = new ArrayList<BackendCompiler>();
    private JavacCompiler JAVAC_EXTERNAL_BACKEND;
    private final Perl5Matcher myPatternMatcher = new Perl5Matcher();
    private boolean myAddNotNullAssertions;
    private final ProcessorConfigProfile myDefaultProcessorsProfile;
    private final List<ProcessorConfigProfile> myModuleProcessorProfiles;
    private Map<Module, ProcessorConfigProfile> myProcessorsProfilesMap;
    @Nullable
    private String myBytecodeTargetLevel;
    private final Map<String, String> myModuleBytecodeTarget;

    public CompilerConfigurationImpl(Project project2) {
        this.loadDefaultWildcardPatterns();
        this.myAddNotNullAssertions = true;
        this.myDefaultProcessorsProfile = new ProcessorConfigProfileImpl("Default");
        this.myModuleProcessorProfiles = new ArrayList<ProcessorConfigProfile>();
        this.myProcessorsProfilesMap = null;
        this.myBytecodeTargetLevel = null;
        this.myModuleBytecodeTarget = new HashMap<String, String>();
        this.myProject = project2;
        this.myExcludesConfiguration = this.createExcludedEntriesConfiguration(project2);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                CompilerConfigurationImpl.this.getAnnotationProcessingConfiguration(module2).removeModuleName(module2.getName());
            }

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (module2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                CompilerConfigurationImpl.this.myProcessorsProfilesMap = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeModuleRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected ExcludedEntriesConfiguration createExcludedEntriesConfiguration(final @NotNull Project project2) {
        if (project2 == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(0);
        }
        ExcludedEntriesConfiguration cfg = new ExcludedEntriesConfiguration((ExcludedEntriesListener)project2.getMessageBus().syncPublisher(ExcludedEntriesListener.TOPIC));
        Disposer.register((Disposable)project2, (Disposable)cfg);
        project2.getMessageBus().connect().subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

            public void onEntryAdded(@NotNull ExcludeEntryDescription description) {
                if (description == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.clearState();
            }

            public void onEntryRemoved(@NotNull ExcludeEntryDescription description) {
                if (description == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.clearState();
            }

            private void clearState() {
                if (project2.isOpen()) {
                    BuildManager.getInstance().clearState(project2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "description";
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEntryAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEntryRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExcludedEntriesConfiguration excludedEntriesConfiguration = cfg;
        if (excludedEntriesConfiguration == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(1);
        }
        return excludedEntriesConfiguration;
    }

    public Element getState() {
        Element state = new Element("state");
        XmlSerializer.serializeInto((Object)this.myState, (Element)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (accessor == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (bean == null) {
                    3.$$$reportNull$$$0(1);
                }
                return super.accepts(accessor, bean);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "accessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bean";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/compiler/CompilerConfigurationImpl$3";
                objectArray[2] = "accepts";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!this.myAddNotNullAssertions) {
            CompilerConfigurationImpl.addChild(state, "addNotNullAssertions").setAttribute("enabled", String.valueOf(this.myAddNotNullAssertions));
        }
        if (this.myExcludesConfiguration.getExcludeEntryDescriptions().length > 0) {
            this.myExcludesConfiguration.writeExternal(CompilerConfigurationImpl.addChild(state, "excludeFromCompile"));
        }
        Element resourceExtensions = new Element("resourceExtensions");
        for (String pattern : this.getRegexpPatterns()) {
            CompilerConfigurationImpl.addChild(resourceExtensions, "entry").setAttribute("name", pattern);
        }
        if (!JDOMUtil.isEmpty((Element)resourceExtensions)) {
            state.addContent(resourceExtensions);
        }
        if (!(!this.myWildcardPatternsInitialized && this.myWildcardPatterns.isEmpty() || JpsJavaCompilerConfigurationSerializer.DEFAULT_WILDCARD_PATTERNS.equals(this.myWildcardPatterns))) {
            Element wildcardPatterns = CompilerConfigurationImpl.addChild(state, "wildcardResourcePatterns");
            for (String wildcardPattern : this.myWildcardPatterns) {
                CompilerConfigurationImpl.addChild(wildcardPatterns, "entry").setAttribute("name", wildcardPattern);
            }
        }
        Element annotationProcessingSettings = new Element("annotationProcessing");
        Element profileElement = new Element("profile");
        profileElement.setAttribute("default", "true");
        AnnotationProcessorProfileSerializer.writeExternal((ProcessorConfigProfile)this.myDefaultProcessorsProfile, (Element)profileElement);
        if (!JDOMUtil.isEmpty((Element)profileElement, (int)2)) {
            annotationProcessingSettings.addContent(profileElement);
        }
        for (ProcessorConfigProfile profile2 : this.myModuleProcessorProfiles) {
            Element element = new Element("profile");
            AnnotationProcessorProfileSerializer.writeExternal((ProcessorConfigProfile)profile2, (Element)element);
            annotationProcessingSettings.addContent(element);
        }
        if (!JDOMUtil.isEmpty((Element)annotationProcessingSettings)) {
            state.addContent(annotationProcessingSettings);
        }
        if (!StringUtil.isEmpty((String)this.myBytecodeTargetLevel) || !this.myModuleBytecodeTarget.isEmpty()) {
            Element bytecodeTarget = CompilerConfigurationImpl.addChild(state, "bytecodeTargetLevel");
            if (!StringUtil.isEmpty((String)this.myBytecodeTargetLevel)) {
                bytecodeTarget.setAttribute("target", this.myBytecodeTargetLevel);
            }
            if (!this.myModuleBytecodeTarget.isEmpty()) {
                ArrayList<String> moduleNames = new ArrayList<String>(this.myModuleBytecodeTarget.keySet());
                Collections.sort(moduleNames, String.CASE_INSENSITIVE_ORDER);
                for (String name2 : moduleNames) {
                    Element moduleElement = CompilerConfigurationImpl.addChild(bytecodeTarget, "module");
                    moduleElement.setAttribute("name", name2);
                    String value2 = this.myModuleBytecodeTarget.get(name2);
                    moduleElement.setAttribute("target", value2 != null ? value2 : "");
                }
            }
        }
        return state;
    }

    public void loadState(Element state) {
        this.readExternal(state);
    }

    public int getBuildProcessHeapSize(int javacPreferredHeapSize) {
        int heapSize = this.myState.BUILD_PROCESS_HEAP_SIZE;
        if (heapSize != 700) {
            return heapSize;
        }
        return Math.max(heapSize, javacPreferredHeapSize);
    }

    public void setBuildProcessHeapSize(int size) {
        this.myState.BUILD_PROCESS_HEAP_SIZE = size > 0 ? size : 700;
    }

    public String getBuildProcessVMOptions() {
        return this.myState.BUILD_PROCESS_ADDITIONAL_VM_OPTIONS;
    }

    public void setBuildProcessVMOptions(String options) {
        this.myState.BUILD_PROCESS_ADDITIONAL_VM_OPTIONS = options == null ? "" : options.trim();
    }

    public void setProjectBytecodeTarget(@Nullable String level) {
        String previous = this.myBytecodeTargetLevel;
        this.myBytecodeTargetLevel = level;
        if (!this.myProject.isDefault() && !Comparing.equal((String)previous, (String)level)) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        return this.myBytecodeTargetLevel;
    }

    public void setModulesBytecodeTargetMap(@NotNull Map<String, String> mapping) {
        if (mapping == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(2);
        }
        boolean shouldNotify = !this.myProject.isDefault() && !this.myModuleBytecodeTarget.equals(mapping);
        this.myModuleBytecodeTarget.clear();
        this.myModuleBytecodeTarget.putAll(mapping);
        if (shouldNotify) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        return this.myModuleBytecodeTarget;
    }

    public void setBytecodeTargetLevel(Module module2, String level) {
        Project project2;
        String previous = StringUtil.isEmpty((String)level) ? this.myModuleBytecodeTarget.remove(module2.getName()) : this.myModuleBytecodeTarget.put(module2.getName(), level);
        if (!Comparing.equal((String)previous, (String)level) && !(project2 = module2.getProject()).isDefault()) {
            BuildManager.getInstance().clearState(project2);
        }
    }

    @Nullable
    public String getBytecodeTargetLevel(Module module2) {
        String level = this.myModuleBytecodeTarget.get(module2.getName());
        if (level != null) {
            return level.isEmpty() ? null : level;
        }
        return this.myBytecodeTargetLevel;
    }

    private void loadDefaultWildcardPatterns() {
        if (!this.myWildcardPatterns.isEmpty()) {
            this.removeWildcardPatterns();
        }
        try {
            for (String pattern : JpsJavaCompilerConfigurationSerializer.DEFAULT_WILDCARD_PATTERNS) {
                this.addWildcardResourcePattern(pattern);
            }
        }
        catch (MalformedPatternException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String getTestsExternalCompilerHome() {
        String compilerHome = System.getProperty(TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME, null);
        if (compilerHome == null) {
            File javaHome = new File(System.getProperty("java.home"));
            compilerHome = SystemInfo.isMac || !new File(javaHome.getParentFile(), "bin").exists() ? javaHome.getAbsolutePath() : javaHome.getParentFile().getAbsolutePath();
        }
        return compilerHome;
    }

    private static Pattern compilePattern(@NonNls String s) throws MalformedPatternException {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            return SystemInfo.isFileSystemCaseSensitive ? compiler.compile(s) : compiler.compile(s, 1);
        }
        catch (org.apache.oro.text.regex.MalformedPatternException ex) {
            throw new MalformedPatternException((Throwable)ex);
        }
    }

    public JavacCompiler getJavacCompiler() {
        this.createCompilers();
        return this.JAVAC_EXTERNAL_BACKEND;
    }

    public void projectOpened() {
        this.createCompilers();
    }

    private void createCompilers() {
        if (this.JAVAC_EXTERNAL_BACKEND != null) {
            return;
        }
        this.JAVAC_EXTERNAL_BACKEND = new JavacCompiler(this.myProject);
        this.myRegisteredCompilers.add(this.JAVAC_EXTERNAL_BACKEND);
        if (!ApplicationManager.getApplication().isUnitTestMode() && EclipseCompiler.isInitialized()) {
            EclipseCompiler eclipse = new EclipseCompiler(this.myProject);
            this.myRegisteredCompilers.add(eclipse);
        }
        HashSet<FileType> types = new HashSet<FileType>();
        for (BackendCompiler compiler : (BackendCompiler[])Extensions.getExtensions(BackendCompiler.EP_NAME, (AreaInstance)this.myProject)) {
            this.myRegisteredCompilers.add(compiler);
            types.addAll(compiler.getCompilableFileTypes());
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        for (FileType type2 : types) {
            compilerManager.addCompilableFileType(type2);
        }
        this.myDefaultJavaCompiler = this.JAVAC_EXTERNAL_BACKEND;
        for (BackendCompiler compiler : this.myRegisteredCompilers) {
            if (!compiler.getId().equals(this.myState.DEFAULT_COMPILER)) continue;
            this.myDefaultJavaCompiler = compiler;
            break;
        }
        this.myState.DEFAULT_COMPILER = this.myDefaultJavaCompiler.getId();
    }

    public Collection<BackendCompiler> getRegisteredJavaCompilers() {
        this.createCompilers();
        return this.myRegisteredCompilers;
    }

    public String[] getResourceFilePatterns() {
        return this.getWildcardPatterns();
    }

    private String[] getRegexpPatterns() {
        String[] patterns = ArrayUtil.newStringArray((int)this.myRegexpResourcePatterns.size());
        int index = 0;
        for (Pattern myRegexpResourcePattern : this.myRegexpResourcePatterns) {
            patterns[index++] = myRegexpResourcePattern.getPattern();
        }
        return patterns;
    }

    private String[] getWildcardPatterns() {
        return ArrayUtil.toStringArray(this.myWildcardPatterns);
    }

    public void addResourceFilePattern(String namePattern) throws MalformedPatternException {
        this.addWildcardResourcePattern(namePattern);
    }

    private void addRegexpPattern(String namePattern) throws MalformedPatternException {
        Pattern pattern = CompilerConfigurationImpl.compilePattern(namePattern);
        if (pattern != null) {
            this.myRegexpResourcePatterns.add(pattern);
        }
    }

    public ExcludesConfiguration getExcludedEntriesConfiguration() {
        return this.myExcludesConfiguration;
    }

    public boolean isExcludedFromCompilation(VirtualFile virtualFile) {
        return this.myExcludesConfiguration.isExcluded(virtualFile);
    }

    public boolean isResourceFile(VirtualFile virtualFile) {
        return this.isResourceFile(virtualFile.getName(), virtualFile.getParent());
    }

    public boolean isAddNotNullAssertions() {
        return this.myAddNotNullAssertions;
    }

    public void setAddNotNullAssertions(boolean enabled) {
        this.myAddNotNullAssertions = enabled;
    }

    @NotNull
    public ProcessorConfigProfile getDefaultProcessorProfile() {
        ProcessorConfigProfile processorConfigProfile = this.myDefaultProcessorsProfile;
        if (processorConfigProfile == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(3);
        }
        return processorConfigProfile;
    }

    public void setDefaultProcessorProfile(ProcessorConfigProfile profile2) {
        this.myDefaultProcessorsProfile.initFrom(profile2);
    }

    @NotNull
    public List<ProcessorConfigProfile> getModuleProcessorProfiles() {
        List<ProcessorConfigProfile> list2 = this.myModuleProcessorProfiles;
        if (list2 == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void setModuleProcessorProfiles(Collection<ProcessorConfigProfile> moduleProfiles) {
        this.myModuleProcessorProfiles.clear();
        this.myModuleProcessorProfiles.addAll(moduleProfiles);
        this.myProcessorsProfilesMap = null;
    }

    @Nullable
    public ProcessorConfigProfile findModuleProcessorProfile(@NotNull String name2) {
        if (name2 == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(5);
        }
        for (ProcessorConfigProfile profile2 : this.myModuleProcessorProfiles) {
            if (!name2.equals(profile2.getName())) continue;
            return profile2;
        }
        return null;
    }

    public void removeModuleProcessorProfile(ProcessorConfigProfile profile2) {
        this.myModuleProcessorProfiles.remove(profile2);
        this.myProcessorsProfilesMap = null;
    }

    public void addModuleProcessorProfile(@NotNull ProcessorConfigProfile profile2) {
        if (profile2 == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(6);
        }
        this.myModuleProcessorProfiles.add(profile2);
        this.myProcessorsProfilesMap = null;
    }

    @NotNull
    public ProcessorConfigProfile getAnnotationProcessingConfiguration(Module module2) {
        ProcessorConfigProfile profile2;
        Map<Module, ProcessorConfigProfile> map = this.myProcessorsProfilesMap;
        if (map == null) {
            map = new HashMap<Module, ProcessorConfigProfile>();
            HashMap<String, Module> namesMap = new HashMap<String, Module>();
            for (Module m : ModuleManager.getInstance((Project)module2.getProject()).getModules()) {
                namesMap.put(m.getName(), m);
            }
            if (!namesMap.isEmpty()) {
                for (ProcessorConfigProfile profile3 : this.myModuleProcessorProfiles) {
                    for (String name2 : profile3.getModuleNames()) {
                        Module mod = (Module)namesMap.get(name2);
                        if (mod == null) continue;
                        map.put(mod, profile3);
                    }
                }
            }
            this.myProcessorsProfilesMap = map;
        }
        ProcessorConfigProfile processorConfigProfile = (profile2 = map.get(module2)) != null ? profile2 : this.myDefaultProcessorsProfile;
        if (processorConfigProfile == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(7);
        }
        return processorConfigProfile;
    }

    public boolean isAnnotationProcessorsEnabled() {
        if (this.myDefaultProcessorsProfile.isEnabled()) {
            return true;
        }
        for (ProcessorConfigProfile profile2 : this.myModuleProcessorProfiles) {
            if (!profile2.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void addWildcardResourcePattern(@NonNls String wildcardPattern) throws MalformedPatternException {
        CompiledPattern pattern = CompilerConfigurationImpl.convertToRegexp(wildcardPattern);
        this.myWildcardPatterns.add(wildcardPattern);
        if (CompilerConfigurationImpl.isPatternNegated(wildcardPattern)) {
            this.myNegatedCompiledPatterns.add(pattern);
        } else {
            this.myCompiledPatterns.add(pattern);
        }
    }

    public void removeResourceFilePatterns() {
        this.removeWildcardPatterns();
    }

    private void removeRegexpPatterns() {
        this.myRegexpResourcePatterns.clear();
    }

    private void removeWildcardPatterns() {
        this.myWildcardPatterns.clear();
        this.myCompiledPatterns.clear();
        this.myNegatedCompiledPatterns.clear();
    }

    private static CompiledPattern convertToRegexp(String wildcardPattern) {
        if (CompilerConfigurationImpl.isPatternNegated(wildcardPattern)) {
            wildcardPattern = wildcardPattern.substring(1);
        }
        wildcardPattern = FileUtil.toSystemIndependentName((String)wildcardPattern);
        String srcRoot = null;
        int colon = wildcardPattern.indexOf(":");
        if (colon > 0) {
            srcRoot = wildcardPattern.substring(0, colon);
            wildcardPattern = wildcardPattern.substring(colon + 1);
        }
        String dirPattern = null;
        int slash = wildcardPattern.lastIndexOf(47);
        if (slash >= 0) {
            dirPattern = wildcardPattern.substring(0, slash + 1);
            wildcardPattern = wildcardPattern.substring(slash + 1);
            if (!dirPattern.startsWith("/")) {
                dirPattern = "/" + dirPattern;
            }
            dirPattern = CompilerConfigurationImpl.normalizeWildcards(dirPattern);
            dirPattern = StringUtil.replace((String)dirPattern, (String)"/.*.*/", (String)"(/.*)?/");
            dirPattern = StringUtil.trimEnd((String)dirPattern, (String)"/");
            dirPattern = CompilerConfigurationImpl.optimize(dirPattern);
        }
        wildcardPattern = CompilerConfigurationImpl.normalizeWildcards(wildcardPattern);
        wildcardPattern = CompilerConfigurationImpl.optimize(wildcardPattern);
        Pattern dirCompiled = dirPattern == null ? null : CompilerConfigurationImpl.compilePattern(dirPattern);
        Pattern srcCompiled = srcRoot == null ? null : CompilerConfigurationImpl.compilePattern(CompilerConfigurationImpl.optimize(CompilerConfigurationImpl.normalizeWildcards(srcRoot)));
        return new CompiledPattern(CompilerConfigurationImpl.compilePattern(wildcardPattern), dirCompiled, srcCompiled);
    }

    private static String optimize(String wildcardPattern) {
        return wildcardPattern.replaceAll("(?:\\.\\*)+", ".*");
    }

    private static String normalizeWildcards(String wildcardPattern) {
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"\\!", (String)"!");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)".", (String)"\\.");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*?", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?*", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*", (String)".*");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?", (String)".");
        return wildcardPattern;
    }

    public static boolean isPatternNegated(String wildcardPattern) {
        return wildcardPattern.length() > 1 && wildcardPattern.charAt(0) == '!';
    }

    public boolean isResourceFile(String name2) {
        return this.isResourceFile(name2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matches(String s, Pattern p) {
        Perl5Matcher perl5Matcher = this.myPatternMatcher;
        synchronized (perl5Matcher) {
            try {
                return this.myPatternMatcher.matches(s, p);
            }
            catch (Exception e) {
                LOG.error("Exception matching file name \"" + s + "\" against the pattern \"" + p + "\"", (Throwable)e);
                return false;
            }
        }
    }

    private boolean isResourceFile(String name2, @Nullable VirtualFile parent) {
        int i;
        Ref parentRef = Ref.create(null);
        for (i = 0; i < this.myCompiledPatterns.size(); ++i) {
            if (!this.matches(name2, parent, (Ref<String>)parentRef, this.myCompiledPatterns.get(i))) continue;
            return true;
        }
        if (this.myNegatedCompiledPatterns.isEmpty()) {
            return false;
        }
        for (i = 0; i < this.myNegatedCompiledPatterns.size(); ++i) {
            if (!this.matches(name2, parent, (Ref<String>)parentRef, this.myNegatedCompiledPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(String name2, VirtualFile parent, Ref<String> parentRef, CompiledPattern pair2) {
        if (!this.matches(name2, pair2.fileName)) {
            return false;
        }
        if (parent != null && (pair2.dir != null || pair2.srcRoot != null)) {
            VirtualFile srcRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getSourceRootForFile(parent);
            if (pair2.dir != null) {
                String parentPath = (String)parentRef.get();
                if (parentPath == null) {
                    parentPath = srcRoot == null ? parent.getPath() : VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)srcRoot, (char)'/');
                    parentRef.set((Object)parentPath);
                }
                if (parentPath == null || !this.matches("/" + parentPath, pair2.dir)) {
                    return false;
                }
            }
            if (pair2.srcRoot != null) {
                String srcRootName;
                String string = srcRootName = srcRoot == null ? null : srcRoot.getName();
                if (srcRootName == null || !this.matches(srcRootName, pair2.srcRoot)) {
                    return false;
                }
            }
        }
        return true;
    }

    public void readExternal(@NotNull Element parentNode) {
        Element node;
        Element notNullAssertions;
        if (parentNode == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(8);
        }
        this.myState = (State)XmlSerializer.deserialize((Element)parentNode, State.class);
        if (!this.myProject.isDefault()) {
            Element option;
            Iterator iterator = parentNode.getChildren("option").iterator();
            while (iterator.hasNext() && !"DEFAULT_COMPILER".equals((option = (Element)iterator.next()).getAttributeValue("name"))) {
            }
            if (this.myState.BUILD_PROCESS_HEAP_SIZE == 700) {
                CompilerWorkspaceConfiguration workspace = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
                this.myState.BUILD_PROCESS_HEAP_SIZE = workspace.COMPILER_PROCESS_HEAP_SIZE;
            }
        }
        if ((notNullAssertions = parentNode.getChild("addNotNullAssertions")) != null) {
            this.myAddNotNullAssertions = Boolean.valueOf(notNullAssertions.getAttributeValue("enabled", "true"));
        }
        if ((node = parentNode.getChild("excludeFromCompile")) != null) {
            this.myExcludesConfiguration.readExternal(node);
        }
        try {
            this.removeRegexpPatterns();
            node = parentNode.getChild("resourceExtensions");
            if (node != null) {
                for (Object o : node.getChildren("entry")) {
                    Element element = (Element)o;
                    String pattern = element.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)pattern)) continue;
                    this.addRegexpPattern(pattern);
                }
            }
            if ((node = parentNode.getChild("wildcardResourcePatterns")) != null) {
                this.myWildcardPatternsInitialized = true;
                this.removeWildcardPatterns();
                for (Element element : node.getChildren("entry")) {
                    String pattern = element.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)pattern)) continue;
                    this.addWildcardResourcePattern(pattern);
                }
            }
        }
        catch (MalformedPatternException e) {
            LOG.error((Throwable)e);
        }
        this.myModuleProcessorProfiles.clear();
        this.myProcessorsProfilesMap = null;
        Element annotationProcessingSettings = parentNode.getChild("annotationProcessing");
        if (annotationProcessingSettings != null) {
            List profiles = annotationProcessingSettings.getChildren("profile");
            if (!profiles.isEmpty()) {
                for (Object elem : profiles) {
                    Element profileElement = (Element)elem;
                    boolean isDefault = "true".equals(profileElement.getAttributeValue("default"));
                    if (isDefault) {
                        AnnotationProcessorProfileSerializer.readExternal((ProcessorConfigProfile)this.myDefaultProcessorsProfile, (Element)profileElement);
                        continue;
                    }
                    ProcessorConfigProfileImpl profile2 = new ProcessorConfigProfileImpl("");
                    AnnotationProcessorProfileSerializer.readExternal((ProcessorConfigProfile)profile2, (Element)profileElement);
                    this.myModuleProcessorProfiles.add((ProcessorConfigProfile)profile2);
                }
            } else {
                this.loadProfilesFromOldFormat(annotationProcessingSettings);
            }
        }
        this.myBytecodeTargetLevel = null;
        this.myModuleBytecodeTarget.clear();
        Element bytecodeTargetElement = parentNode.getChild("bytecodeTargetLevel");
        if (bytecodeTargetElement != null) {
            this.myBytecodeTargetLevel = bytecodeTargetElement.getAttributeValue("target");
            for (Object elem : bytecodeTargetElement.getChildren("module")) {
                String target2;
                String name2 = elem.getAttributeValue("name");
                if (name2 == null || (target2 = elem.getAttributeValue("target")) == null) continue;
                this.myModuleBytecodeTarget.put(name2, target2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadProfilesFromOldFormat(Element processing) {
        boolean isEnabled = Boolean.parseBoolean(processing.getAttributeValue("enabled", "false"));
        boolean isUseClasspath = Boolean.parseBoolean(processing.getAttributeValue("useClasspath", "true"));
        StringBuilder processorPath = new StringBuilder();
        HashSet<String> optionPairs = new HashSet<String>();
        HashSet<String> processors = new HashSet<String>();
        ArrayList<Couple> modulesToProcess = new ArrayList<Couple>();
        for (Object e : processing.getChildren("processorPath")) {
            Element pathElement = (Element)e;
            String path = pathElement.getAttributeValue("value", (String)null);
            if (path == null) continue;
            if (processorPath.length() > 0) {
                processorPath.append(File.pathSeparator);
            }
            processorPath.append(path);
        }
        for (Object e : processing.getChildren("processor")) {
            Element processorElement = (Element)e;
            String proc = processorElement.getAttributeValue("name", (String)null);
            if (proc != null) {
                processors.add(proc);
            }
            StringTokenizer tokenizer = new StringTokenizer(processorElement.getAttributeValue("options", ""), " ", false);
            while (tokenizer.hasMoreTokens()) {
                String pair2 = tokenizer.nextToken();
                optionPairs.add(pair2);
            }
        }
        for (Object e : processing.getChildren("processModule")) {
            Element moduleElement = (Element)e;
            String name2 = moduleElement.getAttributeValue("name", (String)null);
            if (name2 == null) continue;
            String dir = moduleElement.getAttributeValue("generatedDirName", (String)null);
            modulesToProcess.add(Couple.of((Object)name2, (Object)dir));
        }
        this.myDefaultProcessorsProfile.setEnabled(false);
        this.myDefaultProcessorsProfile.setObtainProcessorsFromClasspath(isUseClasspath);
        if (processorPath.length() > 0) {
            this.myDefaultProcessorsProfile.setProcessorPath(processorPath.toString());
        }
        if (!optionPairs.isEmpty()) {
            for (String string : optionPairs) {
                int index = string.indexOf("=");
                if (index <= 0) continue;
                this.myDefaultProcessorsProfile.setOption(string.substring(0, index), string.substring(index + 1));
            }
        }
        for (String string : processors) {
            this.myDefaultProcessorsProfile.addProcessor(string);
        }
        HashMap<String, HashSet<Object>> dirNameToModulesMap = new HashMap<String, HashSet<Object>>();
        for (Couple moduleDirPair : modulesToProcess) {
            String dir = (String)moduleDirPair.getSecond();
            HashSet<Object> set2 = (HashSet<Object>)dirNameToModulesMap.get(dir);
            if (set2 == null) {
                set2 = new HashSet<Object>();
                dirNameToModulesMap.put(dir, set2);
            }
            set2.add(moduleDirPair.getFirst());
        }
        boolean bl = false;
        for (Map.Entry entry : dirNameToModulesMap.entrySet()) {
            void var9_20;
            String dirName = (String)entry.getKey();
            ProcessorConfigProfileImpl profile2 = new ProcessorConfigProfileImpl(this.myDefaultProcessorsProfile);
            profile2.setName("Profile" + (int)(++var9_20));
            profile2.setEnabled(isEnabled);
            profile2.setGeneratedSourcesDirectoryName(dirName, false);
            for (String moduleName : (Set)entry.getValue()) {
                profile2.addModuleName(moduleName);
            }
            this.myModuleProcessorProfiles.add((ProcessorConfigProfile)profile2);
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("CompilerConfiguration" == null) {
            CompilerConfigurationImpl.$$$reportNull$$$0(9);
        }
        return "CompilerConfiguration";
    }

    public BackendCompiler getDefaultCompiler() {
        this.createCompilers();
        return this.myDefaultJavaCompiler;
    }

    public void setDefaultCompiler(BackendCompiler defaultCompiler) {
        this.myDefaultJavaCompiler = defaultCompiler;
        this.myState.DEFAULT_COMPILER = defaultCompiler.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertPatterns() {
        if (!this.needPatternConversion()) {
            return;
        }
        try {
            boolean ok;
            try {
                ok = this.doConvertPatterns();
            }
            catch (MalformedPatternException ignored) {
                ok = false;
            }
            if (!ok) {
                String initialPatternString = CompilerConfigurationImpl.patternsToString(this.getRegexpPatterns());
                String message2 = CompilerBundle.message((String)"message.resource.patterns.format.changed", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), initialPatternString, CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()});
                String wildcardPatterns = Messages.showInputDialog((Project)this.myProject, (String)message2, (String)CompilerBundle.message((String)"pattern.conversion.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon(), (String)initialPatternString, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        StringTokenizer tokenizer = new StringTokenizer(inputString, ";", false);
                        StringBuilder malformedPatterns = new StringBuilder();
                        while (tokenizer.hasMoreTokens()) {
                            String pattern = tokenizer.nextToken();
                            try {
                                CompilerConfigurationImpl.this.addWildcardResourcePattern(pattern);
                            }
                            catch (MalformedPatternException e) {
                                malformedPatterns.append("\n\n");
                                malformedPatterns.append(pattern);
                                malformedPatterns.append(": ");
                                malformedPatterns.append(e.getMessage());
                            }
                        }
                        if (malformedPatterns.length() > 0) {
                            Messages.showErrorDialog((String)CompilerBundle.message((String)"error.bad.resource.patterns", (Object[])new Object[]{malformedPatterns.toString()}), (String)CompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
                            CompilerConfigurationImpl.this.removeWildcardPatterns();
                            return false;
                        }
                        return true;
                    }
                });
                if (wildcardPatterns == null) {
                    this.loadDefaultWildcardPatterns();
                }
            }
        }
        finally {
            this.myWildcardPatternsInitialized = true;
        }
    }

    private boolean needPatternConversion() {
        return !this.myWildcardPatternsInitialized && !this.myRegexpResourcePatterns.isEmpty();
    }

    private boolean doConvertPatterns() throws MalformedPatternException {
        String[] regexpPatterns = this.getRegexpPatterns();
        ArrayList<String> converted = new ArrayList<String>();
        Pattern multipleExtensionsPatternPattern = CompilerConfigurationImpl.compilePattern("\\.\\+\\\\\\.\\((\\w+(?:\\|\\w+)*)\\)");
        Pattern singleExtensionPatternPattern = CompilerConfigurationImpl.compilePattern("\\.\\+\\\\\\.(\\w+)");
        Perl5Matcher matcher = new Perl5Matcher();
        for (String regexpPattern : regexpPatterns) {
            MatchResult match;
            if (matcher.matches(regexpPattern, multipleExtensionsPatternPattern)) {
                match = matcher.getMatch();
                StringTokenizer tokenizer = new StringTokenizer(match.group(1), "|", false);
                while (tokenizer.hasMoreTokens()) {
                    converted.add("?*." + tokenizer.nextToken());
                }
                continue;
            }
            if (matcher.matches(regexpPattern, singleExtensionPatternPattern)) {
                match = matcher.getMatch();
                converted.add("?*." + match.group(1));
                continue;
            }
            return false;
        }
        for (String aConverted : converted) {
            this.addWildcardResourcePattern(aConverted);
        }
        return true;
    }

    private static String patternsToString(String[] patterns) {
        StringBuilder extensionsString = new StringBuilder();
        for (int idx = 0; idx < patterns.length; ++idx) {
            if (idx > 0) {
                extensionsString.append(";");
            }
            extensionsString.append(patterns[idx]);
        }
        return extensionsString.toString();
    }

    public boolean isCompilableResourceFile(Project project2, VirtualFile file2) {
        if (!this.isResourceFile(file2)) {
            return false;
        }
        Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project2).findArtifacts(file2);
        return artifacts.isEmpty();
    }

    private static Element addChild(Element parent, String childName) {
        Element child = new Element(childName);
        parent.addContent(child);
        return child;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerConfigurationImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExcludedEntriesConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProcessorProfile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProcessorProfiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedEntriesConfiguration";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModulesBytecodeTargetMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findModuleProcessorProfile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addModuleProcessorProfile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompiledPattern {
        @NotNull
        final Pattern fileName;
        @Nullable
        final Pattern dir;
        @Nullable
        final Pattern srcRoot;

        private CompiledPattern(@NotNull Pattern fileName, @Nullable Pattern dir, @Nullable Pattern srcRoot) {
            if (fileName == null) {
                CompiledPattern.$$$reportNull$$$0(0);
            }
            this.fileName = fileName;
            this.dir = dir;
            this.srcRoot = srcRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/compiler/CompilerConfigurationImpl$CompiledPattern", "<init>"));
        }
    }

    private static class State {
        public String DEFAULT_COMPILER = "Javac";
        public int BUILD_PROCESS_HEAP_SIZE = 700;
        public String BUILD_PROCESS_ADDITIONAL_VM_OPTIONS = "";

        private State() {
        }
    }
}

