/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Chunk;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GenerationOptionsImpl
extends GenerationOptions {
    private final ReplacePathToMacroMap myMacroReplacementMap;
    private final Map<String, String> myOutputUrlToPropertyRefMap;
    private final ModuleChunk[] myModuleChunks;
    private final Project myProject;
    private final boolean myGenerateIdeaHomeProperty;
    private final String myOutputFileName;
    private Set<String> myJdkUrls;
    private final Set<ChunkCustomCompilerExtension> myCustomCompilers = new HashSet<ChunkCustomCompilerExtension>();
    private final Map<Module, ModuleChunk> myModuleToChunkMap = new HashMap<Module, ModuleChunk>();

    public GenerationOptionsImpl(Project project2, boolean generateSingleFile, boolean enableFormCompiler, boolean backupPreviouslyGeneratedFiles, boolean forceTargetJdk, boolean inlineRuntimeClasspath, boolean generateIdeaHomeProperty, String[] representativeModuleNames, String outputFileName) {
        super(forceTargetJdk, generateSingleFile, enableFormCompiler, backupPreviouslyGeneratedFiles, inlineRuntimeClasspath);
        this.myProject = project2;
        this.myGenerateIdeaHomeProperty = generateIdeaHomeProperty;
        this.myOutputFileName = outputFileName;
        this.myMacroReplacementMap = GenerationOptionsImpl.createReplacementMap();
        this.myModuleChunks = this.createModuleChunks(representativeModuleNames);
        this.myOutputUrlToPropertyRefMap = GenerationOptionsImpl.createOutputUrlToPropertyRefMap(this.myModuleChunks);
    }

    @Deprecated
    public GenerationOptionsImpl(Project project2, boolean generateSingleFile, boolean enableFormCompiler, boolean backupPreviouslyGeneratedFiles, boolean forceTargetJdk, String[] representativeModuleNames) {
        this(project2, forceTargetJdk, generateSingleFile, enableFormCompiler, backupPreviouslyGeneratedFiles, false, false, representativeModuleNames, null);
    }

    public boolean isIdeaHomeGenerated() {
        return this.myGenerateIdeaHomeProperty;
    }

    public String getBuildFileName() {
        return this.getOutputFileName() + ".xml";
    }

    public String getPropertiesFileName() {
        return this.getOutputFileName() + ".properties";
    }

    private String getOutputFileName() {
        if (this.myOutputFileName == null || this.myOutputFileName.length() == 0) {
            return BuildProperties.getProjectBuildFileName((Project)this.myProject);
        }
        return this.myOutputFileName;
    }

    public ModuleChunk getChunkByModule(Module module2) {
        if (this.myModuleToChunkMap.isEmpty()) {
            for (ModuleChunk c : this.myModuleChunks) {
                for (Module m : c.getModules()) {
                    this.myModuleToChunkMap.put(m, c);
                }
            }
        }
        return this.myModuleToChunkMap.get(module2);
    }

    public String subsitutePathWithMacros(String path) {
        return this.myMacroReplacementMap.substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    public String getPropertyRefForUrl(String url) {
        return this.myOutputUrlToPropertyRefMap.get(url);
    }

    private static ReplacePathToMacroMap createReplacementMap() {
        PathMacros pathMacros = PathMacros.getInstance();
        Set macroNames = pathMacros.getUserMacroNames();
        ReplacePathToMacroMap map = new ReplacePathToMacroMap();
        for (String macroName : macroNames) {
            map.put(GenerationUtils.normalizePath((String)pathMacros.getValue(macroName)), BuildProperties.propertyRef((String)BuildProperties.getPathMacroProperty((String)macroName)));
        }
        map.put(GenerationUtils.normalizePath((String)PathManager.getHomePath()), BuildProperties.propertyRef((String)"idea.home"));
        return map;
    }

    private static Map<String, String> createOutputUrlToPropertyRefMap(ModuleChunk[] chunks) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ModuleChunk chunk : chunks) {
            Module[] modules;
            String outputPathRef = BuildProperties.propertyRef((String)BuildProperties.getOutputPathProperty((String)chunk.getName()));
            String testsOutputPathRef = BuildProperties.propertyRef((String)BuildProperties.getOutputPathForTestsProperty((String)chunk.getName()));
            for (Module module2 : modules = chunk.getModules()) {
                String outputPathForTestsUrl;
                String outputPathUrl = CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputUrl();
                if (outputPathUrl != null) {
                    map.put(outputPathUrl, outputPathRef);
                }
                if ((outputPathForTestsUrl = CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputUrlForTests()) == null || outputPathUrl != null && outputPathForTestsUrl.equals(outputPathUrl)) continue;
                map.put(outputPathForTestsUrl, testsOutputPathRef);
            }
        }
        return map;
    }

    public ModuleChunk[] getModuleChunks() {
        return this.myModuleChunks;
    }

    private ModuleChunk[] createModuleChunks(String[] representativeModuleNames) {
        ModuleChunk[] moduleChunks;
        HashSet<String> mainModuleNames = new HashSet<String>(Arrays.asList(representativeModuleNames));
        final Graph chunkGraph = ModuleCompilerUtil.toChunkGraph((Graph)ModuleManager.getInstance((Project)this.myProject).moduleGraph());
        final HashMap<Chunk, ModuleChunk[]> map = new HashMap<Chunk, ModuleChunk[]>();
        final HashMap<ModuleChunk[], Chunk> reverseMap = new HashMap<ModuleChunk[], Chunk>();
        for (Chunk chunk : chunkGraph.getNodes()) {
            Set modules = chunk.getNodes();
            ModuleChunk[] moduleChunk = new ModuleChunk(modules.toArray(new Module[modules.size()]));
            for (Module module2 : modules) {
                if (!mainModuleNames.contains(module2.getName())) continue;
                moduleChunk.setMainModule(module2);
                break;
            }
            map.put(chunk, moduleChunk);
            reverseMap.put(moduleChunk, chunk);
        }
        Graph moduleChunkGraph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<ModuleChunk>(){

            public Collection<ModuleChunk> getNodes() {
                return map.values();
            }

            public Iterator<ModuleChunk> getIn(ModuleChunk n) {
                Chunk chunk = (Chunk)reverseMap.get(n);
                final Iterator in = chunkGraph.getIn((Object)chunk);
                return new Iterator<ModuleChunk>(){

                    @Override
                    public boolean hasNext() {
                        return in.hasNext();
                    }

                    @Override
                    public ModuleChunk next() {
                        return (ModuleChunk)map.get(in.next());
                    }

                    @Override
                    public void remove() {
                        throw new IncorrectOperationException("Method is not supported");
                    }
                };
            }
        }));
        Collection nodes = moduleChunkGraph.getNodes();
        for (ModuleChunk moduleChunk : moduleChunks = nodes.toArray(new ModuleChunk[nodes.size()])) {
            Iterator depsIterator = moduleChunkGraph.getIn((Object)moduleChunk);
            ArrayList deps = new ArrayList();
            while (depsIterator.hasNext()) {
                deps.add(depsIterator.next());
            }
            moduleChunk.setDependentChunks(deps.toArray(new ModuleChunk[deps.size()]));
            ContainerUtil.addAll(this.myCustomCompilers, (Object[])moduleChunk.getCustomCompilers());
        }
        Arrays.sort(moduleChunks, new ChunksComparator());
        if (this.generateSingleFile) {
            File baseDir = BuildProperties.getProjectBaseDir((Project)this.myProject);
            for (ModuleChunk chunk : moduleChunks) {
                chunk.setBaseDir(baseDir);
            }
        }
        return moduleChunks;
    }

    public ChunkCustomCompilerExtension[] getCustomCompilers() {
        ChunkCustomCompilerExtension[] sorted = this.myCustomCompilers.toArray(new ChunkCustomCompilerExtension[this.myCustomCompilers.size()]);
        Arrays.sort(sorted, ChunkCustomCompilerExtension.COMPARATOR);
        return sorted;
    }

    Set<String> getAllJdkUrls() {
        if (this.myJdkUrls != null) {
            return this.myJdkUrls;
        }
        Sdk[] projectJdks = ProjectJdkTable.getInstance().getAllJdks();
        this.myJdkUrls = new HashSet<String>();
        for (Sdk jdk : projectJdks) {
            ContainerUtil.addAll(this.myJdkUrls, (Object[])jdk.getRootProvider().getUrls(OrderRootType.CLASSES));
        }
        return this.myJdkUrls;
    }

    private static class ChunksComparator
    implements Comparator<ModuleChunk> {
        final Map<ModuleChunk, Integer> myCachedLevels = new HashMap<ModuleChunk, Integer>();

        private ChunksComparator() {
        }

        @Override
        public int compare(ModuleChunk o1, ModuleChunk o2) {
            int level2;
            int level1 = this.getChunkLevel(o1);
            return level1 == (level2 = this.getChunkLevel(o2)) ? o1.getName().compareToIgnoreCase(o2.getName()) : level1 - level2;
        }

        private int getChunkLevel(ModuleChunk chunk) {
            Integer level = this.myCachedLevels.get(chunk);
            if (level == null) {
                ModuleChunk[] chunks = chunk.getDependentChunks();
                if (chunks.length > 0) {
                    int maxLevel = 0;
                    for (ModuleChunk dependent : chunks) {
                        maxLevel = Math.max(maxLevel, this.getChunkLevel(dependent));
                    }
                    level = 1 + maxLevel;
                } else {
                    level = 0;
                }
                this.myCachedLevels.put(chunk, level);
            }
            return level;
        }
    }
}

