/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.chainsSearch.ChainOpAndOccurrences;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.SignatureData;

public class CompilerReferenceServiceImpl
extends CompilerReferenceServiceEx
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceServiceImpl.class);
    private final Set<FileType> myFileTypes;
    private final DirtyScopeHolder myDirtyScopeHolder;
    private final ProjectFileIndex myProjectFileIndex;
    private final LongAdder myCompilationCount = new LongAdder();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Lock myReadDataLock = this.myLock.readLock();
    private final Lock myOpenCloseLock = this.myLock.writeLock();
    private int myActiveBuilds = 0;
    private volatile CompilerReferenceReader myReader;

    public CompilerReferenceServiceImpl(Project project2, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager) {
        super(project2);
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.myFileTypes = Stream.of(LanguageLightRefAdapter.INSTANCES).flatMap(a -> a.getFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(this, fileDocumentManager, psiDocumentManager);
    }

    public void projectOpened() {
        if (CompilerReferenceServiceImpl.isEnabled()) {
            MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
            connection.subscribe(BuildManagerListener.TOPIC, (Object)new BuildManagerListener(){

                @Override
                public void buildStarted(Project project2, UUID sessionId, boolean isAutomake) {
                    if (project2 == CompilerReferenceServiceImpl.this.myProject) {
                        CompilerReferenceServiceImpl.this.closeReaderIfNeed(IndexCloseReason.COMPILATION_STARTED);
                    }
                }
            });
            connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

                public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    this.compilationFinished(compileContext);
                }

                public void automakeCompilationFinished(int errors, int warnings, CompileContext compileContext) {
                    this.compilationFinished(compileContext);
                }

                private void compilationFinished(CompileContext context) {
                    if (context.getProject() == CompilerReferenceServiceImpl.this.myProject) {
                        Runnable compilationFinished = () -> {
                            Module[] compilationModules = (Module[])ReadAction.compute(() -> {
                                if (CompilerReferenceServiceImpl.this.myProject.isDisposed()) {
                                    return null;
                                }
                                return context.getCompileScope().getAffectedModules();
                            });
                            if (compilationModules == null) {
                                return;
                            }
                            CompilerReferenceServiceImpl.this.openReaderIfNeed(IndexOpenReason.COMPILATION_FINISHED);
                        };
                        CompilerReferenceServiceImpl.executeOnBuildThread(compilationFinished);
                    }
                }
            });
            this.myDirtyScopeHolder.installVFSListener();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean isUpToDate;
                    boolean indexExist = CompilerReferenceReader.exists(this.myProject);
                    if (indexExist) {
                        CompileScope projectCompileScope = compilerManager.createProjectCompileScope(this.myProject);
                        isUpToDate = compilerManager.isUpToDate(projectCompileScope);
                    } else {
                        isUpToDate = false;
                    }
                    CompilerReferenceServiceImpl.executeOnBuildThread(() -> {
                        if (isUpToDate) {
                            this.openReaderIfNeed(IndexOpenReason.UP_TO_DATE_CACHE);
                        } else {
                            this.markAsOutdated(indexExist);
                        }
                    });
                });
            }
            Disposer.register((Disposable)this.myProject, () -> this.closeReaderIfNeed(IndexCloseReason.PROJECT_CLOSED));
        }
    }

    @Override
    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(0);
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(68);
                }
                return CachedValueProvider.Result.create((Object)this.calculateScopeWithoutReferences(element), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        catch (RuntimeException e) {
            return (GlobalSearchScope)this.onException(e, "scope without code references");
        }
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (aClass == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(1);
        }
        if (useScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(3);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(4);
        }
        return this.getHierarchyInfo(aClass, useScope, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (functionalInterface == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(5);
        }
        if (useScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(7);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(8);
        }
        return this.getHierarchyInfo(functionalInterface, useScope, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Override
    @Nullable
    public Integer getCompileTimeOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(9);
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (Integer)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(66);
                }
                return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(constructorSuggestion -> {
                    if (element == null) {
                        CompilerReferenceServiceImpl.$$$reportNull$$$0(67);
                    }
                    return this.calculateOccurrenceCount(element, (boolean)constructorSuggestion);
                }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            })).get(isConstructorSuggestion);
        }
        catch (RuntimeException e) {
            return (Integer)this.onException(e, "weighting for completion");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public SortedSet<ChainOpAndOccurrences<MethodCall>> findMethodReferenceOccurrences(@NotNull String rawReturnType, @SignatureData.IteratorKind byte iteratorKind, @NotNull ChainCompletionContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ChainOpAndOccurrences<TypeCast> getMostUsedTypeCast(@NotNull String operandQName) throws ReferenceIndexUnavailableException {
        if (operandQName == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(15);
        }
        try {
            this.myReadDataLock.lock();
            try {
                if (this.myReader == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                int nameId = this.getNameId(operandQName);
                if (nameId == 0) {
                    ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = null;
                    return chainOpAndOccurrences;
                }
                LightRef.JavaLightClassRef target2 = new LightRef.JavaLightClassRef(nameId);
                OccurrenceCounter<LightRef> typeCasts = this.myReader.getTypeCastOperands((LightRef.LightClassHierarchyElementDef)target2, null);
                LightRef bestCast = typeCasts.getBest();
                if (bestCast == null) {
                    ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = null;
                    return chainOpAndOccurrences;
                }
                ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = new ChainOpAndOccurrences<TypeCast>(new TypeCast((LightRef.LightClassHierarchyElementDef)bestCast, (LightRef.LightClassHierarchyElementDef)target2, this), typeCasts.getBestOccurrences());
                return chainOpAndOccurrences;
            }
            finally {
                this.myReadDataLock.unlock();
            }
        }
        catch (Exception e) {
            this.onException(e, "best type cast search");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LightRef.LightClassHierarchyElementDef mayCallOfTypeCast(@NotNull LightRef.JavaLightMethodRef method, int probabilityThreshold) throws ReferenceIndexUnavailableException {
        if (method == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(16);
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            TIntHashSet ids = this.myReader.getAllContainingFileIds((LightRef)method);
            LightRef.LightClassHierarchyElementDef owner2 = method.getOwner();
            OccurrenceCounter<LightRef> bestTypeCast = this.myReader.getTypeCastOperands(owner2, ids);
            LightRef best = bestTypeCast.getBest();
            LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef = best != null && ids.size() > probabilityThreshold * (ids.size() - bestTypeCast.getBestOccurrences()) ? (LightRef.LightClassHierarchyElementDef)best : null;
            this.myReadDataLock.unlock();
            return lightClassHierarchyElementDef;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "conditional probability");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mayHappen(@NotNull LightRef qualifier, @NotNull LightRef base, int probabilityThreshold) {
        if (qualifier == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(17);
        }
        if (base == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(18);
        }
        try {
            this.myReadDataLock.lock();
            try {
                if (this.myReader == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                TIntHashSet ids1 = this.myReader.getAllContainingFileIds(qualifier);
                TIntHashSet ids2 = this.myReader.getAllContainingFileIds(base);
                TIntHashSet intersection = CompilerReferenceServiceImpl.intersection(ids1, ids2);
                if ((ids2.size() - intersection.size()) * probabilityThreshold < ids2.size()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.myReadDataLock.unlock();
            }
        }
        catch (Exception e) {
            this.onException(e, "conditional probability");
            return false;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public String getName(int idx) throws ReferenceIndexUnavailableException {
        this.myReadDataLock.lock();
        if (this.myReader == null) {
            throw new ReferenceIndexUnavailableException();
        }
        String string = this.myReader.getNameEnumerator().getName(idx);
        this.myReadDataLock.unlock();
        String string2 = string;
        if (string2 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(19);
        }
        return string2;
        {
            catch (Throwable throwable) {
                try {
                    this.myReadDataLock.unlock();
                    throw throwable;
                }
                catch (Exception e) {
                    this.onException(e, "find methods");
                    throw new ReferenceIndexUnavailableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNameId(@NotNull String name2) throws ReferenceIndexUnavailableException {
        if (name2 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(20);
        }
        this.myReadDataLock.lock();
        try {
            int id;
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            int n = id = this.myReader.getNameEnumerator().tryEnumerate((Object)name2);
            this.myReadDataLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "get name-id");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public LightRef.LightClassHierarchyElementDef[] getDirectInheritors(@NotNull LightRef.LightClassHierarchyElementDef baseClass) throws ReferenceIndexUnavailableException {
        LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray;
        block7: {
            if (baseClass == null) {
                CompilerReferenceServiceImpl.$$$reportNull$$$0(21);
            }
            this.myReadDataLock.lock();
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            lightClassHierarchyElementDefArray = this.myReader.getDirectInheritors(baseClass);
            this.myReadDataLock.unlock();
            if (lightClassHierarchyElementDefArray != null) break block7;
            CompilerReferenceServiceImpl.$$$reportNull$$$0(22);
        }
        return lightClassHierarchyElementDefArray;
        {
            catch (Throwable throwable) {
                try {
                    this.myReadDataLock.unlock();
                    throw throwable;
                }
                catch (Exception e) {
                    this.onException(e, "find methods");
                    throw new ReferenceIndexUnavailableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInheritorCount(@NotNull LightRef.LightClassHierarchyElementDef baseClass) throws ReferenceIndexUnavailableException {
        if (baseClass == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(23);
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            LightRef.LightClassHierarchyElementDef[] hierarchy = this.myReader.getHierarchy(baseClass, false, true, -1);
            int n = hierarchy == null ? -1 : hierarchy.length;
            this.myReadDataLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "inheritor count");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    private Integer calculateOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(24);
        }
        LanguageLightRefAdapter adapter = null;
        if (isConstructorSuggestion && ((adapter = (LanguageLightRefAdapter)ReadAction.compute(() -> {
            if (element == null) {
                CompilerReferenceServiceImpl.$$$reportNull$$$0(63);
            }
            return LanguageLightRefAdapter.findAdapter(element);
        })) == null || !adapter.isClass(element))) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(element, false, false);
        if (searchElementInfo == null) {
            return null;
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                Integer n = null;
                return n;
            }
            if (isConstructorSuggestion) {
                int constructorOccurrences = 0;
                for (PsiElement constructor : adapter.getInstantiableConstructors(element)) {
                    LightRef lightConstructor = adapter.asLightUsage(constructor, this.myReader.getNameEnumerator());
                    if (lightConstructor == null) continue;
                    constructorOccurrences += this.myReader.getOccurrenceCount(lightConstructor);
                }
                Integer anonymousCount = this.myReader.getAnonymousCount((LightRef.LightClassHierarchyElementDef)searchElementInfo.searchElements[0], searchElementInfo.place == ElementPlace.SRC);
                Integer n = anonymousCount == null ? constructorOccurrences : constructorOccurrences + anonymousCount;
                return n;
            }
            Integer constructorOccurrences = this.myReader.getOccurrenceCount(searchElementInfo.searchElements[0]);
            return constructorOccurrences;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerHierarchyInfoImpl getHierarchyInfo(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (aClass == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(25);
        }
        if (useScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(26);
        }
        if (searchScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(27);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(28);
        }
        if (searchType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(29);
        }
        if (!this.isServiceEnabledFor((PsiElement)aClass) || searchScope == LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map candidatesPerFile = (Map)ReadAction.compute(() -> {
                if (aClass == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(55);
                }
                if (useScope == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(56);
                }
                if (searchType == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(57);
                }
                if (searchFileType == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(58);
                }
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
                    if (aClass == null) {
                        CompilerReferenceServiceImpl.$$$reportNull$$$0(59);
                    }
                    if (useScope == null) {
                        CompilerReferenceServiceImpl.$$$reportNull$$$0(60);
                    }
                    return CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(key2 -> {
                        if (aClass == null) {
                            CompilerReferenceServiceImpl.$$$reportNull$$$0(61);
                        }
                        if (useScope == null) {
                            CompilerReferenceServiceImpl.$$$reportNull$$$0(62);
                        }
                        return this.calculateDirectInheritors(aClass, useScope, ((HierarchySearchKey)key2).mySearchFileType, ((HierarchySearchKey)key2).mySearchType);
                    }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
                })).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (candidatesPerFile == null) {
                return null;
            }
            GlobalSearchScope dirtyScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> {
                if (aClass == null) {
                    CompilerReferenceServiceImpl.$$$reportNull$$$0(54);
                }
                return ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex);
            })) {
                dirtyScope = dirtyScope.union((SearchScope)LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(candidatesPerFile, aClass, dirtyScope, searchScope, this.myProject, searchFileType, searchType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (CompilerHierarchyInfoImpl)this.onException(e, "hierarchy");
        }
    }

    private boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isActive()) {
            return false;
        }
        PsiFile file2 = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return file2 != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(file2);
    }

    @Override
    public boolean isActive() {
        return this.myReader != null && CompilerReferenceServiceImpl.isEnabled();
    }

    private Map<VirtualFile, SearchId[]> calculateDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        CompilerElementInfo searchElementInfo;
        if (aClass == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(30);
        }
        if (useScope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(31);
        }
        if (searchFileType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(32);
        }
        if (searchType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(33);
        }
        if ((searchElementInfo = this.asCompilerElements((PsiElement)aClass, false, true)) == null) {
            return null;
        }
        LightRef searchElement = searchElementInfo.searchElements[0];
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                Map<VirtualFile, SearchId[]> map = null;
                return map;
            }
            Map<VirtualFile, SearchId[]> map = this.myReader.getDirectInheritors(searchElement, useScope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private GlobalSearchScope calculateScopeWithoutReferences(@NotNull PsiElement element) {
        TIntHashSet referentFileIds;
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(34);
        }
        if ((referentFileIds = this.getReferentFileIds(element)) == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(referentFileIds, this.myProjectFileIndex).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myDirtyScopeHolder.getDirtyScope())), (FileType[])this.myFileTypes.toArray(new FileType[this.myFileTypes.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TIntHashSet getReferentFileIds(@NotNull PsiElement element) {
        CompilerElementInfo compilerElementInfo;
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(35);
        }
        if ((compilerElementInfo = this.asCompilerElements(element, true, true)) == null) {
            return null;
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                TIntHashSet tIntHashSet = null;
                return tIntHashSet;
            }
            TIntHashSet referentFileIds = new TIntHashSet();
            for (TIntHashSet ref : compilerElementInfo.searchElements) {
                TIntHashSet referents;
                block12: {
                    try {
                        referents = this.myReader.findReferentFileIds((LightRef)ref, compilerElementInfo.place == ElementPlace.SRC);
                        if (referents != null) break block12;
                        TIntHashSet tIntHashSet = null;
                        return tIntHashSet;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                referentFileIds.addAll(referents.toArray());
            }
            TIntHashSet tIntHashSet = referentFileIds;
            return tIntHashSet;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements, boolean checkNotDirty) {
        if (psiElement == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(36);
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file2 == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace place = ElementPlace.get(file2, this.myProjectFileIndex);
            if (checkNotDirty && (place == null || place == ElementPlace.SRC && this.myDirtyScopeHolder.contains(file2))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageLightRefAdapter adapter = LanguageLightRefAdapter.findAdapter(file2);
            if (adapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LightRef ref = adapter.asLightUsage(psiElement, this.myReader.getNameEnumerator());
            if (ref == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (place == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                List<LightRef> elements = adapter.getHierarchyRestrictedToLibraryScope(ref, psiElement, this.myReader.getNameEnumerator(), LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope());
                LightRef[] fullHierarchy = new LightRef[elements.size() + 1];
                fullHierarchy[0] = ref;
                int i = 1;
                for (LightRef element : elements) {
                    fullHierarchy[i++] = element;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, fullHierarchy);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, new LightRef[]{ref});
            return compilerElementInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    private void closeReaderIfNeed(IndexCloseReason reason) {
        this.myOpenCloseLock.lock();
        try {
            if (reason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.myActiveBuilds;
                this.myDirtyScopeHolder.compilerActivityStarted();
            }
            if (this.myReader != null) {
                this.myReader.close(reason == IndexCloseReason.AN_EXCEPTION);
                this.myReader = null;
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void openReaderIfNeed(IndexOpenReason reason) {
        this.myCompilationCount.increment();
        this.myOpenCloseLock.lock();
        try {
            try {
                switch (reason) {
                    case UP_TO_DATE_CACHE: {
                        this.myDirtyScopeHolder.upToDateChecked(true);
                        break;
                    }
                    case COMPILATION_FINISHED: {
                        this.myDirtyScopeHolder.compilerActivityFinished();
                    }
                }
            }
            catch (RuntimeException e) {
                --this.myActiveBuilds;
                throw e;
            }
            if (--this.myActiveBuilds == 0 && this.myProject.isOpen()) {
                this.myReader = CompilerReferenceReader.create(this.myProject);
                LOG.info("backward reference index reader " + (this.myReader == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void markAsOutdated(boolean decrementBuildCount) {
        this.myOpenCloseLock.lock();
        try {
            if (decrementBuildCount) {
                --this.myActiveBuilds;
            }
            this.myDirtyScopeHolder.upToDateChecked(false);
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    ProjectFileIndex getFileIndex() {
        return this.myProjectFileIndex;
    }

    Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    Project getProject() {
        return this.myProject;
    }

    private static void executeOnBuildThread(Runnable compilationFinished) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(37);
        }
        FileBasedIndex fileIndex = FileBasedIndex.getInstance();
        TIntHashSet ids = this.getReferentFileIds(element);
        if (ids == null) {
            return null;
        }
        THashSet fileSet = new THashSet();
        ids.forEach(arg_0 -> this.lambda$getReferentFiles$21(fileIndex, (Set)fileSet, arg_0));
        return fileSet;
    }

    @NotNull
    public DirtyScopeHolder getDirtyScopeHolder() {
        DirtyScopeHolder dirtyScopeHolder = this.myDirtyScopeHolder;
        if (dirtyScopeHolder == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(38);
        }
        return dirtyScopeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(39);
        }
        this.myReadDataLock.lock();
        TIntHashSet referentFileIds = this.getReferentFileIds(element);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(referentFileIds, dirtyScopeInfo, this.myProject);
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo2 = compilerReferenceFindUsagesTestInfo;
        if (compilerReferenceFindUsagesTestInfo2 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(40);
        }
        return compilerReferenceFindUsagesTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(42);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(43);
        }
        this.myReadDataLock.lock();
        CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(44);
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(46);
        }
        if (fileType == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(47);
        }
        this.myReadDataLock.lock();
        CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(48);
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private <T> T onException(@NotNull Exception e, @NotNull String actionName) {
        Throwable unwrapped;
        if (e == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(49);
        }
        if (actionName == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(50);
        }
        if (e instanceof ControlFlowException) {
            throw (RuntimeException)e;
        }
        LOG.error("an exception during " + actionName + " calculation", (Throwable)e);
        Throwable throwable = unwrapped = e instanceof RuntimeException ? e.getCause() : e;
        if (CompilerReferenceServiceImpl.requireIndexRebuild(unwrapped)) {
            this.closeReaderIfNeed(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    private static TIntHashSet intersection(@NotNull TIntHashSet set1, @NotNull TIntHashSet set2) {
        if (set1 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(51);
        }
        if (set2 == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(52);
        }
        TIntHashSet result2 = (TIntHashSet)set1.clone();
        result2.retainAll(set2.toArray());
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(53);
        }
        return tIntHashSet;
    }

    private static boolean requireIndexRebuild(@Nullable Throwable exception) {
        return exception instanceof PersistentEnumeratorBase.CorruptedException || exception instanceof StorageException || exception instanceof IOException;
    }

    private /* synthetic */ boolean lambda$getReferentFiles$21(FileBasedIndex fileIndex, Set fileSet, int id) {
        VirtualFile vFile = fileIndex.findFileById(this.myProject, id);
        assert (vFile != null);
        fileSet.add(vFile);
        return true;
    }

    private static /* synthetic */ ChainOpAndOccurrences lambda$findMethodReferenceOccurrences$14(Map.Entry e) {
        return new ChainOpAndOccurrences<RefChainOperation>((RefChainOperation)e.getKey(), (int)((IntSummaryStatistics)e.getValue()).getSum());
    }

    private static /* synthetic */ int lambda$findMethodReferenceOccurrences$13(ChainOpAndOccurrences x) {
        return x.getOccurrenceCount();
    }

    private static /* synthetic */ MethodCall lambda$findMethodReferenceOccurrences$12(ChainOpAndOccurrences x) {
        return (MethodCall)x.getOperation();
    }

    private /* synthetic */ Stream lambda$findMethodReferenceOccurrences$11(@NotNull ChainCompletionContext context, SignatureData sd) {
        if (context == null) {
            CompilerReferenceServiceImpl.$$$reportNull$$$0(64);
        }
        return ((StreamEx)((StreamEx)StreamEx.of(this.myReader.getMembersFor(sd)).peek(r -> ProgressManager.checkCanceled())).select(LightRef.JavaLightMethodRef.class).flatMap(r -> {
            LightRef.LightClassHierarchyElementDef[] hierarchy = this.myReader.getHierarchy(r.getOwner(), false, false, 20);
            return hierarchy == null ? Stream.empty() : Arrays.stream(hierarchy).map(c -> r.override(c.getName()));
        }).distinct()).map(r -> {
            int count;
            if (context == null) {
                CompilerReferenceServiceImpl.$$$reportNull$$$0(65);
            }
            return (count = this.myReader.getOccurrenceCount((LightRef)r)) <= 1 ? null : new ChainOpAndOccurrences<MethodCall>(new MethodCall((LightRef.JavaLightMethodRef)r, sd, context), count);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 25: 
            case 30: 
            case 54: 
            case 55: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 6: 
            case 26: 
            case 31: 
            case 56: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useScope";
                break;
            }
            case 3: 
            case 7: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 8: 
            case 28: 
            case 32: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFileType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterface";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawReturnType";
                break;
            }
            case 11: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandQName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 29: 
            case 33: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodReferenceOccurrences";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectInheritors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeHolder";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFindUsages";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestHierarchy";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFunExpressions";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeWithoutCodeReferences";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritors";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunExpressions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeOccurrenceCount";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMethodReferenceOccurrences";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 53: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMostUsedTypeCast";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mayCallOfTypeCast";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mayHappen";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInheritorCount";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calculateOccurrenceCount";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyInfo";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectInheritors";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "calculateScopeWithoutReferences";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFileIds";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerElements";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getReferentFiles";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTestFindUsages";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTestHierarchy";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunExpressions";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "onException";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHierarchyInfo$19";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHierarchyInfo$18";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$17";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$16";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateOccurrenceCount$15";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMethodReferenceOccurrences$11";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompileTimeOccurrenceCount$6";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getScopeWithoutCodeReferences$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum IndexOpenReason {
        COMPILATION_FINISHED,
        UP_TO_DATE_CACHE;

    }

    private static enum IndexCloseReason {
        AN_EXCEPTION,
        COMPILATION_STARTED,
        PROJECT_CLOSED;

    }

    private static class HierarchySearchKey {
        private final CompilerHierarchySearchType mySearchType;
        private final FileType mySearchFileType;

        HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.mySearchType = searchType;
            this.mySearchFileType = searchFileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchySearchKey key2 = (HierarchySearchKey)o;
            return this.mySearchType == key2.mySearchType && this.mySearchFileType == key2.mySearchFileType;
        }

        public int hashCode() {
            return 31 * this.mySearchType.hashCode() + this.mySearchFileType.hashCode();
        }
    }

    static class CompilerElementInfo {
        final ElementPlace place;
        final LightRef[] searchElements;

        private CompilerElementInfo(ElementPlace place, LightRef ... searchElements) {
            this.place = place;
            this.searchElements = searchElements;
        }
    }

    private static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final TIntHashSet myReferentIds;
        private final ProjectFileIndex myIndex;

        private ScopeWithoutReferencesOnCompilation(TIntHashSet ids, ProjectFileIndex index) {
            this.myReferentIds = ids;
            this.myIndex = index;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ScopeWithoutReferencesOnCompilation.$$$reportNull$$$0(0);
            }
            return file2 instanceof VirtualFileWithId && this.myIndex.isInSourceContent(file2) && !this.myReferentIds.contains(((VirtualFileWithId)file2).getId());
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ScopeWithoutReferencesOnCompilation.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                ScopeWithoutReferencesOnCompilation.$$$reportNull$$$0(2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ScopeWithoutReferencesOnCompilation.$$$reportNull$$$0(3);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ElementPlace {
        SRC,
        LIB;


        private static ElementPlace get(VirtualFile file2, ProjectFileIndex index) {
            if (file2 == null) {
                return null;
            }
            return index.isInSourceContent(file2) ? SRC : (index.isInLibrarySource(file2) || index.isInLibraryClasses(file2) ? LIB : null);
        }
    }
}

