/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceImpl;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompilerElementRetriever {
    private static final Logger LOG = Logger.getInstance(JavaCompilerElementRetriever.class);
    private static final TokenSet FUN_EXPR = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION, JavaElementType.METHOD_REF_EXPRESSION});

    @NotNull
    static PsiFunctionalExpression[] retrieveFunExpressionsByIndices(@NotNull TIntHashSet indices2, @NotNull PsiFileWithStubSupport psiFile) {
        if (indices2 == null) {
            JavaCompilerElementRetriever.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            JavaCompilerElementRetriever.$$$reportNull$$$0(1);
        }
        StubbedSpine spine = psiFile.getStubbedSpine();
        Object[] result2 = new PsiFunctionalExpression[indices2.size()];
        int resIdx = 0;
        int funExprIdx = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            if (!FUN_EXPR.contains(spine.getStubType(i)) || !indices2.contains(funExprIdx++)) continue;
            result2[resIdx++] = (PsiFunctionalExpression)spine.getStubPsi(i);
        }
        if (result2.length != resIdx) {
            CompilerReferenceServiceImpl compilerReferenceService = (CompilerReferenceServiceImpl)CompilerReferenceService.getInstance(psiFile.getProject());
            Set<Module> state = compilerReferenceService.getDirtyScopeHolder().getAllDirtyModules();
            VirtualFile file2 = psiFile.getVirtualFile();
            Module moduleForFile = ProjectFileIndex.getInstance((Project)psiFile.getProject()).getModuleForFile(file2);
            LOG.error("Compiler functional expression index doesn't match to stub index.\nFunctional expression indices: " + indices2 + "\nDoes the file belong to dirty scope?: " + state.contains(moduleForFile), new Attachment[]{new Attachment(psiFile.getName(), psiFile.getText())});
            PsiFunctionalExpression[] psiFunctionalExpressionArray = ContainerUtil.filter((Object[])result2, Objects::nonNull).toArray(PsiFunctionalExpression.EMPTY_ARRAY);
            if (psiFunctionalExpressionArray == null) {
                JavaCompilerElementRetriever.$$$reportNull$$$0(2);
            }
            return psiFunctionalExpressionArray;
        }
        if (result2 == null) {
            JavaCompilerElementRetriever.$$$reportNull$$$0(3);
        }
        return result2;
    }

    @NotNull
    static PsiClass[] retrieveClassesByInternalIds(@NotNull SearchId[] internalIds, @NotNull PsiFileWithStubSupport psiFile) {
        if (internalIds == null) {
            JavaCompilerElementRetriever.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            JavaCompilerElementRetriever.$$$reportNull$$$0(5);
        }
        ClassMatcher matcher = ClassMatcher.create(internalIds);
        PsiClass[] psiClassArray = (PsiClass[])ReadAction.compute(() -> {
            if (psiFile == null) {
                JavaCompilerElementRetriever.$$$reportNull$$$0(7);
            }
            return matcher.retrieveClasses(psiFile);
        });
        if (psiClassArray == null) {
            JavaCompilerElementRetriever.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveFunExpressionsByIndices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveClassesByInternalIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retrieveFunExpressionsByIndices";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "retrieveClassesByInternalIds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$retrieveClassesByInternalIds$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClassMatcher {
        @Nullable
        private final TIntHashSet myAnonymousIndices;
        @NotNull
        private final Collection<InternalNameMatcher> myClassNameMatchers;

        private ClassMatcher(@Nullable TIntHashSet anonymousIndices, @NotNull Collection<InternalNameMatcher> nameMatchers) {
            if (nameMatchers == null) {
                ClassMatcher.$$$reportNull$$$0(0);
            }
            this.myAnonymousIndices = anonymousIndices;
            this.myClassNameMatchers = nameMatchers;
        }

        private PsiClass[] retrieveClasses(PsiFileWithStubSupport file2) {
            StubbedSpine spine = file2.getStubbedSpine();
            ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(this.myClassNameMatchers.size() + (this.myAnonymousIndices == null ? 0 : this.myAnonymousIndices.size()));
            int anonymousId = 0;
            for (int i = 0; i < spine.getStubCount(); ++i) {
                if (!Constants.CLASS_BIT_SET.contains(spine.getStubType(i))) continue;
                PsiClass element = (PsiClass)spine.getStubPsi(i);
                if (element instanceof PsiAnonymousClass) {
                    if (this.myAnonymousIndices == null || this.myAnonymousIndices.isEmpty()) continue;
                    if (this.myAnonymousIndices.contains(anonymousId)) {
                        result2.add(element);
                    }
                    ++anonymousId;
                    continue;
                }
                if (!ClassMatcher.match(element, this.myClassNameMatchers)) continue;
                result2.add(element);
            }
            return result2.toArray(PsiClass.EMPTY_ARRAY);
        }

        private static boolean match(PsiClass psiClass, Collection<InternalNameMatcher> matchers) {
            for (InternalNameMatcher matcher : matchers) {
                if (!matcher.matches(psiClass)) continue;
                if (matcher instanceof InternalNameMatcher.ByQualifiedName) {
                    matchers.remove(matcher);
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static ClassMatcher create(@NotNull SearchId[] internalIds) {
            if (internalIds == null) {
                ClassMatcher.$$$reportNull$$$0(1);
            }
            SmartList nameMatchers = new SmartList();
            TIntHashSet anonymousIndices = null;
            SearchId[] searchIdArray = internalIds;
            int n = searchIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchId internalId = searchIdArray[n2];
                if (internalId.getId() != -1) {
                    if (anonymousIndices == null) {
                        anonymousIndices = new TIntHashSet();
                    }
                    anonymousIndices.add(internalId.getId());
                } else {
                    String internalName = internalId.getDeserializedName();
                    int curLast = internalName.length() - 1;
                    while (true) {
                        int lastIndex;
                        if ((lastIndex = internalName.lastIndexOf(36, curLast)) > -1 && lastIndex < internalName.length() - 1) {
                            int followingIndex = lastIndex + 1;
                            boolean digit = Character.isDigit(internalName.charAt(followingIndex));
                            if (digit) {
                                if (curLast == internalName.length() - 1) {
                                    int nextNonDigit = ClassMatcher.getNextNonDigitIndex(internalName, followingIndex);
                                    if (nextNonDigit == -1) {
                                        throw new IllegalStateException();
                                    }
                                    nameMatchers.add(new InternalNameMatcher.ByName(internalName.substring(nextNonDigit)));
                                } else {
                                    nameMatchers.add(new InternalNameMatcher.ByName(StringUtil.getShortName((String)internalName, (char)'$')));
                                    break;
                                }
                            }
                        } else {
                            nameMatchers.add(new InternalNameMatcher.ByQualifiedName(StringUtil.replace((String)internalName, (String)"$", (String)".")));
                            break;
                        }
                        curLast = lastIndex - 1;
                    }
                }
                ++n2;
            }
            return new ClassMatcher(anonymousIndices, (Collection<InternalNameMatcher>)nameMatchers);
        }

        private static int getNextNonDigitIndex(String name2, int digitIndex) {
            for (int i = digitIndex + 1; i < name2.length(); ++i) {
                if (Character.isDigit(name2.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameMatchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalIds";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaCompilerElementRetriever$ClassMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface InternalNameMatcher {
        public boolean matches(PsiClass var1);

        public static class ByQualifiedName
        implements InternalNameMatcher {
            private final String myQName;

            public ByQualifiedName(String name2) {
                this.myQName = name2;
            }

            @Override
            public boolean matches(PsiClass psiClass) {
                return this.myQName.equals(psiClass.getQualifiedName());
            }
        }

        public static class ByName
        implements InternalNameMatcher {
            private final String myName;

            public ByName(String name2) {
                this.myName = name2;
            }

            @Override
            public boolean matches(PsiClass psiClass) {
                return this.myName.equals(psiClass.getName());
            }
        }
    }
}

