/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.completion.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PreferByKindWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ChainCompletionNewVariableLookupElement
extends LookupElement {
    @NotNull
    private final PsiClass myQualifierClass;
    @NotNull
    private final String myNewVarName;
    private final boolean myField;

    public ChainCompletionNewVariableLookupElement(@NotNull PsiClass qualifierClass, @NotNull ChainCompletionContext context) {
        if (qualifierClass == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(1);
        }
        Project project2 = qualifierClass.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        this.myField = PsiTreeUtil.getParentOfType((PsiElement)context.getContextPsi(), PsiStatement.class, (boolean)false) == null;
        VariableKind variableKind = this.myField ? VariableKind.FIELD : VariableKind.LOCAL_VARIABLE;
        this.myNewVarName = Stream.of(codeStyleManager.suggestVariableName((VariableKind)variableKind, null, null, (PsiType)elementFactory.createType((PsiClass)qualifierClass)).names).sorted(Comparator.comparing(String::length).reversed()).findFirst().orElseThrow(IllegalStateException::new);
        this.myQualifierClass = qualifierClass;
        this.putUserData(PreferByKindWeigher.INTRODUCED_VARIABLE, Boolean.TRUE);
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
    }

    public void handleInsert(InsertionContext context) {
        PsiDeclarationStatement newVarDeclarationTemplate;
        PsiElement newVariablePlacementAnchor;
        PsiFile file2 = context.getFile();
        PsiElement caretElement = (PsiElement)ObjectUtils.notNull((Object)file2.findElementAt(context.getEditor().getCaretModel().getOffset()));
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        if (this.myField) {
            PsiField field = (PsiField)ObjectUtils.notNull((Object)PsiTreeUtil.getParentOfType((PsiElement)caretElement.getPrevSibling(), PsiField.class, (boolean)false));
            newVariablePlacementAnchor = field;
            PsiField newField = elementFactory.createField(this.myNewVarName, (PsiType)elementFactory.createType(this.myQualifierClass));
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)newField, (String)"static", (boolean)true);
            }
            newVarDeclarationTemplate = newField;
        } else {
            newVariablePlacementAnchor = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.getParentOfType((PsiElement)caretElement.getPrevSibling(), PsiStatement.class, (boolean)false));
            newVarDeclarationTemplate = elementFactory.createVariableDeclarationStatement(this.myNewVarName, (PsiType)elementFactory.createType(this.myQualifierClass), elementFactory.createExpressionFromText("null", null));
        }
        PsiElement varDeclaration = newVariablePlacementAnchor.getParent().addBefore((PsiElement)newVarDeclarationTemplate, newVariablePlacementAnchor);
        JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences(varDeclaration);
    }

    @NotNull
    public String getLookupString() {
        String string = this.myNewVarName;
        if (string == null) {
            ChainCompletionNewVariableLookupElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/completion/lookup/ChainCompletionNewVariableLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/completion/lookup/ChainCompletionNewVariableLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

