/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private final List<CompileScope> myScopes = new ArrayList<CompileScope>();

    public CompositeScope(CompileScope scope1, CompileScope scope2) {
        this.addScope(scope1);
        this.addScope(scope2);
    }

    public CompositeScope(CompileScope[] scopes) {
        for (CompileScope scope : scopes) {
            this.addScope(scope);
        }
    }

    private void addScope(CompileScope scope) {
        if (scope instanceof CompositeScope) {
            CompositeScope compositeScope = (CompositeScope)scope;
            for (CompileScope childScope : compositeScope.myScopes) {
                this.addScope(childScope);
            }
        } else {
            this.myScopes.add(scope);
        }
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        THashSet allFiles = new THashSet();
        for (CompileScope scope : this.myScopes) {
            Object[] files = scope.getFiles(fileType, inSourceOnly);
            if (files.length <= 0) continue;
            ContainerUtil.addAll((Collection)allFiles, (Object[])files);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)allFiles);
        if (virtualFileArray == null) {
            CompositeScope.$$$reportNull$$$0(0);
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        for (CompileScope scope : this.myScopes) {
            if (!scope.belongs(url)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Module[] getAffectedModules() {
        HashSet modules = new HashSet();
        for (CompileScope compileScope : this.myScopes) {
            ContainerUtil.addAll(modules, (Object[])compileScope.getAffectedModules());
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            CompositeScope.$$$reportNull$$$0(1);
        }
        return moduleArray;
    }

    @NotNull
    public Collection<String> getAffectedUnloadedModules() {
        LinkedHashSet<String> unloadedModules = new LinkedHashSet<String>();
        for (CompileScope compileScope : this.myScopes) {
            ContainerUtil.addAll(unloadedModules, (Iterable)compileScope.getAffectedUnloadedModules());
        }
        LinkedHashSet<String> linkedHashSet = unloadedModules;
        if (linkedHashSet == null) {
            CompositeScope.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            CompositeScope.$$$reportNull$$$0(3);
        }
        for (CompileScope compileScope : this.myScopes) {
            Object userData = compileScope.getUserData(key2);
            if (userData == null) continue;
            return (T)userData;
        }
        return (T)super.getUserData(key2);
    }

    public Collection<CompileScope> getScopes() {
        return Collections.unmodifiableList(this.myScopes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/CompositeScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedUnloadedModules";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/CompositeScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

