/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.generic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GenericCompilerPersistentData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.generic.GenericCompilerPersistentData");
    private static final int VERSION = 1;
    private File myFile;
    private Map<String, Integer> myTarget2Id = new HashMap<String, Integer>();
    private TIntHashSet myUsedIds = new TIntHashSet();
    private boolean myVersionChanged;
    private final int myCompilerVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericCompilerPersistentData(File cacheStoreDirectory, int compilerVersion) throws IOException {
        this.myCompilerVersion = compilerVersion;
        this.myFile = new File(cacheStoreDirectory, "info");
        if (!this.myFile.exists()) {
            LOG.info("Compiler info file doesn't exists: " + this.myFile.getAbsolutePath());
            this.myVersionChanged = true;
            return;
        }
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));){
            int dataVersion = input.readInt();
            if (dataVersion != 1) {
                LOG.info("Version of compiler info file (" + this.myFile.getAbsolutePath() + ") changed: " + dataVersion + " -> " + 1);
                this.myVersionChanged = true;
                return;
            }
            int savedCompilerVersion = input.readInt();
            if (savedCompilerVersion != compilerVersion) {
                LOG.info("Compiler caches version changed (" + this.myFile.getAbsolutePath() + "): " + savedCompilerVersion + " -> " + compilerVersion);
                this.myVersionChanged = true;
                return;
            }
            int size = input.readInt();
            while (size-- > 0) {
                String target2 = IOUtil.readString((DataInput)input);
                int id = input.readInt();
                this.myTarget2Id.put(target2, id);
                this.myUsedIds.add(id);
            }
        }
        catch (IOException e) {
            FileUtil.delete((File)this.myFile);
            throw e;
        }
    }

    public boolean isVersionChanged() {
        return this.myVersionChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.myFile)));){
            output.writeInt(1);
            output.writeInt(this.myCompilerVersion);
            output.writeInt(this.myTarget2Id.size());
            for (Map.Entry<String, Integer> entry : this.myTarget2Id.entrySet()) {
                IOUtil.writeString((String)entry.getKey(), (DataOutput)output);
                output.writeInt(entry.getValue());
            }
        }
    }

    public int getId(@NotNull String target2) {
        if (target2 == null) {
            GenericCompilerPersistentData.$$$reportNull$$$0(0);
        }
        if (this.myTarget2Id.containsKey(target2)) {
            return this.myTarget2Id.get(target2);
        }
        int id = 0;
        while (this.myUsedIds.contains(id)) {
            ++id;
        }
        this.myTarget2Id.put(target2, id);
        this.myUsedIds.add(id);
        return id;
    }

    public Set<String> getAllTargets() {
        return this.myTarget2Id.keySet();
    }

    public int removeId(String target2) {
        return this.myTarget2Id.remove(target2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/compiler/impl/generic/GenericCompilerPersistentData", "getId"));
    }
}

