/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CoreProjectScopeBuilder
extends ProjectScopeBuilder {
    private final Project myProject;
    private final FileIndexFacade myFileIndexFacade;
    private final CoreLibrariesScope myLibrariesScope;

    public CoreProjectScopeBuilder(Project project2, FileIndexFacade fileIndexFacade) {
        this.myFileIndexFacade = fileIndexFacade;
        this.myProject = project2;
        this.myLibrariesScope = new CoreLibrariesScope();
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        CoreLibrariesScope coreLibrariesScope = this.myLibrariesScope;
        if (coreLibrariesScope == null) {
            CoreProjectScopeBuilder.$$$reportNull$$$0(0);
        }
        return coreLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        EverythingGlobalScope everythingGlobalScope = new EverythingGlobalScope();
        if (everythingGlobalScope == null) {
            CoreProjectScopeBuilder.$$$reportNull$$$0(1);
        }
        return everythingGlobalScope;
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        ProjectScopeImpl projectScopeImpl = new ProjectScopeImpl(this.myProject, this.myFileIndexFacade);
        if (projectScopeImpl == null) {
            CoreProjectScopeBuilder.$$$reportNull$$$0(2);
        }
        return projectScopeImpl;
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        ContentSearchScope contentSearchScope = new ContentSearchScope(this.myProject, this.myFileIndexFacade);
        if (contentSearchScope == null) {
            CoreProjectScopeBuilder.$$$reportNull$$$0(3);
        }
        return contentSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/core/CoreProjectScopeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLibrariesScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProjectScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildContentScope";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ContentSearchScope
    extends GlobalSearchScope {
        private final FileIndexFacade myFileIndexFacade;

        public ContentSearchScope(Project project2, FileIndexFacade fileIndexFacade) {
            super(project2);
            this.myFileIndexFacade = fileIndexFacade;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ContentSearchScope.$$$reportNull$$$0(0);
            }
            return this.myFileIndexFacade.isInContent(file2);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ContentSearchScope.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                ContentSearchScope.$$$reportNull$$$0(2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ContentSearchScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return this.myFileIndexFacade.getUnloadedModuleDescriptions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CoreLibrariesScope
    extends GlobalSearchScope {
        private CoreLibrariesScope() {
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                CoreLibrariesScope.$$$reportNull$$$0(0);
            }
            return CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibraryClasses(file2) || CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibrarySource(file2);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                CoreLibrariesScope.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                CoreLibrariesScope.$$$reportNull$$$0(2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                CoreLibrariesScope.$$$reportNull$$$0(3);
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

