/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.psi.PsiExpression;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReferringObjectsValue
extends JavaValue {
    private static final long MAX_REFERRING = 100L;
    private final boolean myIsField;

    private JavaReferringObjectsValue(@Nullable JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean isField) {
        if (valueDescriptor == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(1);
        }
        super(parent, valueDescriptor, evaluationContext, nodeManager, false);
        this.myIsField = isField;
    }

    public JavaReferringObjectsValue(@NotNull JavaValue javaValue, boolean isField) {
        if (javaValue == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(2);
        }
        super(null, javaValue.getDescriptor(), javaValue.getEvaluationContext(), javaValue.getNodeManager(), false);
        this.myIsField = isField;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Override
    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(3);
        }
        JavaReferringObjectsValue.scheduleCommand(this.getEvaluationContext(), node, new SuspendContextCommandImpl(this.getEvaluationContext().getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                List<ObjectReference> references;
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                XValueChildrenList children2 = new XValueChildrenList();
                Value value2 = JavaReferringObjectsValue.this.getDescriptor().getValue();
                try {
                    references = ((ObjectReference)value2).referringObjects(100L);
                }
                catch (ObjectCollectedException e) {
                    node.setErrorMessage(DebuggerBundle.message((String)"evaluation.error.object.collected", (Object[])new Object[0]));
                    return;
                }
                int i = 1;
                for (final ObjectReference reference : references) {
                    ValueDescriptorImpl descriptor2;
                    Field field = JavaReferringObjectsValue.findField(reference, value2);
                    if (field != null) {
                        descriptor2 = new FieldDescriptorImpl(JavaReferringObjectsValue.this.getProject(), reference, field){

                            @Override
                            public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                                return reference;
                            }
                        };
                        children2.add((XNamedValue)new JavaReferringObjectsValue(null, descriptor2, JavaReferringObjectsValue.this.getEvaluationContext(), JavaReferringObjectsValue.this.getNodeManager(), true));
                        ++i;
                        continue;
                    }
                    descriptor2 = new ValueDescriptorImpl(JavaReferringObjectsValue.this.getProject(), reference){

                        @Override
                        public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                            return reference;
                        }

                        @Override
                        public String getName() {
                            return "Ref";
                        }

                        @Override
                        public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
                            return null;
                        }
                    };
                    children2.add("Referrer " + i++, (XValue)new JavaReferringObjectsValue(null, descriptor2, JavaReferringObjectsValue.this.getEvaluationContext(), JavaReferringObjectsValue.this.getNodeManager(), false));
                }
                node.addChildren(children2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JavaReferringObjectsValue$1", "contextAction"));
            }
        });
    }

    @Override
    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(4);
        }
        if (place == null) {
            JavaReferringObjectsValue.$$$reportNull$$$0(5);
        }
        if (!this.myIsField) {
            super.computePresentation(node, place);
        } else {
            super.computePresentation(new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){

                @Override
                public void applyPresentation(@Nullable Icon icon, final @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                    if (valuePresenter == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    node.setPresentation(icon, new XValuePresentation(){

                        @NotNull
                        public String getSeparator() {
                            if (" in " == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return " in ";
                        }

                        @Nullable
                        public String getType() {
                            return valuePresenter.getType();
                        }

                        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                            if (renderer == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            valuePresenter.renderValue(renderer);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 1: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 1: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/debugger/actions/JavaReferringObjectsValue$2$1";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "renderer";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getSeparator";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/debugger/actions/JavaReferringObjectsValue$2$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "renderValue";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    }, hasChildren);
                }

                public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                    if (fullValueEvaluator == null) {
                        2.$$$reportNull$$$0(1);
                    }
                }

                public boolean isObsolete() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "valuePresenter";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fullValueEvaluator";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/JavaReferringObjectsValue$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applyPresentation";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setFullValueEvaluator";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, place);
        }
    }

    private static Field findField(ObjectReference reference, Value value2) {
        for (Field field : reference.referenceType().allFields()) {
            if (reference.getValue(field) != value2) continue;
            return field;
        }
        return null;
    }

    @Override
    @Nullable
    public XValueModifier getModifier() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/JavaReferringObjectsValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computePresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

