/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoActionHandler;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.PsiMethodListPopupStep;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.ClassInstanceMethodFilter;
import com.intellij.debugger.engine.LambdaAsyncMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JvmSmartStepIntoHandler {
    public static final ExtensionPointName<JvmSmartStepIntoHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.jvmSmartStepIntoHandler");

    @NotNull
    public abstract List<SmartStepTarget> findSmartStepTargets(SourcePosition var1);

    public abstract boolean isAvailable(SourcePosition var1);

    public boolean doSmartStep(SourcePosition position, DebuggerSession session2, TextEditor fileEditor) {
        return this.handleTargets(position, session2, fileEditor, this.findSmartStepTargets(position));
    }

    protected final boolean handleTargets(SourcePosition position, DebuggerSession session2, TextEditor fileEditor, List<SmartStepTarget> targets) {
        if (!targets.isEmpty()) {
            SmartStepTarget firstTarget = targets.get(0);
            if (targets.size() == 1) {
                this.doStepInto(session2, Registry.is((String)"debugger.single.smart.step.force"), firstTarget);
            } else {
                Editor editor = fileEditor.getEditor();
                final PsiMethodListPopupStep popupStep = new PsiMethodListPopupStep(editor, targets, chosenTarget -> this.doStepInto(session2, true, chosenTarget));
                ListPopupImpl popup2 = new ListPopupImpl(popupStep);
                DebuggerUIUtil.registerExtraHandleShortcuts(popup2, "StepInto", "SmartStepInto");
                popup2.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText("StepInto", "SmartStepInto"));
                UIUtil.maybeInstall((InputMap)popup2.getList().getInputMap(0), (String)"selectNextRow", (KeyStroke)KeyStroke.getKeyStroke(9, 0));
                popup2.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        SmartStepTarget selectedTarget;
                        popupStep.getScopeHighlighter().dropHighlight();
                        if (!e.getValueIsAdjusting() && (selectedTarget = (SmartStepTarget)((JBList)e.getSource()).getSelectedValue()) != null) {
                            JvmSmartStepIntoHandler.highlightTarget(popupStep, selectedTarget);
                        }
                    }
                });
                JvmSmartStepIntoHandler.highlightTarget(popupStep, firstTarget);
                DebuggerUIUtil.showPopupForEditorLine(popup2, editor, position.getLine());
            }
            return true;
        }
        return false;
    }

    protected void doStepInto(DebuggerSession session2, boolean force, SmartStepTarget target2) {
        JvmSmartStepIntoActionHandler.doStepInto(session2, force, this.createMethodFilter(target2));
    }

    private static void highlightTarget(PsiMethodListPopupStep popupStep, SmartStepTarget target2) {
        PsiElement highlightElement = target2.getHighlightElement();
        if (highlightElement != null) {
            popupStep.getScopeHighlighter().highlight(highlightElement, Collections.singletonList(highlightElement));
        }
    }

    @Nullable
    protected MethodFilter createMethodFilter(SmartStepTarget stepTarget) {
        if (stepTarget instanceof MethodSmartStepTarget) {
            PsiMethod method = ((MethodSmartStepTarget)stepTarget).getMethod();
            if (stepTarget.needsBreakpointRequest()) {
                return Registry.is((String)"debugger.async.smart.step.into") && method.getContainingClass() instanceof PsiAnonymousClass ? new ClassInstanceMethodFilter(method, stepTarget.getCallingExpressionLines()) : new AnonymousClassMethodFilter(method, stepTarget.getCallingExpressionLines());
            }
            return new BasicStepMethodFilter(method, stepTarget.getCallingExpressionLines());
        }
        if (stepTarget instanceof LambdaSmartStepTarget) {
            PsiElement method;
            PsiLambdaExpression lambda2;
            PsiElement expressionList;
            LambdaSmartStepTarget lambdaTarget = (LambdaSmartStepTarget)stepTarget;
            LambdaMethodFilter lambdaMethodFilter = new LambdaMethodFilter(lambdaTarget.getLambda(), lambdaTarget.getOrdinal(), stepTarget.getCallingExpressionLines());
            if (Registry.is((String)"debugger.async.smart.step.into") && lambdaTarget.isAsync() && (expressionList = (lambda2 = ((LambdaSmartStepTarget)stepTarget).getLambda()).getParent()) instanceof PsiExpressionList && (method = expressionList.getParent()) instanceof PsiMethodCallExpression) {
                return new LambdaAsyncMethodFilter(((PsiMethodCallExpression)method).resolveMethod(), LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)expressionList), (PsiElement)lambda2), lambdaMethodFilter);
            }
            return lambdaMethodFilter;
        }
        return null;
    }
}

