/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PsiMethodListPopupStep
implements ListPopupStep<SmartStepTarget> {
    private final List<SmartStepTarget> myTargets;
    private final OnChooseRunnable myStepRunnable;
    private final ScopeHighlighter myScopeHighlighter;

    public PsiMethodListPopupStep(Editor editor, List<SmartStepTarget> targets, OnChooseRunnable stepRunnable) {
        this.myTargets = targets;
        this.myScopeHighlighter = new ScopeHighlighter(editor);
        this.myStepRunnable = stepRunnable;
    }

    @NotNull
    public ScopeHighlighter getScopeHighlighter() {
        ScopeHighlighter scopeHighlighter = this.myScopeHighlighter;
        if (scopeHighlighter == null) {
            PsiMethodListPopupStep.$$$reportNull$$$0(0);
        }
        return scopeHighlighter;
    }

    @NotNull
    public List<SmartStepTarget> getValues() {
        List<SmartStepTarget> list2 = this.myTargets;
        if (list2 == null) {
            PsiMethodListPopupStep.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public boolean isSelectable(SmartStepTarget value2) {
        return true;
    }

    public Icon getIconFor(SmartStepTarget avalue) {
        return avalue.getIcon();
    }

    @NotNull
    public String getTextFor(SmartStepTarget value2) {
        String string = value2.getPresentation();
        if (string == null) {
            PsiMethodListPopupStep.$$$reportNull$$$0(2);
        }
        return string;
    }

    public ListSeparator getSeparatorAbove(SmartStepTarget value2) {
        return null;
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public String getTitle() {
        return DebuggerBundle.message((String)"title.smart.step.popup", (Object[])new Object[0]);
    }

    public PopupStep onChosen(SmartStepTarget selectedValue, boolean finalChoice) {
        if (finalChoice) {
            this.myScopeHighlighter.dropHighlight();
            this.myStepRunnable.execute(selectedValue);
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return null;
    }

    public boolean hasSubstep(SmartStepTarget selectedValue) {
        return false;
    }

    public void canceled() {
        this.myScopeHighlighter.dropHighlight();
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<SmartStepTarget> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public SpeedSearchFilter<SmartStepTarget> getSpeedSearchFilter() {
        return new SpeedSearchFilter<SmartStepTarget>(){

            public boolean canBeHidden(SmartStepTarget value2) {
                return true;
            }

            public String getIndexedString(SmartStepTarget value2) {
                return PsiMethodListPopupStep.this.getTextFor(value2);
            }
        };
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/actions/PsiMethodListPopupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static interface OnChooseRunnable {
        public void execute(SmartStepTarget var1);
    }
}

